/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.action;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.searchbox.action.AbstractMultiINodeActionBuilder;
import io.searchbox.action.AbstractMultiIndexActionBuilder;
import io.searchbox.action.AbstractMultiTypeActionBuilder;
import io.searchbox.action.Action;
import io.searchbox.annotations.JestId;
import io.searchbox.client.JestResult;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAction<T extends JestResult>
implements Action<T> {
    public static String CHARSET = "utf-8";
    protected static final Logger log = LoggerFactory.getLogger(AbstractAction.class);
    protected String indexName;
    protected String typeName;
    protected String nodes;
    protected Object payload;
    private final ConcurrentMap<String, Object> headerMap = new ConcurrentHashMap<String, Object>();
    private final Multimap<String, Object> parameterMap = LinkedHashMultimap.create();
    private final Set<String> cleanApiParameters = new LinkedHashSet<String>();
    private String URI;

    public AbstractAction() {
    }

    public AbstractAction(Builder builder) {
        this.parameterMap.putAll(builder.parameters);
        this.headerMap.putAll(builder.headers);
        this.cleanApiParameters.addAll(builder.cleanApiParameters);
        if (builder instanceof AbstractMultiIndexActionBuilder) {
            this.indexName = ((AbstractMultiIndexActionBuilder)builder).getJoinedIndices();
            if (builder instanceof AbstractMultiTypeActionBuilder) {
                this.indexName = ((AbstractMultiTypeActionBuilder)builder).getJoinedIndices();
                this.typeName = ((AbstractMultiTypeActionBuilder)builder).getJoinedTypes();
            }
        } else if (builder instanceof AbstractMultiINodeActionBuilder) {
            this.nodes = ((AbstractMultiINodeActionBuilder)builder).getJoinedNodes();
        }
    }

    protected T createNewElasticSearchResult(T result, String responseBody, int statusCode, String reasonPhrase, Gson gson) {
        JsonObject jsonMap = this.parseResponseBody(responseBody);
        ((JestResult)result).setResponseCode(statusCode);
        ((JestResult)result).setJsonString(responseBody);
        ((JestResult)result).setJsonObject(jsonMap);
        ((JestResult)result).setPathToResult(this.getPathToResult());
        if (this.isHttpSuccessful(statusCode)) {
            ((JestResult)result).setSucceeded(true);
            log.debug("Request and operation succeeded");
        } else {
            ((JestResult)result).setSucceeded(false);
            if (((JestResult)result).getErrorMessage() == null) {
                ((JestResult)result).setErrorMessage(statusCode + " " + (reasonPhrase == null ? "null" : reasonPhrase));
            }
            log.debug("Response is failed");
        }
        return result;
    }

    protected boolean isHttpSuccessful(int httpCode) {
        return httpCode / 100 == 2;
    }

    protected JsonObject parseResponseBody(String responseBody) {
        if (responseBody != null && !responseBody.trim().isEmpty()) {
            return new JsonParser().parse(responseBody).getAsJsonObject();
        }
        return new JsonObject();
    }

    public static String getIdFromSource(Object source) {
        Field[] fields;
        if (source == null) {
            return null;
        }
        for (Field field : fields = source.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(JestId.class)) continue;
            try {
                field.setAccessible(true);
                Object name = field.get(source);
                return name == null ? null : name.toString();
            }
            catch (IllegalAccessException e) {
                log.error("Unhandled exception occurred while getting annotated id from source", (Throwable)e);
            }
        }
        return null;
    }

    public Collection<Object> getParameter(String parameter) {
        return this.parameterMap.get((Object)parameter);
    }

    public Object getHeader(String header) {
        return this.headerMap.get(header);
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.headerMap;
    }

    @Override
    public String getURI() {
        String finalUri = this.URI;
        if (!this.parameterMap.isEmpty() || !this.cleanApiParameters.isEmpty()) {
            try {
                finalUri = finalUri + this.buildQueryString();
            }
            catch (UnsupportedEncodingException e) {
                log.error("Error occurred while adding parameters to uri.", (Throwable)e);
            }
        }
        return finalUri;
    }

    protected void setURI(String URI) {
        this.URI = URI;
    }

    @Override
    public String getData(Gson gson) {
        if (this.payload == null) {
            return null;
        }
        if (this.payload instanceof String) {
            return (String)this.payload;
        }
        return gson.toJson(this.payload);
    }

    @Override
    public String getPathToResult() {
        return null;
    }

    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        try {
            if (StringUtils.isNotBlank((CharSequence)this.indexName)) {
                sb.append(URLEncoder.encode(this.indexName, CHARSET));
                if (StringUtils.isNotBlank((CharSequence)this.typeName)) {
                    sb.append("/").append(URLEncoder.encode(this.typeName, CHARSET));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error occurred while adding index/type to uri", (Throwable)e);
        }
        return sb.toString();
    }

    protected String buildQueryString() throws UnsupportedEncodingException {
        StringBuilder queryString = new StringBuilder();
        if (!this.cleanApiParameters.isEmpty()) {
            queryString.append("/").append(StringUtils.join(this.cleanApiParameters, (String)","));
        }
        queryString.append("?");
        for (Map.Entry entry : this.parameterMap.entries()) {
            queryString.append(URLEncoder.encode((String)entry.getKey(), CHARSET)).append("=").append(URLEncoder.encode(entry.getValue().toString(), CHARSET)).append("&");
        }
        queryString.deleteCharAt(queryString.length() - 1);
        return queryString.toString();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("uri", (Object)this.getURI()).append("method", (Object)this.getRestMethodName()).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getURI()).append((Object)this.getRestMethodName()).append(this.getHeaders()).append(this.payload).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractAction rhs = (AbstractAction)obj;
        return new EqualsBuilder().append((Object)this.getURI(), (Object)rhs.getURI()).append((Object)this.getRestMethodName(), (Object)rhs.getRestMethodName()).append(this.getHeaders(), rhs.getHeaders()).append(this.payload, rhs.payload).isEquals();
    }

    @Override
    public abstract String getRestMethodName();

    protected static abstract class Builder<T extends Action, K> {
        protected Multimap<String, Object> parameters = LinkedHashMultimap.create();
        protected Map<String, Object> headers = new LinkedHashMap<String, Object>();
        protected Set<String> cleanApiParameters = new LinkedHashSet<String>();

        protected Builder() {
        }

        public K addCleanApiParameter(String key) {
            this.cleanApiParameters.add(key);
            return (K)this;
        }

        public K setParameter(String key, Object value) {
            this.parameters.put((Object)key, value);
            return (K)this;
        }

        @Deprecated
        public K setParameter(Map<String, Object> parameters) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                this.parameters.put((Object)entry.getKey(), entry.getValue());
            }
            return (K)this;
        }

        public K setHeader(String key, Object value) {
            this.headers.put(key, value);
            return (K)this;
        }

        public K setHeader(Map<String, Object> headers) {
            this.headers.putAll(headers);
            return (K)this;
        }

        public K refresh(boolean refresh) {
            return this.setParameter("refresh", refresh);
        }

        public K resultCasing(String caseParam) {
            this.setParameter("case", caseParam);
            return (K)this;
        }

        public abstract T build();
    }
}

