/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.impl;

import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.util.impl.String2FieldBridgeAdaptor;

public class NullEncodingFieldBridge
implements FieldBridge,
StringBridge {
    private final String2FieldBridgeAdaptor bridge;
    private final String nullMarker;

    public NullEncodingFieldBridge(StringBridge bridge, String nullMarker) {
        this.bridge = new String2FieldBridgeAdaptor(bridge);
        this.nullMarker = nullMarker;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            luceneOptions.addFieldToDocument(name, this.nullMarker, document);
        } else {
            this.bridge.set(name, value, document, luceneOptions);
        }
    }

    @Override
    public String objectToString(Object object) {
        if (object == null) {
            return this.nullMarker;
        }
        return this.bridge.objectToString(object);
    }
}

