/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.engine.impl.nullencoding.NullMarkerCodec;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class NullEncodingTwoWayFieldBridge
implements TwoWayFieldBridge {
    private static final Log LOG = LoggerFactory.make();
    private final TwoWayFieldBridge fieldBridge;
    private final NullMarkerCodec nullTokenCodec;

    public NullEncodingTwoWayFieldBridge(TwoWayFieldBridge fieldBridge, NullMarkerCodec nullTokenCodec) {
        this.fieldBridge = fieldBridge;
        this.nullTokenCodec = nullTokenCodec;
    }

    @Override
    public Object get(String name, Document document) {
        IndexableField field = document.getField(name);
        if (field == null) {
            LOG.loadingNonExistentField(name);
            return null;
        }
        if (this.nullTokenCodec.representsNullValue(field)) {
            return null;
        }
        return this.fieldBridge.get(name, document);
    }

    @Override
    public String objectToString(Object object) {
        if (object == null) {
            return this.nullTokenCodec.nullRepresentedAsString();
        }
        return this.fieldBridge.objectToString(object);
    }

    public TwoWayFieldBridge unwrap() {
        return this.fieldBridge;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            this.nullTokenCodec.encodeNullValue(name, document, luceneOptions);
        } else {
            this.fieldBridge.set(name, value, document, luceneOptions);
        }
    }

    public Query buildNullQuery(String fieldName) {
        return this.nullTokenCodec.createNullMatchingQuery(fieldName);
    }
}

