/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.logging.impl;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.analyzer.impl.LazyLuceneAnalyzer;
import org.hibernate.search.analyzer.impl.LazyRemoteAnalyzer;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.analyzer.impl.ScopedAnalyzer;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.EmptyQueryException;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.logging.impl.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="HSEARCH")
public interface Log
extends BasicLogger {
    public static final int JGROUPS_BACKEND_MESSAGES_START_ID = 200000;
    public static final int AVRO_SERIALIZATION_MESSAGES_START_ID = 300000;
    public static final int ES_BACKEND_MESSAGES_START_ID = 400000;

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="initialized \"blackhole\" backend. Index changes will be prepared but discarded!")
    public void initializedBlackholeBackend();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="closed \"blackhole\" backend.")
    public void closedBlackholeBackend();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16, value="Incorrect message type: %1$s")
    public void incorrectMessageType(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17, value="Work discarded, thread was interrupted while waiting for space to schedule: %1$s")
    public void interruptedWorkError(Runnable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Skipping directory synchronization, previous work still in progress: %1$s")
    public void skippingDirectorySynchronization(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="Unable to remove previous marker file from source of %1$s")
    public void unableToRemovePreviousMarket(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="Unable to create current marker in source of %1$s")
    public void unableToCreateCurrentMarker(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=21, value="Unable to synchronize source of %1$s")
    public void unableToSynchronizeSource(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22, value="Unable to determine current in source directory, will try again during the next synchronization")
    public void unableToDetermineCurrentInSourceDirectory();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=23, value="Unable to compare %1$s with %2$s.")
    public void unableToCompareSourceWithDestinationDirectory(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=24, value="Unable to reindex entity on collection change, id cannot be extracted: %1$s")
    public void idCannotBeExtracted(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25, value="Service provider has been used but not released: %1$s")
    public void serviceProviderNotReleased(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26, value="Fail to properly stop service: %1$s")
    public void stopServiceFailed(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=27, value="Going to reindex %d entities")
    public void indexingEntities(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="Reindexed %1$d entities")
    public void indexingEntitiesCompleted(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="Indexing completed. Reindexed %1$d entities. Unregistering MBean from server")
    public void indexingCompletedAndMBeanUnregistered(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=30, value="%1$d documents indexed in %2$d ms")
    public void indexingDocumentsCompleted(long var1, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=31, value="Indexing speed: %1$f documents/second; progress: %2$.2f%%")
    public void indexingSpeed(float var1, float var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=32, value="Could not delete %1$s")
    public void notDeleted(File var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=33, value="Could not change timestamp for %1$s. Index synchronization may be slow.")
    public void notChangeTimestamp(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=34, value="Hibernate Search %1$s")
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=35, value="Could not close resource.")
    public void couldNotCloseResource(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="Cannot guess the Transaction Status: not starting a JTA transaction")
    public void cannotGuessTransactionStatus(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=37, value="Unable to properly close searcher during lucene query: %1$s")
    public void unableToCloseSearcherDuringQuery(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=38, value="Forced to use Document extraction to workaround FieldCache bug in Lucene")
    public void forceToUseDocumentExtraction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=39, value="Unable to properly close searcher in ScrollableResults")
    public void unableToCloseSearcherInScrollableResult(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40, value="Unexpected: value is missing from FieldCache. This is likely a bug in the FieldCache implementation, Hibernate Search might have to workaround this by slightly inaccurate faceting values or reduced performance.")
    public void unexpectedValueMissingFromFieldCache();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=41, value="Index directory not found, creating: '%1$s'")
    public void indexDirectoryNotFoundCreatingNewOne(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=42, value="No current marker in source directory. Has the master being started already?")
    public void noCurrentMarkerInSourceDirectory();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=43, value="Found current marker in source directory - initialization succeeded")
    public void foundCurrentMarker();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=44, value="Abstract classes cannot be indexed directly. Only concrete subclasses can be indexed. @Indexed on '%s' is superfluous and should be removed.")
    public void abstractClassesCannotInsertDocuments(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=45, value="@ContainedIn is pointing to an entity having @ProvidedId: %1$s. This is not supported, indexing of contained in entities will be skipped. Indexed data of the embedded object might become out of date in objects of type ")
    public void containedInPointsToProvidedId(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=46, value="FieldCache was enabled on class %1$s but for this type of identifier we can't extract values from the FieldCache: cache disabled")
    public void cannotExtractValueForIdentifier(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=47, value="Unable to close JMS connection for %1$s")
    public void unableToCloseJmsConnection(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=48, value="Unable to retrieve named analyzer: %1$s")
    public void unableToRetrieveNamedAnalyzer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=49, value="Was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock")
    public void interruptedWhileWaitingForIndexActivity(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=50, value="It appears changes are being pushed to the index out of a transaction. Register the IndexWorkFlushEventListener listener on flush to correctly manage Collections!")
    public void pushedChangesOutOfTransaction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=52, value="Going to force release of the IndexWriter lock")
    public void forcingReleaseIndexWriterLock();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=53, value="Chunk size must be positive: using default value.")
    public void checkSizeMustBePositive();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=54, value="ReaderProvider contains readers not properly closed at destroy time")
    public void readersNotProperlyClosedInReaderProvider();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=55, value="Unable to close Lucene IndexReader")
    public void unableToCloseLuceneIndexReader(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=56, value="Unable to un-register existing MBean: %1$s")
    public void unableToUnregisterExistingMBean(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=58, value="%1$s")
    public void exceptionOccurred(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=59, value="Worker raises an exception on close()")
    public void workerException(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=62, value="Batch indexing was interrupted")
    public void interruptedBatchIndexing();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=65, value="Error while rolling back transaction after %1$s")
    public void errorRollingBackTransaction(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=66, value="Failed to initialize SlaveDirectoryProvider %1$s")
    public void failedSlaveDirectoryProviderInitialization(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=67, value="Unable to properly close Lucene directory %1$s")
    public void unableToCloseLuceneDirectory(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=68, value="Unable to retrieve object from message: %1$s")
    public void unableToRetrieveObjectFromMessage(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=69, value="Illegal object retrieved from message")
    public void illegalObjectRetrievedFromMessage(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=72, value="Couldn't open the IndexWriter because of previous error: operation skipped, index ouf of sync!")
    public void cannotOpenIndexWriterCausePreviousError();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=73, value="Error in backend")
    public void backendError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=75, value="Configuration setting hibernate.search.lucene_version was not specified: using LUCENE_CURRENT.")
    public void recommendConfiguringLuceneVersion();

    @Message(id=76, value="Could not open Lucene index: index data is corrupted. index name: '%1$s'")
    public SearchException cantOpenCorruptedIndex(@Cause CorruptIndexException var1, String var2);

    @Message(id=77, value="An IOException happened while accessing the Lucene index '%1$s'")
    public SearchException ioExceptionOnIndex(@Cause IOException var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=78, value="Timed out waiting to flush all operations to the backend of index %1$s")
    public void unableToShutdownAsynchronousIndexingByTimeout(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=79, value="Serialization protocol version %1$d.%2$d initialized")
    public void serializationProtocol(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=80, value="Received a remote message about an unknown index '%1$s': discarding message!")
    public void messageReceivedForUndefinedIndex(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=81, value="The index '%1$s' is using a non-recommended combination of backend and directoryProvider implementations")
    public void warnSuspiciousBackendDirectoryCombination(String var1);

    @Message(id=83, value="Unable to serialize List<LuceneWork>")
    public SearchException unableToSerializeLuceneWorks(@Cause Throwable var1);

    @Message(id=84, value="Unable to read serialized List<LuceneWork>")
    public SearchException unableToReadSerializedLuceneWorks(@Cause Throwable var1);

    @Message(id=85, value="Attribute type is not recognized and not serializable: %1$s")
    public SearchException attributeNotRecognizedNorSerializable(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=86, value="Unknown attribute serialized representation: %1$s")
    public SearchException unknownAttributeSerializedRepresentation(String var1);

    @Message(id=87, value="Unable to read TokenStream")
    public SearchException unableToReadTokenStream();

    @Message(id=90, value="Unable to convert serializable Store to Lucene Store: %1$s")
    public SearchException unableToConvertSerializableStoreToLuceneStore(String var1);

    @Message(id=91, value="Unknown NumericField type: %1$s")
    public SearchException unknownNumericFieldType(String var1);

    @Message(id=92, value="Conversion from Reader to String not yet implemented")
    public SearchException conversionFromReaderToStringNotYetImplemented();

    @Message(id=93, value="Unknown Field type: %1$s")
    public SearchException unknownFieldType(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=94, value="Cannot serialize custom Fieldable '%1$s'. Must be NumericField, Field or a Serializable Fieldable implementation.")
    public SearchException cannotSerializeCustomField(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=95, value="Fail to serialize object of type %1$s")
    public SearchException failToSerializeObject(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Cause Throwable var2);

    @Message(id=96, value="Fail to deserialize object")
    public SearchException failToDeserializeObject(@Cause Throwable var1);

    @Message(id=98, value="Unable to parse message from protocol version %1$d.%2$d. Current protocol version: %3$d.%4$d")
    public SearchException incompatibleProtocolVersion(int var1, int var2, int var3, int var4);

    @Message(id=99, value="Unable to deserialize Avro stream")
    public SearchException unableToDeserializeAvroStream(@Cause Throwable var1);

    @Message(id=100, value="Cannot deserialize operation %1$s, unknown operation.")
    public SearchException cannotDeserializeOperation(String var1);

    @Message(id=101, value="Cannot deserialize field type %1$s, unknown field type.")
    public SearchException cannotDeserializeField(String var1);

    @Message(id=102, value="Unable to serialize Lucene works in Avro")
    public SearchException unableToSerializeInAvro(@Cause Throwable var1);

    @Message(id=103, value="Unable to initialize IndexManager named '%1$s'")
    public SearchException unableToInitializeIndexManager(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=104, value="Ignoring backend option for index '%1$s', configured IndexManager requires using '%2$s' instead.")
    public void ignoringBackendOptionForIndex(String var1, String var2);

    @Message(id=105, value="Cannot safely compute getResultSize() when a Criteria with restriction is used. Use query.list().size() or query.getResultList().size(). Criteria at stake: %1$s")
    public SearchException cannotGetResultSizeWithCriteriaAndRestriction(String var1);

    @Message(id=106, value="Field %1$s looks like binary but couldn't be decompressed")
    public SearchException fieldLooksBinaryButDecompressionFailed(String var1);

    @Message(id=107, value="Index names %1$s is not defined")
    public SearchException requestedIndexNotDefined(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=108, value="Shutting down backend for IndexManager '%1$s'")
    public void shuttingDownBackend(String var1);

    @Message(id=109, value="%1$s is not an indexed type")
    public IllegalArgumentException notAnIndexedType(String var1);

    @Message(id=110, value="'null' is not a valid indexed type")
    public IllegalArgumentException nullIsInvalidIndexedType();

    @Message(id=111, value="At least one index name must be provided: can't open an IndexReader on nothing")
    public IllegalArgumentException needAtLeastOneIndexName();

    @Message(id=112, value="At least one entity type must be provided: can't open an IndexReader on nothing")
    public IllegalArgumentException needAtLeastOneIndexedEntityType();

    @Message(id=113, value="'null' is not a valid index name")
    public IllegalArgumentException nullIsInvalidIndexName();

    @Message(id=114, value="Could not load resource: '%1$s'")
    public SearchException unableToLoadResource(String var1);

    @Message(id=115, value="Unknown @FullTextFilter: '%1$s'")
    public SearchException unknownFullTextFilter(String var1);

    @Message(id=116, value="Unexpected error during MassIndexer operation")
    public String massIndexerUnexpectedErrorMessage();

    @Message(id=117, value="IOException on the IndexWriter")
    public String ioExceptionOnIndexWriter();

    @Message(id=118, value="Exception during index Merge operation")
    public String exceptionDuringIndexMergeOperation();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=119, value="Skipping optimization on index %1$s as it is already being optimized")
    public void optimizationSkippedStillBusy(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=120, value="There are multiple properties indexed against the same field name '%1$s.%2$s', but with different indexing settings. The behaviour is undefined.")
    public void inconsistentFieldConfiguration(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=125, value="Interceptor enforces skip index operation %2$s on instance of class %1$s")
    public void forceSkipIndexOperationViaInterception(@FormatWith(value=ClassFormatter.class) Class<?> var1, WorkType var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=126, value="Interceptor enforces removal of index data instead of index operation %2$s on instance of class %1$s")
    public void forceRemoveOnIndexOperationViaInterception(@FormatWith(value=ClassFormatter.class) Class<?> var1, WorkType var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=128, value="Interceptor enforces update of index data instead of index operation %2$s on instance of class %1$s")
    public void forceUpdateOnIndexOperationViaInterception(@FormatWith(value=ClassFormatter.class) Class<?> var1, WorkType var2);

    @Message(id=131, value="The field '%1$s#%2$s' used for the spatial query is not configured as spatial field. Check the proper use of @Spatial respectively SpatialFieldBridge")
    public SearchException targetedFieldNotSpatial(String var1, String var2);

    @Message(id=133, value="@ClassBridge implementation '%1$s' should implement either org.hibernate.search.bridge.FieldBridge, org.hibernate.search.bridge.TwoWayStringBridge or org.hibernate.search.bridge.StringBridge")
    public SearchException noFieldBridgeInterfaceImplementedByClassBridge(String var1);

    @Message(id=134, value="Unable to instantiate ClassBridge of type %1$s defined on %2$s")
    public SearchException cannotInstantiateClassBridgeOfType(String var1, String var2, @Cause Throwable var3);

    @Message(id=135, value="Unable to guess FieldBridge for %2$s in %1$s")
    public SearchException unableToGuessFieldBridge(String var1, String var2);

    @Message(id=136, value="Unable to instantiate Spatial defined on %1$s")
    public SearchException unableToInstantiateSpatial(String var1, @Cause Throwable var2);

    @Message(id=137, value="@FieldBridge with no implementation class defined in: %1$s")
    public SearchException noImplementationClassInFieldBridge(String var1);

    @Message(id=138, value="@FieldBridge implementation implements none of the field bridge interfaces: %1$s in %2$s")
    public SearchException noFieldBridgeInterfaceImplementedByFieldBridge(String var1, String var2);

    @Message(id=139, value="Unable to instantiate FieldBridge for %1$s of class %2$s")
    public SearchException unableToInstantiateFieldBridge(String var1, String var2, @Cause Throwable var3);

    @Message(id=140, value="Unknown Resolution: %1$s")
    public AssertionFailure unknownResolution(String var1);

    @Message(id=144, value="FieldBridge passed in is not an instance of %1$s")
    public SearchException fieldBridgeNotAnInstanceof(String var1);

    @Message(id=146, value="The query string '%2$s' applied on field '%1$s' has no meaningful tokens to be matched. Validate the query input against the Analyzer applied on this field.")
    public EmptyQueryException queryWithNoTermsAfterAnalysis(String var1, String var2);

    @Message(id=149, value="Unable to determine ClassBridge for %1$s")
    public SearchException unableToDetermineClassBridge(String var1);

    @Message(id=150, value="Unable to get input stream from blob data")
    public SearchException unableToGetInputStreamFromBlob(@Cause Throwable var1);

    @Message(id=151, value="Unable to get input stream from object of type %1$s")
    public SearchException unsupportedTikaBridgeType(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=152, value="File %1$s does not exist")
    public SearchException fileDoesNotExist(String var1);

    @Message(id=153, value="%1$s is a directory and not a file")
    public SearchException fileIsADirectory(String var1);

    @Message(id=154, value="File %1$s is not readable")
    public SearchException fileIsNotReadable(String var1);

    @Message(id=155, value="Unable to configure %1$s")
    public SearchException unableToConfigureTikaBridge(String var1, @Cause Throwable var2);

    @Message(id=156, value="Cannot read %1$s field from a %2$s object: does getter exist and is it public ?")
    public SearchException cannotReadFieldForClass(String var1, String var2);

    @Message(id=157, value="Class %1$s does not implement the Coordinates interface")
    public SearchException cannotExtractCoordinateFromObject(String var1);

    @Message(id=158, value="Class %1$s cannot have two @Spatial using default/same name")
    public SearchException cannotHaveTwoSpatialsWithDefaultOrSameName(String var1);

    @Message(id=159, value="Cannot find a Coordinates interface nor @Latitude/@Longitude annotations bound to the @Spatial name '%1$s' for class %2$s. It might be a typo (or a lapse) in @Latitude.of / @Longitude.of attributes.")
    public SearchException cannotFindCoordinatesNorLatLongForSpatial(String var1, String var2);

    @Message(id=160, value="@Latitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'")
    public SearchException ambiguousLatitudeDefinition(String var1, String var2, String var3);

    @Message(id=161, value="@Longitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'")
    public SearchException ambiguousLongitudeDefinition(String var1, String var2, String var3);

    @Message(id=162, value="Unable to open JMS connection on queue '%2$s' for index '%1$s'")
    public SearchException unableToOpenJMSConnection(String var1, String var2, @Cause Throwable var3);

    @Message(id=163, value="Unable to send Search work to JMS queue '%2$s' for index '%1$s'")
    public SearchException unableToSendJMSWork(String var1, String var2, @Cause Throwable var3);

    @Message(id=164, value="Unable to lookup Search queue '%1$s' for index '%2$s'")
    public SearchException jmsQueueLookupException(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=166, value="IndexManager factory resolved alias '%1$s' to '%2$s'.")
    public void indexManagerAliasResolved(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=167, value="More than one @DocumentId specified on entity '%1$s'")
    public SearchException duplicateDocumentIdFound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=168, value="Serialization service %2$s being used for index '%1$s'")
    public void indexManagerUsesSerializationService(String var1, String var2);

    @Message(id=169, value="FieldBridge '%1$s' does not have a objectToString method: field '%2$s' in '%3$s' The FieldBridge must be a TwoWayFieldBridge or you have to enable the ignoreFieldBridge option when defining a Query")
    public SearchException fieldBridgeNotTwoWay(@FormatWith(value=ClassFormatter.class) Class<? extends FieldBridge> var1, String var2, XClass var3);

    @Message(id=176, value="Document could not be parsed")
    public SearchException unableToParseDocument(@Cause Throwable var1);

    @Message(id=177, value="Unable to find a valid document id for entity '%1$s'")
    public SearchException noDocumentIdFoundException(String var1);

    @Message(id=178, value="Unable to create a FullTextSession from a null Session")
    public IllegalArgumentException getNullSessionPassedToFullTextSessionCreationException();

    @Message(id=179, value="Unable to create a FullTextEntityManager from a null EntityManager")
    public IllegalArgumentException getNullEntityManagerPassedToFullEntityManagerCreationException();

    @Message(id=180, value="Unable to cast %s of type %s to %s")
    public ClassCastException getUnableToNarrowFieldDescriptorException(String var1, String var2, String var3);

    @Message(id=181, value="'null' is not a valid property name")
    public IllegalArgumentException getPropertyNameCannotBeNullException();

    @Message(id=182, value="'null' is not a valid field name")
    public IllegalArgumentException getFieldNameCannotBeNullException();

    @Message(id=183, value="Unable to index instance of type %s while batch indexing: %s")
    public String massIndexerUnableToIndexInstance(String var1, String var2);

    @Message(id=184, value="Cannot define an entity with 0 shard on '%1$s'")
    public SearchException entityWithNoShard(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=186, value="[AssertionFailure: open a bug report] SearchFactory from entityIndexBinding is not assignable to WorkerBuilderContext. Actual class is %1$s")
    public SearchException assertionFailureCannotCastToWorkerBuilderContext(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=189, value="Multiple entities are sharing the same index but are declaring an inconsistent Similarity. When overriding default Similarity make sure that all types sharing a same index declare the same Similarity implementation. %s defines similarity %s and %s defines similarity %s")
    public SearchException getMultipleEntitiesShareIndexWithInconsistentSimilarityException(String var1, String var2, String var3, String var4);

    @Message(id=190, value="Unable to start HibernateSessionFactoryServiceProvider. There is no session factory in the context. Are you sure you have Hibernate ORM enabled?")
    public SearchException getNoSessionFactoryInContextException();

    @Message(id=191, value="The number of shards must be >= 1. %s is an illegal value.")
    public SearchException getInvalidShardCountException(int var1);

    @Message(id=192, value="%s")
    public SearchException getInvalidIntegerValueException(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=193, value="Selected sharding strategy is IdHashShardingStrategy. However, there is only 1 shard configured. Have you set the 'nbr_of_shards' property?")
    public void idHashShardingWithSingleShard();

    @Message(id=194, value="Unable to load configured class '%s' as 'sharding_strategy'")
    public SearchException getUnableToLoadShardingStrategyClassException(String var1);

    @Message(id=195, value="Multiple service implementations detected for service '%1$s': '%2$s'")
    public SearchException getMultipleServiceImplementationsException(String var1, String var2);

    @Message(id=196, value="No service implementations for service '%1$s' can be found")
    public SearchException getNoServiceImplementationFoundException(String var1);

    @Message(id=197, value="Unable to create JGroups backend. Are you sure you have the JGroups dependencies on the classpath?")
    public SearchException getUnableToCreateJGroupsBackendException(@Cause Throwable var1);

    @Message(id=198, value="Unexpected status '%s' for service '%s'. Check for circular dependencies or unreleased resources in your services.")
    public SearchException getUnexpectedServiceStatusException(String var1, String var2);

    @Message(id=199, value="Configuration property '%s' should not be empty: illegal format.")
    public SearchException configurationPropertyCantBeEmpty(String var1);

    @Message(id=201, value="The edit distance must be either 1 or 2")
    public SearchException incorrectEditDistance();

    @Message(id=202, value="Unable to find entity $1%s with id $2%s")
    public SearchException entityWithIdNotFound(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=203, value="No field from %s can be used for More Like This queries. They are neither stored or including the term vectors.")
    public SearchException noFieldCompatibleForMoreLikeThis(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=205, value="An IOException happened while accessing the Lucene indexes related to '%1$s'")
    public SearchException ioExceptionOnIndexOfEntity(@Cause IOException var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=206, value="MoreLikeThis queries require a TFIDFSimilarity for entity '$1%s'")
    public SearchException requireTFIDFSimilarity(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=207, value="Field %s of entity %s cannot be used in a MoreLikeThis query: the term vector (preferred) or the value itself need to be stored.")
    public SearchException fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=208, value="ClassLoaderService cannot be provided via SearchConfiguration#getProvidedServices. Use SearchConfiguration#getClassLoaderService!")
    public SearchException classLoaderServiceContainedInProvidedServicesException();

    @Message(id=209, value="It is not allowed to request further services after ServiceManager#releaseAll has been called.")
    public IllegalStateException serviceRequestedAfterReleasedAllWasCalled();

    @Message(id=210, value="Provided service '%s' implements '%s'. Provided services are not allowed to implement either Startable or Stoppable.")
    public SearchException providedServicesCannotImplementStartableOrStoppable(String var1, String var2);

    @Message(id=211, value="An exception occurred while the MassIndexer was fetching the primary identifiers list")
    public String massIndexerExceptionWhileFetchingIds();

    @Message(id=212, value="An exception occurred while the MassIndexer was transforming identifiers to Lucene Documents")
    public String massIndexerExceptionWhileTransformingIds();

    @Message(id=213, value="Field %s of entity %s cannot be used in a MoreLikeThis query. Ids and embedded ids are excluded.")
    public SearchException fieldIdCannotBeUsedInMoreLikeThis(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=214, value="Field %s of entity %s cannot be used in a MoreLikeThis query. Numeric fields are not considered for the moment.")
    public SearchException numericFieldCannotBeUsedInMoreLikeThis(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=215, value="Multiple matching FieldBridges found for %s of return type %s: %s")
    public SearchException multipleMatchingFieldBridges(XMember var1, XClass var2, String var3);

    @Message(id=216, value="Found invalid @IndexedEmbedded->paths elements configured for member '%s' of class '%s'. The invalid paths are [%s]")
    public SearchException invalidIncludePathConfiguration(String var1, String var2, String var3);

    @Message(id=217, value="Invalid value '%s' for setting '%s'. Check the documentation for allowed values.")
    public SearchException invalidPropertyValue(String var1, String var2);

    @Message(id=218, value="More like this query cannot be created, because the index does not contain a field '%s' for the type '%s")
    public SearchException unknownFieldNameForMoreLikeThisQuery(String var1, String var2);

    @Message(id=219, value="Could not lookup initial JNDI context for the JMS ConnectionFactory named '%s' for the index '%s")
    public SearchException jmsInitialContextException(String var1, String var2, @Cause Exception var3);

    @Message(id=220, value="Could not lookup JMS ConnectionFactory named '%1s' for the index '%2s")
    public SearchException jmsQueueFactoryLookupException(String var1, String var2, @Cause Exception var3);

    @Message(id=221, value="Circular reference. Duplicate use of %1s in root entity %2s#%3s Set the @IndexedEmbedded.depth value explicitly to fix the problem.")
    public SearchException detectInfiniteTypeLoopInIndexedEmbedded(String var1, String var2, String var3);

    @Message(id=222, value="The SearchFactory was not initialized")
    public SearchException searchIntegratorNotInitialized();

    @Message(id=223, value="The Service org.hibernate.search.hcore.impl.SearchFactoryReference was not found in the Hibernate ORM Service Registry. This might be caused by the Hibernate ORM classloader not having visibility on Hibernate Search")
    public SearchException searchFactoryReferenceServiceNotFound();

    @Message(id=224, value="Non optional parameter named '%s' was null")
    public AssertionFailure parametersShouldNotBeNull(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=225, value="An index locking error occurred during initialization of Directory '%s'. This might indicate a concurrent initialization; If you experience errors on this index you might need to remove the lock, or rebuild the index.")
    public void lockingFailureDuringInitialization(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=226, value="%s: %s")
    public void logInfoStreamMessage(String var1, String var2);

    @Message(id=227, value="A BooleanQuery is not valid without at least one clause. Use at least one of should(Query) or must(Query).")
    public SearchException booleanQueryWithoutClauses();

    @Message(id=228, value="Property hibernate.search.lucene_version set to value '%s' is not in a valid format to express a Lucene version: %s")
    public SearchException illegalLuceneVersionFormat(String var1, String var2);

    @Message(id=229, value="Property index_flush_intervalfor the index '%s' needs to be positive.")
    public SearchException flushIntervalNeedsToBePositive(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=230, value="Starting sync consumer thread for index '%s'")
    public void startingSyncConsumerThread(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=231, value="Stopping sync consumer thread for index '%s'")
    public void stoppingSyncConsumerThread(String var1);

    @Message(id=232, value="The specified query '%s' contains a numeric sub query which targets the string encoded field(s) '%s'. Check your query or try limiting the targeted entities.")
    public SearchException stringEncodedFieldsAreTargetedWithNumericQuery(String var1, String var2);

    @Message(id=233, value="The specified query '%s' contains a string based sub query which targets the numeric encoded field(s) '%s'. Check your query or try limiting the targeted entities.")
    public SearchException numericEncodedFieldsAreTargetedWithStringQuery(String var1, String var2);

    @Message(id=234, value="None of the specified entity types ('%s') or any of their subclasses are indexed.")
    public IllegalArgumentException targetedEntityTypesNotIndexed(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=235, value="Backend for index '%s' started: using a Synchronous batching backend.")
    public void luceneBackendInitializedSynchronously(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=236, value="Backend for index '%s' started: using an Asynchronous backend with periodic commits.")
    public void luceneBackendInitializedAsynchronously(String var1);

    @Message(id=237, value="Cannot create numeric range query for field '%s', since from and to values are null")
    public SearchException rangeQueryWithNullToAndFromValue(String var1);

    @Message(id=238, value="Cannot create numeric range query for field '%s', since values are not numeric (Date, int, long, short or double)")
    public SearchException numericRangeQueryWithNonNumericToAndFromValues(String var1);

    @Message(id=239, value="Unknown field encoding type: %1$s")
    public AssertionFailure unknownEncodingType(String var1);

    @Message(id=240, value="Unable to parse value '%2$s' of field '%1$s' into a Date")
    public SearchException invalidStringDateFieldInDocument(String var1, String var2);

    @Message(id=241, value="Multiple @Factory methods defined in %s")
    public SearchException multipleFactoryMethodsInClass(String var1);

    @Message(id=242, value="Search requires '%s' to have a public no-arg constructor in order to instantiate it")
    public SearchException noPublicNoArgConstructor(String var1);

    @Message(id=243, value="Unable to access class '%s'")
    public SearchException unableToAccessClass(String var1);

    @Message(id=244, value="Factory methods must return an object. '%1$s#%2$s' does not")
    public SearchException factoryMethodsMustReturnAnObject(String var1, String var2);

    @Message(id=245, value="Unable to access method '%1$s#%2$s'")
    public SearchException unableToAccessMethod(String var1, String var2);

    @Message(id=246, value="An exception occurred while invoking '%1$s#%2$s'")
    public SearchException exceptionDuringFactoryMethodExecution(@Cause Exception var1, String var2, String var3);

    @Message(id=247, value="An indexed field defined on '%1$s:%2$s' tries to override the id field settings. The document id field settings cannot be modified. Use a different field name.")
    public SearchException fieldTriesToOverrideIdFieldSettings(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=248, value="WorkList should never be empty. Stacktrace below \n %s")
    public void workListShouldNeverBeEmpty(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=249, value="Cannot do fast deletes on index '%s'. Entities in this index are conflicting or the index can accept unknown entities.")
    public void singleTermDeleteDisabled(String var1);

    @Message(id=250, value="Unsupported value type for configuration property hibernate.search.error_handler: %1$s")
    public SearchException unsupportedErrorHandlerConfigurationValueType(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=251, value="Unable to set filter parameter '%2$s' on filter class %1$s")
    public SearchException unableToSetFilterParameter(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=252, value="Unable to initialize directory provider %1$s for index %2$s")
    public SearchException cannotInitializeDirectoryProvider(@FormatWith(value=ClassFormatter.class) Class<? extends DirectoryProvider> var1, String var2, @Cause Exception var3);

    @Message(id=253, value="To use '%1$s' as a locking strategy, an indexBase path must be set")
    public SearchException indexBasePathRequiredForLockingStrategy(String var1);

    @Message(id=254, value="Unknown indexing mode: %1$s")
    public SearchException unknownIndexingMode(String var1);

    @Message(id=255, value="Unknown DocValues type: %1$s")
    public SearchException unknownDocValuesTypeType(String var1);

    @Message(id=256, value="'%1$s' is an unexpected type for a binary doc value")
    public SearchException unexpectedBinaryDocValuesTypeType(String var1);

    @Message(id=257, value="'%1$s' is an unexpected type for a numeric doc value")
    public SearchException unexpectedNumericDocValuesTypeType(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=258, value="Attempting to load a field named '%s' from the Lucene Document. This Document instance doesn't have such a field.")
    public void loadingNonExistentField(String var1);

    @Message(id=259, value="Unable to delete all %s matching Query: %s")
    public SearchException unableToDeleteByQuery(@FormatWith(value=ClassFormatter.class) Class<?> var1, DeletionQuery var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=260, value="A criteria for loading query results has been specified via FullTextQuery#setCriteriaQuery(), but query results originate from several id spaces. The given criteria object can therefore not be be applied.")
    public void givenCriteriaObjectCannotBeApplied();

    @Message(id=261, value="An unknown DeletionQuery key was specified during de-serialization of a message from another node: %d")
    public SearchException unknownDeletionQueryKeySpecified(int var1);

    @Message(id=262, value="@NumericField annotation is used on %1$s#%2$s without a matching @Field annotation")
    public SearchException numericFieldAnnotationWithoutMatchingField(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=263, value="@Facet annotation is used on %1$s#%2$s without a matching @Field annotation")
    public SearchException facetAnnotationWithoutMatchingField(String var1, String var2);

    @Message(id=264, value="@Facet is not supported for type '%1$s'. See %2$s#%3$s")
    public SearchException unsupportedFieldTypeForFaceting(String var1, String var2, String var3);

    @Message(id=265, value="Unable to build Lucene Document due to facet indexing error")
    public SearchException errorDuringFacetingIndexing(@Cause Exception var1);

    @Message(id=266, value="'%s' is not a valid type for a facet range request. Numbers (byte, short, int, long, float, double and their wrappers) as well as dates are supported")
    public SearchException unsupportedFacetRangeParameter(String var1);

    @Message(id=267, value="Unable to index date facet '%1$s' for field '%2$s', since the matching field is not using a numeric field bridge")
    public SearchException numericDateFacetForNonNumericField(String var1, String var2);

    @Message(id=268, value="Facet request '%1$s' tries to facet on  field '%2$s' which either does not exist or is not configured for faceting (via @Facet). Check your configuration.")
    public SearchException unknownFieldNameForFaceting(String var1, String var2);

    @Message(id=269, value="'%1$s' is not a supported type for a range faceting request parameter. Supported types are: '%2$s'")
    public SearchException unsupportedParameterTypeForRangeFaceting(String var1, String var2);

    @Message(id=270, value="At least of of the facets ranges in facet request '%1$s' contains neither start nor end value")
    public SearchException noStartOrEndSpecifiedForRangeQuery(String var1);

    @Message(id=271, value="RANGE_DEFINITION_ORDER is not a valid sort order for a discrete faceting request.")
    public SearchException rangeDefinitionOrderRequestedForDiscreteFacetRequest();

    @Message(id=272, value="Entity '%1$s' is not an indexed entity. Unable to create faceting request")
    public SearchException attemptToCreateFacetingRequestForUnindexedEntity(String var1);

    @Message(id=273, value="The indexed field '%1$s' in '%2$s' is analyzed and marked for faceting. Only un-analyzed fields can be faceted.")
    public SearchException attemptToFacetOnAnalyzedField(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=274, value="Executing Lucene query '%s'")
    public void executingLuceneQuery(Query var1);

    @Message(id=275, value="SerializationProvider service not found on the classpath. You should check that an implementation exists and it's correctly registered as a service. If that's not the case, you can also create a custom implementation or add \"org.hibernate:hibernate-search-serialization-avro\" on the classpath")
    public SearchException serializationProviderNotFoundException(@Cause Exception var1);

    @Message(id=276, value="No transaction is active while indexing entity type '%1$s'; Consider increasing the connection time-out")
    public SearchException transactionNotActiveWhileProducingIdsForBatchIndexing(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=277, value="Worker configured to be enlisted in transaction but the backend %1$s is not transactional for index %2$s")
    public SearchException backendNonTransactional(String var1, String var2);

    @Message(id=278, value="Can't build query for type '%1$s' which is neither indexed nor has any indexed sub-types.")
    public SearchException cantQueryUnindexedType(String var1);

    @Message(id=279, value="Unable to load the UTF-8 Charset!")
    public AssertionFailure assertionNotLoadingUTF8Charset(@Cause UnsupportedEncodingException var1);

    @Message(id=280, value="Source directory does not exist: '%1$s")
    public SearchException sourceDirectoryNotExisting(String var1);

    @Message(id=281, value="Unable to read directory: '%1$s")
    public SearchException directoryIsNotReadable(String var1);

    @Message(id=282, value="Distance sort can only be used with spatial fields: '%1$s' is not spatial")
    public SearchException distanceSortRequiresSpatialField(String var1);

    @Message(id=283, value="Sorting using '%1$s' requires an indexed field: '%2$s' is not valid")
    public SearchException sortRequiresIndexedField(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=284, value="An IOException happened while opening multiple indexes")
    public SearchException ioExceptionOnMultiReaderRefresh(@Cause IOException var1);

    @Message(id=285, value="Could not create uninverting reader for reader %s")
    public SearchException couldNotCreateUninvertingReader(DirectoryReader var1, @Cause IOException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=286, value="Could not create uninverting reader for reader of type %s; Only directory readers are supported")
    public void readerTypeUnsupportedForInverting(@FormatWith(value=ClassFormatter.class) Class<? extends IndexReader> var1);

    @Message(id=287, value="Unsupported sort type for field %1$s: %2$s")
    public SearchException sortFieldTypeUnsupported(String var1, SortField.Type var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=288, value="The configuration property '%s' no longer applies and will be ignored.")
    public void deprecatedConfigurationPropertyIsIgnored(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=289, value="Requested sort field(s) %3$s are not configured for entity type %1$s mapped to index %2$s, thus an uninverting reader must be created. You should declare the missing sort fields using @SortableField.")
    public void uncoveredSortsRequested(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3);

    @Message(id=290, value="The 'indexNullAs' property for field '%2$s' needs to represent a Double Number to match the field type of the index. Please change value from '%1$s' to represent a Double.")
    public SearchException nullMarkerNeedsToRepresentADoubleNumber(String var1, String var2);

    @Message(id=291, value="The 'indexNullAs' property for field '%2$s' needs to represent a Float Number to match the field type of the index. Please change value from '%1$s' to represent a Float.")
    public SearchException nullMarkerNeedsToRepresentAFloatNumber(String var1, String var2);

    @Message(id=292, value="The 'indexNullAs' property for field '%2$s' needs to represent an Integer Number to match the field type of the index. Please change value from '%1$s' to represent an Integer.")
    public SearchException nullMarkerNeedsToRepresentAnIntegerNumber(String var1, String var2);

    @Message(id=293, value="The 'indexNullAs' property for field '%2$s' needs to represent a Long Number to match the field type of the index. Please change value from '%1$s' to represent a Long.")
    public SearchException nullMarkerNeedsToRepresentALongNumber(String var1, String var2);

    @Message(id=294, value="Unable to search for null token on field '%1$s' if field bridge is ignored.")
    public SearchException unableToSearchOnNullValueWithoutFieldBridge(String var1);

    @Message(id=295, value="String '$1%s' cannot be parsed into a '$2%s'")
    public SearchException parseException(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=296, value="Package java.time not found on the classpath; the built-in bridge won't be available")
    public void javaTimeBridgeWontBeAdded(@Cause Exception var1);

    @Message(id=297, value=" Value of '%2$s' for type '%1$s' is too big for the conversion")
    public SearchException valueTooLargeForConversionException(@FormatWith(value=ClassFormatter.class) Class<?> var1, Object var2, @Cause Exception var3);

    @Message(id=298, value="Inconsisent configuration of sort fields %2$s for index '%1$s'. Make sure they are configured using @SortableField for all entities mapped to this index.")
    public SearchException inconsistentSortableFieldConfigurationForSharedIndex(String var1, String var2);

    @Message(id=299, value="@SortableField declared on %s#%s references to undeclared field '%s'")
    public SearchException sortableFieldRefersToUndefinedField(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3);

    @Message(id=300, value="Several @NumericField annotations used on %1$s#%2$s refer to the same field")
    public SearchException severalNumericFieldAnnotationsForSameField(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=301, value="Requested sort field(s) %3$s are not configured for entity type %1$s mapped to index %2$s, thus an uninverting reader must be created. You should declare the missing sort fields using @SortableField.")
    public SearchException uncoveredSortsRequestedWithUninvertingNotAllowed(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3);

    @Message(id=302, value="Cannot execute query '%2$s', as targeted entity type '%1$s' is indexed through a non directory-based backend")
    public SearchException cannotRunLuceneQueryTargetingEntityIndexedWithNonDirectoryBasedIndexManager(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=303, value="Timeout while waiting for indexing resources to properly flush and close on shut down ofindexing backend for index '%s'. Some pending index writes might have been lost.")
    public void timedOutWaitingShutdown(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=304, value="Closing index writer for IndexManager '%1$s'")
    public void closingIndexWriter(String var1);

    @Message(id=305, value="Analyzer reference with name '%2$s' not initialized for field '%1$s'")
    public SearchException analyzerReferenceNotInitialized(String var1, String var2);

    @Message(id=306, value="Index manager type is required to build a field bridge for %2$s in %1$s")
    public SearchException indexManagerTypeRequiredToBuildFieldBridge(String var1, String var2);

    @Message(id=307, value="Sort type %1$s is not compatible with %2$s type of field '%3$s'.")
    public SearchException sortTypeDoesNotMatchFieldType(String var1, String var2, String var3);

    @Message(id=308, value="Analyzer reference %1$s is not a remote analyzer reference.")
    public SearchException analyzerReferenceIsNotRemote(AnalyzerReference var1);

    @Message(id=309, value="Analyzer reference %1$s is not a Lucene analyzer reference.")
    public SearchException analyzerReferenceIsNotLucene(AnalyzerReference var1);

    @Message(id=310, value="Analyzer %1$s is not a scoped remote analyzer.")
    public SearchException scopedAnalyzerIsNotRemote(ScopedAnalyzer var1);

    @Message(id=311, value="Analyzer %1$s is not a scoped Lucene analyzer.")
    public SearchException scopedAnalyzerIsNotLucene(ScopedAnalyzer var1);

    @Message(id=312, value="Lazy Lucene analyzer %1$s is not initialized.")
    public SearchException lazyLuceneAnalyzerNotInitialized(LazyLuceneAnalyzer var1);

    @Message(id=313, value="Remote analyzer reference %1$s is not initialized.")
    public SearchException remoteAnalyzerNotInitialized(RemoteAnalyzerReference var1);

    @Message(id=314, value="Remote analyzer %1$s already defined as a Lucene analyzer.")
    public SearchException remoteAnalyzerAlreadyDefinedAsLuceneAnalyzer(String var1);

    @Message(id=315, value="Lazy remote analyzer %1$s is not initialized.")
    public SearchException lazyRemoteAnalyzerNotInitialized(LazyRemoteAnalyzer var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=316, value="The value for @IndexEmbedded#%2$s() on the property `%1$s` is ignored when the annotation is used with @ElementCollection")
    public void indexEmbeddedValueIgnored(String var1, String var2);

    @Message(id=317, value="Projection constant '%s' is not supported for this query.")
    public SearchException unexpectedProjectionConstant(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=318, value="The backend name 'lucene' is deprecated. Use 'local' instead")
    public void deprecatedBackendName();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=319, value="Using serialization service %1$s")
    public void usingSerializationService(String var1);

    @Message(id=320, value="Could not analyze sortable field '%1$s'.")
    public SearchException couldNotAnalyzeSortableField(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=321, value="The analysis of field '%1$s' produced multiple tokens. Tokenization or term generation (synonyms) should not be used on sortable fields. Only the first token will be indexed.")
    public void multipleTermsInAnalyzedSortableField(String var1);
}

