/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import io.searchbox.action.BulkableAction;
import io.searchbox.indices.Refresh;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.search.backend.impl.lucene.MultiWriteDrainableLinkedList;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.client.impl.BulkRequest;
import org.hibernate.search.elasticsearch.client.impl.BulkRequestFailedException;
import org.hibernate.search.elasticsearch.client.impl.ExecutableRequest;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.elasticsearch.client.impl.SingleRequest;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BackendRequestProcessor
implements Service,
Startable,
Stoppable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final int MAX_BULK_SIZE = 250;
    private final AsyncBackendRequestProcessor asyncProcessor = new AsyncBackendRequestProcessor();
    private ErrorHandler errorHandler;
    private ServiceManager serviceManager;
    private JestClient jestClient;

    public void start(Properties properties, BuildContext context) {
        this.errorHandler = context.getErrorHandler();
        this.serviceManager = context.getServiceManager();
        this.jestClient = (JestClient)this.serviceManager.requestService(JestClient.class);
    }

    public void stop() {
        this.awaitAsyncProcessingCompletion();
        this.asyncProcessor.shutdown();
        this.serviceManager.releaseService(JestClient.class);
    }

    public void executeSync(Iterable<BackendRequest<?>> requests) {
        this.doExecute(requests);
    }

    public void executeAsync(BackendRequest<?> request) {
        this.asyncProcessor.submitRequest(request);
    }

    public void awaitAsyncProcessingCompletion() {
        this.asyncProcessor.awaitCompletion();
    }

    private void doExecute(Iterable<BackendRequest<?>> requests) {
        ExecutableRequest nextBulk = null;
        HashSet<String> indexesNeedingRefresh = new HashSet<String>();
        Iterator<ExecutableRequest> iterator = this.createRequestGroups(requests, true).iterator();
        while (iterator.hasNext()) {
            ExecutableRequest backendRequestGroup;
            nextBulk = backendRequestGroup = iterator.next();
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Processing bulk of %s items on index(es) %s", nextBulk.getSize(), nextBulk.getTouchedIndexes());
            }
            nextBulk.execute();
            indexesNeedingRefresh.addAll(backendRequestGroup.getIndexesNeedingRefresh());
        }
        this.refresh(indexesNeedingRefresh);
    }

    private List<ExecutableRequest> createRequestGroups(Iterable<BackendRequest<?>> requests, boolean refreshAtEnd) {
        ArrayList<ExecutableRequest> groups = new ArrayList<ExecutableRequest>();
        BulkRequestBuilder bulkBuilder = new BulkRequestBuilder();
        for (BackendRequest<?> request : requests) {
            boolean currentBulkNeedsFinishing;
            boolean currentRequestBulkable = request.getAction() instanceof BulkableAction;
            boolean bl = currentBulkNeedsFinishing = (!bulkBuilder.canAddMore() || !currentRequestBulkable) && !bulkBuilder.isEmpty();
            if (currentBulkNeedsFinishing) {
                groups.add(bulkBuilder.build(false));
                bulkBuilder = new BulkRequestBuilder();
            }
            if (currentRequestBulkable) {
                bulkBuilder.add(request);
                continue;
            }
            groups.add(new SingleRequest(this.jestClient, this.errorHandler, request));
        }
        if (!bulkBuilder.isEmpty()) {
            groups.add(bulkBuilder.build(refreshAtEnd));
        }
        return groups;
    }

    private void refresh(Set<String> indexesNeedingRefresh) {
        if (indexesNeedingRefresh.isEmpty()) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Refreshing index(es) %s", indexesNeedingRefresh);
        }
        Refresh.Builder refreshBuilder = new Refresh.Builder();
        for (String index : indexesNeedingRefresh) {
            refreshBuilder.addIndex(index);
        }
        try {
            this.jestClient.executeRequest(refreshBuilder.build());
        }
        catch (BulkRequestFailedException brfe) {
            this.errorHandler.handleException("Refresh failed", (Throwable)((Object)brfe));
        }
    }

    private class BulkRequestBuilder {
        private final List<BackendRequest<?>> bulk = new ArrayList();
        private final Set<String> indexNames = new HashSet<String>();
        private final Set<String> indexesNeedingRefresh = new HashSet<String>();
        private int size = 0;

        private BulkRequestBuilder() {
        }

        private void add(BackendRequest<?> request) {
            this.bulk.add(request);
            this.indexNames.add(request.getIndexName());
            if (request.needsRefreshAfterWrite()) {
                this.indexesNeedingRefresh.add(request.getIndexName());
            }
            ++this.size;
        }

        private boolean canAddMore() {
            return this.size < 250;
        }

        private boolean isEmpty() {
            return this.size == 0;
        }

        private ExecutableRequest build(boolean refresh) {
            if (this.size > 1) {
                return new BulkRequest(BackendRequestProcessor.this.jestClient, BackendRequestProcessor.this.errorHandler, this.bulk, this.indexNames, this.indexesNeedingRefresh, refresh);
            }
            return new SingleRequest(BackendRequestProcessor.this.jestClient, BackendRequestProcessor.this.errorHandler, this.bulk.iterator().next());
        }
    }

    private class RequestProcessingRunnable
    implements Runnable {
        private final AsyncBackendRequestProcessor asyncProcessor;
        private final CountDownLatch latch = new CountDownLatch(1);

        public RequestProcessingRunnable(AsyncBackendRequestProcessor asyncProcessor) {
            this.asyncProcessor = asyncProcessor;
        }

        @Override
        public void run() {
            try {
                this.processAsyncWork();
            }
            finally {
                this.latch.countDown();
            }
        }

        private void processAsyncWork() {
            HashSet<String> indexesNeedingFlush = new HashSet<String>();
            AsyncBackendRequestProcessor asyncBackendRequestProcessor = this.asyncProcessor;
            synchronized (asyncBackendRequestProcessor) {
                block3: while (true) {
                    Iterable requests;
                    if ((requests = this.asyncProcessor.asyncRequestQueue.drainToDetachedIterable()) == null) {
                        this.asyncProcessor.asyncWorkerWasStarted.set(false);
                        BackendRequestProcessor.this.refresh(indexesNeedingFlush);
                        return;
                    }
                    Iterator iterator = BackendRequestProcessor.this.createRequestGroups(requests, false).iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        ExecutableRequest backendRequestGroup = (ExecutableRequest)iterator.next();
                        backendRequestGroup.execute();
                        indexesNeedingFlush.addAll(backendRequestGroup.getIndexesNeedingRefresh());
                    }
                    break;
                }
            }
        }
    }

    private class AsyncBackendRequestProcessor {
        private final ScheduledExecutorService scheduler;
        private final MultiWriteDrainableLinkedList<BackendRequest<?>> asyncRequestQueue = new MultiWriteDrainableLinkedList();
        private final AtomicBoolean asyncWorkerWasStarted;
        private volatile CountDownLatch lastAsyncWorkLatch;

        private AsyncBackendRequestProcessor() {
            this.scheduler = Executors.newScheduledThreadPool((String)"Elasticsearch AsyncBackendRequestProcessor");
            this.asyncWorkerWasStarted = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submitRequest(BackendRequest<?> request) {
            this.asyncRequestQueue.add(request);
            if (!this.asyncWorkerWasStarted.get()) {
                AsyncBackendRequestProcessor asyncBackendRequestProcessor = this;
                synchronized (asyncBackendRequestProcessor) {
                    if (this.asyncWorkerWasStarted.compareAndSet(false, true)) {
                        try {
                            RequestProcessingRunnable runnable = new RequestProcessingRunnable(this);
                            this.scheduler.schedule(runnable, 100L, TimeUnit.MILLISECONDS);
                            this.lastAsyncWorkLatch = runnable.latch;
                        }
                        catch (Exception e) {
                            this.asyncWorkerWasStarted.set(false);
                            CountDownLatch latch = this.lastAsyncWorkLatch;
                            if (latch != null) {
                                latch.countDown();
                            }
                            throw e;
                        }
                    }
                }
            }
        }

        public void awaitCompletion() {
            CountDownLatch localLatch = this.lastAsyncWorkLatch;
            if (localLatch != null) {
                try {
                    localLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw LOG.interruptedWhileWaitingForRequestCompletion(e);
                }
            }
        }

        public void shutdown() {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.interruptedWhileWaitingForIndexActivity(e);
            }
            finally {
                CountDownLatch localLatch = this.lastAsyncWorkLatch;
                if (localLatch != null) {
                    localLatch.countDown();
                }
            }
        }
    }
}

