/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URI;
import java.sql.Blob;
import org.hibernate.search.annotations.TikaBridge;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class TikaBridgeProvider
extends ExtendedBridgeProvider {
    private static final Log LOG = LoggerFactory.make();
    private final String TIKA_BRIDGE_NAME = "org.hibernate.search.bridge.builtin.TikaBridge";
    private final String TIKA_BRIDGE_METADATA_PROCESSOR_SETTER = "setMetadataProcessorClass";
    private final String TIKA_BRIDGE_PARSE_CONTEXT_SETTER = "setParseContextProviderClass";

    TikaBridgeProvider() {
    }

    @Override
    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext context) {
        AnnotatedElement annotatedElement = context.getAnnotatedElement();
        if (annotatedElement.isAnnotationPresent(TikaBridge.class)) {
            this.validateMemberType(context);
            TikaBridge tikaAnnotation = annotatedElement.getAnnotation(TikaBridge.class);
            return this.createTikaBridge(tikaAnnotation, context.getServiceManager());
        }
        return null;
    }

    private void validateMemberType(ExtendedBridgeProvider.ExtendedBridgeProviderContext context) {
        Class<?> returnType;
        Class<?> elementType = context.getReturnType();
        if (!(Blob.class.isAssignableFrom(elementType) || String.class.isAssignableFrom(elementType) || byte[].class.isAssignableFrom(elementType) || URI.class.isAssignableFrom(elementType) || byte[].class.isAssignableFrom(returnType = context.getElementOrContainerReturnType()))) {
            throw LOG.unsupportedTikaBridgeType(returnType);
        }
    }

    private FieldBridge createTikaBridge(TikaBridge annotation, ServiceManager serviceManager) {
        Class<?> tikaParseContextProviderClass;
        FieldBridge tikaBridge;
        Class tikaBridgeClass;
        try {
            tikaBridgeClass = ClassLoaderHelper.classForName("org.hibernate.search.bridge.builtin.TikaBridge", serviceManager);
            tikaBridge = ClassLoaderHelper.instanceFromClass(FieldBridge.class, tikaBridgeClass, "Tika bridge");
        }
        catch (ClassLoadingException e) {
            throw new AssertionFailure("Unable to find Tika bridge class: org.hibernate.search.bridge.builtin.TikaBridge");
        }
        Class<?> tikaMetadataProcessorClass = annotation.metadataProcessor();
        if (tikaMetadataProcessorClass != Void.TYPE) {
            this.configureTikaBridgeParameters(tikaBridgeClass, "setMetadataProcessorClass", tikaBridge, tikaMetadataProcessorClass);
        }
        if ((tikaParseContextProviderClass = annotation.parseContextProvider()) != Void.TYPE) {
            this.configureTikaBridgeParameters(tikaBridgeClass, "setParseContextProviderClass", tikaBridge, tikaParseContextProviderClass);
        }
        return tikaBridge;
    }

    private void configureTikaBridgeParameters(Class<?> tikaBridgeClass, String setter, Object tikaBridge, Class<?> clazz) {
        try {
            Method m = tikaBridgeClass.getMethod(setter, Class.class);
            m.invoke(tikaBridge, clazz);
        }
        catch (Exception e) {
            throw LOG.unableToConfigureTikaBridge("org.hibernate.search.bridge.builtin.TikaBridge", e);
        }
    }
}

