/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.hibernate.search.elasticsearch.settings.impl.AnalysisDefinitionFactory;
import org.hibernate.search.elasticsearch.settings.impl.JsonPassThroughAnalysisDefinitionFactory;
import org.hibernate.search.elasticsearch.settings.impl.MapParameterValueTransformer;
import org.hibernate.search.elasticsearch.settings.impl.ParameterValueTransformer;
import org.hibernate.search.elasticsearch.settings.impl.ParametersTransformer;
import org.hibernate.search.elasticsearch.settings.impl.SimpleAnalysisDefinitionFactory;
import org.hibernate.search.elasticsearch.settings.impl.SimpleParametersTransformer;
import org.hibernate.search.elasticsearch.settings.impl.StaticParametersTransformer;
import org.hibernate.search.elasticsearch.settings.impl.ThrowingUnsupportedParameterValueTransformer;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalysisDefinition;

class LuceneAnalysisDefinitionTranslationMapBuilder<D extends AnalysisDefinition> {
    private final Class<D> targetClass;
    private final Map<String, AnalysisDefinitionFactory<D>> result = new HashMap<String, AnalysisDefinitionFactory<D>>();

    public LuceneAnalysisDefinitionTranslationMapBuilder(Class<D> targetClass) {
        this.targetClass = targetClass;
    }

    public SimpleAnalysisDefinitionFactoryBuilder<D> builder(Class<? extends AbstractAnalysisFactory> luceneClass, String typeName) {
        return new SimpleAnalysisDefinitionFactoryBuilder(this, luceneClass, typeName);
    }

    public LuceneAnalysisDefinitionTranslationMapBuilder<D> add(Class<? extends AbstractAnalysisFactory> luceneClass, AnalysisDefinitionFactory<D> definitionFactory) {
        this.result.put(luceneClass.getName(), definitionFactory);
        return this;
    }

    public LuceneAnalysisDefinitionTranslationMapBuilder<D> addJsonPassThrough(Class<? extends AbstractAnalysisFactory> factoryClass) {
        this.result.put(factoryClass.getName(), new JsonPassThroughAnalysisDefinitionFactory<D>(this.targetClass, factoryClass));
        return this;
    }

    public Map<String, AnalysisDefinitionFactory<D>> build() {
        return Collections.unmodifiableMap(this.result);
    }

    static class MapParameterValueTransformerBuilder<D extends AnalysisDefinition> {
        private final SimpleAnalysisDefinitionFactoryBuilder<D> parent;
        private final Class<?> factoryClass;
        private final String parameterName;
        private final Map<String, JsonElement> translations = new HashMap<String, JsonElement>();

        private MapParameterValueTransformerBuilder(SimpleAnalysisDefinitionFactoryBuilder<D> parent, Class<?> factoryClass, String parameterName) {
            this.parent = parent;
            this.factoryClass = factoryClass;
            this.parameterName = parameterName;
        }

        public MapParameterValueTransformerBuilder<D> add(String luceneValue, String elasticsearchValue) {
            return this.add(luceneValue, (JsonElement)new JsonPrimitive(elasticsearchValue));
        }

        public MapParameterValueTransformerBuilder<D> add(String luceneValue, JsonElement elasticsearchValue) {
            this.translations.put(luceneValue, elasticsearchValue);
            return this;
        }

        public SimpleAnalysisDefinitionFactoryBuilder<D> end() {
            return this.parent.transform(this.parameterName, new MapParameterValueTransformer(this.factoryClass, this.parameterName, this.translations));
        }
    }

    static class SimpleAnalysisDefinitionFactoryBuilder<D extends AnalysisDefinition> {
        private final LuceneAnalysisDefinitionTranslationMapBuilder<D> parent;
        private final Class<? extends AbstractAnalysisFactory> luceneClass;
        private final String typeName;
        private List<ParametersTransformer> parametersTransformers = new ArrayList<ParametersTransformer>();
        private Map<String, String> parameterNameTranslations;
        private Map<String, ParameterValueTransformer> parameterValueTranslations;
        private Map<String, JsonElement> staticParameters;

        private SimpleAnalysisDefinitionFactoryBuilder(LuceneAnalysisDefinitionTranslationMapBuilder<D> parent, Class<? extends AbstractAnalysisFactory> luceneClass, String typeName) {
            this.parent = parent;
            this.luceneClass = luceneClass;
            this.typeName = typeName;
        }

        public SimpleAnalysisDefinitionFactoryBuilder<D> transform(ParametersTransformer transformer) {
            this.parametersTransformers.add(transformer);
            return this;
        }

        public SimpleAnalysisDefinitionFactoryBuilder<D> add(String elasticsearchParam, String value) {
            if (this.staticParameters == null) {
                this.staticParameters = new LinkedHashMap<String, JsonElement>();
            }
            this.staticParameters.put(elasticsearchParam, (JsonElement)new JsonPrimitive(value));
            return this;
        }

        public SimpleAnalysisDefinitionFactoryBuilder<D> disallow(String luceneParam) {
            return this.transform(luceneParam, new ThrowingUnsupportedParameterValueTransformer(this.luceneClass, luceneParam));
        }

        public SimpleAnalysisDefinitionFactoryBuilder<D> rename(String luceneParam, String elasticsearchParam) {
            if (this.parameterNameTranslations == null) {
                this.parameterNameTranslations = new HashMap<String, String>();
            }
            this.parameterNameTranslations.put(luceneParam, elasticsearchParam);
            return this;
        }

        public MapParameterValueTransformerBuilder<D> transform(String luceneParam) {
            return new MapParameterValueTransformerBuilder(this, this.luceneClass, luceneParam);
        }

        public SimpleAnalysisDefinitionFactoryBuilder<D> transform(String luceneParam, ParameterValueTransformer transformer) {
            if (this.parameterValueTranslations == null) {
                this.parameterValueTranslations = new HashMap<String, ParameterValueTransformer>();
            }
            this.parameterValueTranslations.put(luceneParam, transformer);
            return this;
        }

        public LuceneAnalysisDefinitionTranslationMapBuilder<D> end() {
            if (this.staticParameters != null) {
                this.parametersTransformers.add(0, new StaticParametersTransformer(this.staticParameters));
            }
            if (this.parameterNameTranslations == null) {
                this.parameterNameTranslations = Collections.emptyMap();
            }
            if (this.parameterValueTranslations == null) {
                this.parameterValueTranslations = Collections.emptyMap();
            }
            this.parametersTransformers.add(new SimpleParametersTransformer(this.parameterNameTranslations, this.parameterValueTranslations));
            return this.parent.add(this.luceneClass, new SimpleAnalysisDefinitionFactory(((LuceneAnalysisDefinitionTranslationMapBuilder)this.parent).targetClass, this.typeName, this.parametersTransformers));
        }
    }
}

