/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl.gson;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractExtraPropertiesJsonAdapter<T>
extends TypeAdapter<T> {
    private final Map<String, ? extends FieldAdapter<? super T>> fieldAdapters;
    private final ExtraPropertyAdapter<? super T> extraPropertyAdapter;

    public AbstractExtraPropertiesJsonAdapter(Map<String, ? extends FieldAdapter<? super T>> fieldAdapters, ExtraPropertyAdapter<? super T> extraPropertyAdapter) {
        this.fieldAdapters = fieldAdapters;
        this.extraPropertyAdapter = extraPropertyAdapter;
    }

    public T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        T instance = this.createInstance();
        try {
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                FieldAdapter<T> fieldAdapter = this.fieldAdapters.get(name);
                if (fieldAdapter == null) {
                    this.extraPropertyAdapter.readOne(in, name, instance);
                    continue;
                }
                fieldAdapter.read(in, instance);
            }
            in.endObject();
        }
        catch (IllegalStateException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        return instance;
    }

    public void write(JsonWriter out, T instance) throws IOException {
        if (instance == null) {
            out.nullValue();
        }
        out.beginObject();
        for (Map.Entry<String, FieldAdapter<T>> entry : this.fieldAdapters.entrySet()) {
            FieldAdapter<T> fieldAdapter = entry.getValue();
            if (!fieldAdapter.serialized()) continue;
            out.name(entry.getKey());
            entry.getValue().write(out, instance);
        }
        this.extraPropertyAdapter.writeAll(out, instance);
        out.endObject();
    }

    protected abstract T createInstance();

    static interface ExtraPropertyAdapter<T> {
        public void readOne(JsonReader var1, String var2, T var3) throws IOException;

        public void writeAll(JsonWriter var1, T var2) throws IOException;
    }

    static interface FieldAdapter<T> {
        public void read(JsonReader var1, T var2) throws IOException;

        public void write(JsonWriter var1, T var2) throws IOException;

        public boolean serialized();
    }
}

