/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalDateTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;

public class ElasticsearchOffsetDateTimeBridge
extends ElasticsearchTemporalAccessorStringBridge<OffsetDateTime> {
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchLocalDateTimeBridge.FORMATTER).appendOffsetId().toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchOffsetDateTimeBridge INSTANCE = new ElasticsearchOffsetDateTimeBridge();

    private ElasticsearchOffsetDateTimeBridge() {
        super(FORMATTER, OffsetDateTime.class);
    }

    @Override
    OffsetDateTime parse(DateTimeFormatter formatter, String stringValue) throws DateTimeParseException {
        return OffsetDateTime.parse(stringValue, formatter);
    }
}

