/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.cluster.Health;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import io.searchbox.indices.IndicesExists;
import io.searchbox.indices.mapping.PutMapping;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.analyzer.impl.RemoteAnalyzer;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerProvider;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchEnvironment;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.client.impl.BackendRequestProcessor;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.elasticsearch.impl.ElasticSearchIndexNullAsHelper;
import org.hibernate.search.elasticsearch.impl.ElasticsearchFieldType;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexWorkVisitor;
import org.hibernate.search.elasticsearch.impl.FieldHelper;
import org.hibernate.search.elasticsearch.impl.GsonService;
import org.hibernate.search.elasticsearch.impl.IndexNameNormalizer;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.spi.ElasticsearchIndexManagerType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.spatial.impl.SpatialHelper;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchIndexManager
implements IndexManager,
RemoteAnalyzerProvider {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final String ANALYZED = "analyzed";
    private static final String NOT_ANALYZED = "not_analyzed";
    private static final String NOT_INDEXED = "no";
    private String indexName;
    private String actualIndexName;
    private boolean refreshAfterWrite;
    private IndexSchemaManagementStrategy indexManagementStrategy;
    private String indexManagementWaitTimeout;
    private boolean multitenancyEnabled;
    private IndexStatus requiredIndexStatus;
    private Similarity similarity;
    private ExtendedSearchIntegrator searchIntegrator;
    private final Set<Class<?>> containedEntityTypes = new HashSet();
    private ServiceManager serviceManager;
    private GsonService gsonService;
    private ElasticsearchIndexWorkVisitor visitor;
    private JestClient jestClient;
    private BackendRequestProcessor requestProcessor;

    public void initialize(String indexName, Properties properties, Similarity similarity, WorkerBuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.indexName = ElasticsearchIndexManager.getIndexName(indexName, properties);
        this.requiredIndexStatus = ElasticsearchIndexManager.getRequiredIndexStatus(properties);
        this.indexManagementStrategy = ElasticsearchIndexManager.getIndexManagementStrategy(properties);
        this.indexManagementWaitTimeout = ElasticsearchIndexManager.getIndexManagementWaitTimeout(properties);
        this.actualIndexName = IndexNameNormalizer.getElasticsearchIndexName(this.indexName);
        this.refreshAfterWrite = ElasticsearchIndexManager.getRefreshAfterWrite(properties);
        this.multitenancyEnabled = context.isMultitenancyEnabled();
        this.similarity = similarity;
        this.gsonService = (GsonService)this.serviceManager.requestService(GsonService.class);
        this.jestClient = (JestClient)this.serviceManager.requestService(JestClient.class);
        this.visitor = new ElasticsearchIndexWorkVisitor(this.actualIndexName, this.refreshAfterWrite, context.getUninitializedSearchIntegrator());
        this.requestProcessor = (BackendRequestProcessor)context.getServiceManager().requestService(BackendRequestProcessor.class);
    }

    private static String getIndexName(String indexName, Properties properties) {
        String name = properties.getProperty("indexName");
        return name != null ? name : indexName;
    }

    private static IndexSchemaManagementStrategy getIndexManagementStrategy(Properties properties) {
        String strategy = properties.getProperty("elasticsearch.index_schema_management_strategy");
        return strategy != null ? IndexSchemaManagementStrategy.valueOf(strategy) : ElasticsearchEnvironment.Defaults.INDEX_SCHEMA_MANAGEMENT_STRATEGY;
    }

    private static String getIndexManagementWaitTimeout(Properties properties) {
        int timeout = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.index_management_wait_timeout", (int)10000);
        if (timeout < 0) {
            throw LOG.negativeTimeoutValue(timeout);
        }
        return timeout + "ms";
    }

    private static IndexStatus getRequiredIndexStatus(Properties properties) {
        String status = ConfigurationParseHelper.getString((Properties)properties, (String)"elasticsearch.required_index_status", (String)"green");
        return IndexStatus.fromString(status);
    }

    private static boolean getRefreshAfterWrite(Properties properties) {
        return ConfigurationParseHelper.getBooleanValue((Properties)properties, (String)"elasticsearch.refresh_after_write", (boolean)false);
    }

    public void destroy() {
        if (this.indexManagementStrategy == IndexSchemaManagementStrategy.RECREATE_DELETE) {
            this.deleteIndexIfExisting();
        }
        this.requestProcessor = null;
        this.serviceManager.releaseService(BackendRequestProcessor.class);
        this.serviceManager.releaseService(JestClient.class);
        this.jestClient = null;
        this.serviceManager.releaseService(GsonService.class);
        this.gsonService = null;
    }

    public void setSearchFactory(ExtendedSearchIntegrator boundSearchIntegrator) {
        this.searchIntegrator = boundSearchIntegrator;
        this.initializeIndex();
    }

    private void initializeIndex() {
        if (this.indexManagementStrategy == IndexSchemaManagementStrategy.NONE) {
            return;
        }
        if (this.indexManagementStrategy == IndexSchemaManagementStrategy.CREATE) {
            if (this.createIndexIfNotYetExisting()) {
                this.createIndexMappings();
            }
        } else if (this.indexManagementStrategy == IndexSchemaManagementStrategy.RECREATE || this.indexManagementStrategy == IndexSchemaManagementStrategy.RECREATE_DELETE) {
            this.deleteIndexIfExisting();
            this.createIndex();
            this.createIndexMappings();
        } else if (this.indexManagementStrategy == IndexSchemaManagementStrategy.MERGE) {
            this.createIndexIfNotYetExisting();
            this.createIndexMappings();
        }
    }

    public void addContainedEntity(Class<?> entity) {
        this.containedEntityTypes.add(entity);
    }

    private void createIndex() {
        CreateIndex createIndex = new CreateIndex.Builder(this.actualIndexName).build();
        this.jestClient.executeRequest(createIndex);
        this.waitForIndexCreation();
    }

    private void waitForIndexCreation() {
        Health.Builder healthBuilder = (Health.Builder)((Health.Builder)new Health.Builder().setParameter("wait_for_status", (Object)this.requiredIndexStatus.getElasticsearchString())).setParameter("timeout", (Object)this.indexManagementWaitTimeout);
        Health health = new Health(healthBuilder){

            protected String buildURI() {
                return super.buildURI() + ElasticsearchIndexManager.this.actualIndexName;
            }
        };
        Object result = this.jestClient.executeRequest(health, new int[]{408});
        if (!result.isSucceeded()) {
            String status = result.getJsonObject().get("status").getAsString();
            throw LOG.unexpectedIndexStatus(this.actualIndexName, this.requiredIndexStatus.getElasticsearchString(), status);
        }
    }

    private boolean createIndexIfNotYetExisting() {
        if (this.jestClient.executeRequest(new IndicesExists.Builder(this.actualIndexName).build(), new int[]{404}).getResponseCode() == 200) {
            return false;
        }
        Object result = this.jestClient.executeRequest(new CreateIndex.Builder(this.actualIndexName).build(), new String[]{"index_already_exists_exception"});
        return result.isSucceeded();
    }

    private void deleteIndexIfExisting() {
        block3: {
            if (this.jestClient.executeRequest(new IndicesExists.Builder(this.actualIndexName).build(), new int[]{404}).getResponseCode() == 404) {
                return;
            }
            try {
                this.jestClient.executeRequest(new DeleteIndex.Builder(this.actualIndexName).build());
            }
            catch (SearchException e) {
                if (e.getMessage().contains("index_not_found_exception")) break block3;
                throw e;
            }
        }
    }

    private void createIndexMappings() {
        for (Class<?> entityType : this.containedEntityTypes) {
            EntityIndexBinding descriptor = this.searchIntegrator.getIndexBinding(entityType);
            JsonObject payload = new JsonObject();
            payload.addProperty("dynamic", "strict");
            JsonObject properties = new JsonObject();
            payload.add("properties", (JsonElement)properties);
            if (this.multitenancyEnabled) {
                JsonObject field = new JsonObject();
                field.addProperty("type", ElasticsearchFieldType.STRING.getElasticsearchString());
                field.addProperty("index", NOT_ANALYZED);
                properties.add("__HSearch_TenantId", (JsonElement)field);
            }
            for (DocumentFieldMetadata fieldMetadata : descriptor.getDocumentBuilder().getTypeMetadata().getAllDocumentFieldMetadata()) {
                if (fieldMetadata.isId() || fieldMetadata.getFieldName().isEmpty() || fieldMetadata.getFieldName().endsWith(".") || fieldMetadata.isSpatial()) continue;
                try {
                    this.addFieldMapping(payload, descriptor, fieldMetadata);
                }
                catch (IncompleteDataException e) {
                    LOG.debug("Not adding a mapping for field " + fieldMetadata.getFieldName() + " because of incomplete data", (Throwable)((Object)e));
                }
            }
            for (BridgeDefinedField bridgeDefinedField : this.getAllBridgeDefinedFields(descriptor)) {
                try {
                    this.addFieldMapping(payload, descriptor, bridgeDefinedField);
                }
                catch (IncompleteDataException e) {
                    LOG.debug("Not adding a mapping for field " + bridgeDefinedField.getName() + " because of incomplete data", (Throwable)((Object)e));
                }
            }
            PutMapping putMapping = new PutMapping.Builder(this.actualIndexName, entityType.getName(), (Object)payload).build();
            try {
                this.jestClient.executeRequest(putMapping);
            }
            catch (Exception e) {
                throw LOG.elasticsearchMappingCreationFailed(entityType.getName(), e);
            }
        }
    }

    private String analyzerName(Class<?> entityType, String fieldName, AnalyzerReference analyzerReference) {
        if (analyzerReference.is(RemoteAnalyzerReference.class)) {
            return ((RemoteAnalyzerReference)analyzerReference.unwrap(RemoteAnalyzerReference.class)).getAnalyzer().getName(fieldName);
        }
        LOG.analyzerIsNotRemote(entityType, fieldName, analyzerReference);
        return null;
    }

    private void addFieldMapping(JsonObject payload, EntityIndexBinding descriptor, DocumentFieldMetadata fieldMetadata) {
        String simpleFieldName = FieldHelper.getEmbeddedFieldPropertyName(fieldMetadata.getName());
        JsonObject field = new JsonObject();
        ElasticsearchFieldType fieldType = this.addTypeOptions(field, descriptor, fieldMetadata);
        field.addProperty("store", Boolean.valueOf(fieldMetadata.getStore() != Store.NO));
        this.addIndexOptions(field, descriptor, fieldMetadata.getName(), fieldType, fieldMetadata.getIndex(), fieldMetadata.getAnalyzerReference());
        if (fieldMetadata.getBoost() != null) {
            field.addProperty("boost", (Number)fieldMetadata.getBoost());
        }
        if (fieldMetadata.indexNullAs() != null) {
            JsonElement nullValueJsonElement = this.getNullValue(descriptor, fieldType, fieldMetadata);
            field.add("null_value", nullValueJsonElement);
        }
        this.getOrCreateProperties(payload, fieldMetadata.getName()).add(simpleFieldName, (JsonElement)field);
        for (FacetMetadata facetMetadata : fieldMetadata.getFacetMetadata()) {
            if (facetMetadata.getFacetName().equals(fieldMetadata.getFieldName())) continue;
            try {
                this.addFieldMapping(payload, facetMetadata);
            }
            catch (IncompleteDataException e) {
                LOG.debug("Not adding a mapping for facet " + facetMetadata.getFacetName() + " because of incomplete data", (Throwable)((Object)e));
            }
        }
    }

    private void addFieldMapping(JsonObject payload, EntityIndexBinding binding, BridgeDefinedField bridgeDefinedField) {
        String fieldName = bridgeDefinedField.getName();
        String simpleFieldName = FieldHelper.getEmbeddedFieldPropertyName(fieldName);
        if (!SpatialHelper.isSpatialField((String)simpleFieldName)) {
            JsonObject field = new JsonObject();
            ElasticsearchFieldType fieldType = this.addTypeOptions(field, bridgeDefinedField);
            this.addIndexOptions(field, binding, fieldName, fieldType, bridgeDefinedField.getIndex(), null);
            JsonObject parent = this.getOrCreateProperties(payload, fieldName);
            if (!parent.has(simpleFieldName)) {
                parent.add(simpleFieldName, (JsonElement)field);
            }
        } else {
            if (SpatialHelper.isSpatialFieldLongitude((String)simpleFieldName)) {
                return;
            }
            if (SpatialHelper.isSpatialFieldLatitude((String)simpleFieldName)) {
                JsonObject field = new JsonObject();
                field.addProperty("type", ElasticsearchFieldType.GEO_POINT.getElasticsearchString());
                this.getOrCreateProperties(payload, fieldName).add(SpatialHelper.getSpatialFieldRootName((String)simpleFieldName), (JsonElement)field);
            } else {
                JsonObject field = new JsonObject();
                field.addProperty("type", ElasticsearchFieldType.STRING.getElasticsearchString());
                field.addProperty("index", NOT_ANALYZED);
                this.getOrCreateProperties(payload, fieldName).add(fieldName, (JsonElement)field);
            }
        }
    }

    private JsonObject addFieldMapping(JsonObject payload, FacetMetadata facetMetadata) {
        String simpleFieldName = FieldHelper.getEmbeddedFieldPropertyName(facetMetadata.getFacetName());
        String fullFieldName = facetMetadata.getFacetName();
        JsonObject field = new JsonObject();
        this.addTypeOptions(field, facetMetadata);
        field.addProperty("store", Boolean.valueOf(false));
        field.addProperty("index", NOT_ANALYZED);
        this.getOrCreateProperties(payload, fullFieldName).add(simpleFieldName, (JsonElement)field);
        return field;
    }

    private void addIndexOptions(JsonObject field, EntityIndexBinding binding, String fieldName, ElasticsearchFieldType fieldType, Field.Index index, AnalyzerReference analyzerReference) {
        String analyzerName;
        String elasticsearchIndex;
        switch (index) {
            case ANALYZED: 
            case ANALYZED_NO_NORMS: {
                elasticsearchIndex = this.canTypeBeAnalyzed(fieldType) ? ANALYZED : NOT_ANALYZED;
                break;
            }
            case NOT_ANALYZED: 
            case NOT_ANALYZED_NO_NORMS: {
                elasticsearchIndex = NOT_ANALYZED;
                break;
            }
            case NO: {
                elasticsearchIndex = NOT_INDEXED;
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected index type: " + index);
            }
        }
        field.addProperty("index", elasticsearchIndex);
        if (NOT_INDEXED.equals(elasticsearchIndex) && FieldHelper.isSortableField(binding, fieldName)) {
            field.addProperty("doc_values", Boolean.valueOf(true));
        }
        if (ANALYZED.equals(elasticsearchIndex) && analyzerReference != null && (analyzerName = this.analyzerName(binding.getDocumentBuilder().getBeanClass(), fieldName, analyzerReference)) != null) {
            field.addProperty("analyzer", analyzerName);
        }
    }

    private boolean canTypeBeAnalyzed(ElasticsearchFieldType fieldType) {
        return ElasticsearchFieldType.STRING.equals((Object)fieldType);
    }

    private ElasticsearchFieldType addTypeOptions(JsonObject field, EntityIndexBinding descriptor, DocumentFieldMetadata fieldMetadata) {
        return this.addTypeOptions(fieldMetadata.getFieldName(), field, FieldHelper.getType(descriptor, fieldMetadata));
    }

    private ElasticsearchFieldType addTypeOptions(JsonObject field, BridgeDefinedField bridgeDefinedField) {
        FieldHelper.ExtendedFieldType type = FieldHelper.getType(bridgeDefinedField);
        if (FieldHelper.ExtendedFieldType.UNKNOWN.equals((Object)type)) {
            throw LOG.unexpectedFieldType(bridgeDefinedField.getType().name(), bridgeDefinedField.getName());
        }
        return this.addTypeOptions(bridgeDefinedField.getName(), field, FieldHelper.getType(bridgeDefinedField));
    }

    private ElasticsearchFieldType addTypeOptions(JsonObject field, FacetMetadata facetMetadata) {
        FieldHelper.ExtendedFieldType type;
        switch (facetMetadata.getEncoding()) {
            case DOUBLE: {
                type = FieldHelper.ExtendedFieldType.DOUBLE;
                break;
            }
            case LONG: {
                type = FieldHelper.ExtendedFieldType.LONG;
                break;
            }
            case STRING: {
                type = FieldHelper.ExtendedFieldType.STRING;
                break;
            }
            case AUTO: {
                throw new AssertionFailure("The facet type should have been resolved during bootstrapping");
            }
            default: {
                throw new AssertionFailure("Unexpected facet encoding type '" + facetMetadata.getEncoding() + "' Has the enum been modified?");
            }
        }
        return this.addTypeOptions(facetMetadata.getFacetName(), field, type);
    }

    private ElasticsearchFieldType addTypeOptions(String fieldName, JsonObject field, FieldHelper.ExtendedFieldType extendedType) {
        ElasticsearchFieldType elasticsearchType;
        ArrayList<String> formats = new ArrayList<String>();
        switch (extendedType) {
            case BOOLEAN: {
                elasticsearchType = ElasticsearchFieldType.BOOLEAN;
                break;
            }
            case CALENDAR: 
            case DATE: 
            case INSTANT: {
                elasticsearchType = ElasticsearchFieldType.DATE;
                break;
            }
            case LOCAL_DATE: {
                elasticsearchType = ElasticsearchFieldType.DATE;
                formats.add("strict_date");
                formats.add("yyyyyyyyy-MM-dd");
                break;
            }
            case LOCAL_DATE_TIME: {
                elasticsearchType = ElasticsearchFieldType.DATE;
                formats.add("strict_date_hour_minute_second_fraction");
                formats.add("yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS");
                break;
            }
            case LOCAL_TIME: {
                elasticsearchType = ElasticsearchFieldType.DATE;
                formats.add("strict_hour_minute_second_fraction");
                break;
            }
            case OFFSET_DATE_TIME: {
                elasticsearchType = ElasticsearchFieldType.DATE;
                formats.add("strict_date_time");
                formats.add("yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZ");
                break;
            }
            case OFFSET_TIME: {
                elasticsearchType = ElasticsearchFieldType.DATE;
                formats.add("strict_time");
                break;
            }
            case ZONED_DATE_TIME: {
                elasticsearchType = ElasticsearchFieldType.DATE;
                formats.add("yyyy-MM-dd'T'HH:mm:ss.SSSZZ'['ZZZ']'");
                formats.add("yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZZ'['ZZZ']'");
                break;
            }
            case YEAR: {
                elasticsearchType = ElasticsearchFieldType.DATE;
                formats.add("strict_year");
                formats.add("yyyyyyyyy");
                break;
            }
            case YEAR_MONTH: {
                elasticsearchType = ElasticsearchFieldType.DATE;
                formats.add("strict_year_month");
                formats.add("yyyyyyyyy-MM");
                break;
            }
            case MONTH_DAY: {
                elasticsearchType = ElasticsearchFieldType.DATE;
                formats.add("--MM-dd");
                break;
            }
            case INTEGER: {
                elasticsearchType = ElasticsearchFieldType.INTEGER;
                break;
            }
            case LONG: {
                elasticsearchType = ElasticsearchFieldType.LONG;
                break;
            }
            case FLOAT: {
                elasticsearchType = ElasticsearchFieldType.FLOAT;
                break;
            }
            case DOUBLE: {
                elasticsearchType = ElasticsearchFieldType.DOUBLE;
                break;
            }
            case UNKNOWN_NUMERIC: {
                elasticsearchType = null;
                break;
            }
            default: {
                elasticsearchType = ElasticsearchFieldType.STRING;
            }
        }
        if (elasticsearchType == null) {
            throw new IncompleteDataException("Field type could not be determined");
        }
        field.addProperty("type", elasticsearchType.getElasticsearchString());
        if (!formats.isEmpty()) {
            field.addProperty("format", StringHelper.join(formats, (String)"||"));
        }
        return elasticsearchType;
    }

    private JsonElement getNullValue(EntityIndexBinding indexBinding, ElasticsearchFieldType dataType, DocumentFieldMetadata fieldMetadata) {
        Gson gson = this.gsonService.getGson();
        Object convertedValue = ElasticSearchIndexNullAsHelper.getNullValue(fieldMetadata.getName(), dataType, fieldMetadata.indexNullAs());
        return gson.toJsonTree(convertedValue);
    }

    private JsonObject getOrCreateProperties(JsonObject mapping, String fieldName) {
        if (!FieldHelper.isEmbeddedField(fieldName)) {
            return mapping.getAsJsonObject("properties");
        }
        JsonObject parentProperties = mapping.getAsJsonObject("properties");
        String[] parts = fieldName.split("\\.");
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            JsonObject property = parentProperties.getAsJsonObject(part);
            if (property == null) {
                property = new JsonObject();
                JsonObject properties = new JsonObject();
                property.add("properties", (JsonElement)properties);
                parentProperties.add(part, (JsonElement)property);
                parentProperties = properties;
                continue;
            }
            parentProperties = property.getAsJsonObject("properties");
        }
        return parentProperties;
    }

    private Set<BridgeDefinedField> getAllBridgeDefinedFields(EntityIndexBinding binding) {
        HashSet<BridgeDefinedField> bridgeDefinedFields = new HashSet<BridgeDefinedField>();
        this.collectPropertyLevelBridgeDefinedFields(binding.getDocumentBuilder().getMetadata(), bridgeDefinedFields);
        return bridgeDefinedFields;
    }

    private void collectPropertyLevelBridgeDefinedFields(TypeMetadata type, Set<BridgeDefinedField> allBridgeDefinedFields) {
        allBridgeDefinedFields.addAll(type.getClassBridgeDefinedFields());
        if (type.getIdPropertyMetadata() != null) {
            allBridgeDefinedFields.addAll(type.getIdPropertyMetadata().getBridgeDefinedFields().values());
        }
        for (PropertyMetadata property : type.getAllPropertyMetadata()) {
            allBridgeDefinedFields.addAll(property.getBridgeDefinedFields().values());
        }
        for (TypeMetadata embeddedType : type.getEmbeddedTypeMetadata()) {
            this.collectPropertyLevelBridgeDefinedFields(embeddedType, allBridgeDefinedFields);
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ReaderProvider getReaderProvider() {
        throw LOG.indexManagerReaderProviderUnsupported();
    }

    public Set<Class<?>> getContainedTypes() {
        return this.containedEntityTypes;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public Analyzer getAnalyzer(String name) {
        return this.searchIntegrator.getAnalyzer(name);
    }

    public LuceneWorkSerializer getSerializer() {
        return null;
    }

    public void flushAndReleaseResources() {
    }

    public String getActualIndexName() {
        return this.actualIndexName;
    }

    public boolean needsRefreshAfterWrite() {
        return this.refreshAfterWrite;
    }

    public void performOperations(List<LuceneWork> workList, IndexingMonitor monitor) {
        ArrayList requests = new ArrayList(workList.size());
        for (LuceneWork luceneWork : workList) {
            requests.add((BackendRequest<?>)luceneWork.acceptIndexWorkVisitor((IndexWorkVisitor)this.visitor, null));
        }
        this.requestProcessor.executeSync(requests);
    }

    public void performStreamOperation(LuceneWork singleOperation, IndexingMonitor monitor, boolean forceAsync) {
        if (singleOperation == FlushLuceneWork.INSTANCE) {
            this.requestProcessor.awaitAsyncProcessingCompletion();
        } else {
            BackendRequest request = (BackendRequest)singleOperation.acceptIndexWorkVisitor((IndexWorkVisitor)this.visitor, null);
            if (request != null) {
                this.requestProcessor.executeAsync(request);
            }
        }
    }

    public void optimize() {
        this.performStreamOperation((LuceneWork)OptimizeLuceneWork.INSTANCE, null, false);
    }

    public String toString() {
        return "ElasticsearchIndexManager [actualIndexName=" + this.actualIndexName + "]";
    }

    public RemoteAnalyzer getRemoteAnalyzer(String name) {
        return new RemoteAnalyzer(name);
    }

    public IndexManagerType getIndexManagerType() {
        return ElasticsearchIndexManagerType.INSTANCE;
    }

    private static class IncompleteDataException
    extends SearchException {
        public IncompleteDataException(String message) {
            super(message);
        }
    }

    private static enum IndexStatus {
        GREEN("green"),
        YELLOW("yellow"),
        RED("red");

        private final String elasticsearchString;

        private IndexStatus(String elasticsearchString) {
            this.elasticsearchString = elasticsearchString;
        }

        public String getElasticsearchString() {
            return this.elasticsearchString;
        }

        static IndexStatus fromString(String status) {
            for (IndexStatus indexStatus : IndexStatus.values()) {
                if (!indexStatus.getElasticsearchString().equalsIgnoreCase(status)) continue;
                return indexStatus;
            }
            throw LOG.unexpectedIndexStatusString(status);
        }
    }
}

