/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.Date;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.model.DataType;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchDateHelper;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ElasticSearchIndexNullAsHelper {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);

    private ElasticSearchIndexNullAsHelper() {
    }

    public static Object getNullValue(String fieldName, DataType dataType, String indexNullAs) {
        switch (dataType) {
            case STRING: {
                return indexNullAs;
            }
            case DOUBLE: {
                return ElasticSearchIndexNullAsHelper.toDouble(indexNullAs, fieldName);
            }
            case FLOAT: {
                return ElasticSearchIndexNullAsHelper.toFloat(indexNullAs, fieldName);
            }
            case INTEGER: {
                return ElasticSearchIndexNullAsHelper.toInteger(indexNullAs, fieldName);
            }
            case LONG: {
                return ElasticSearchIndexNullAsHelper.toLong(indexNullAs, fieldName);
            }
            case DATE: {
                return ElasticSearchIndexNullAsHelper.toDate(indexNullAs, fieldName);
            }
            case BOOLEAN: {
                return ElasticSearchIndexNullAsHelper.toBoolean(indexNullAs, fieldName);
            }
        }
        throw new AssertionFailure("Unexpected Elasticsearch datatype: " + (Object)((Object)dataType));
    }

    private static Long toLong(String proposedTokenValue, String fieldName) {
        try {
            return Long.parseLong(proposedTokenValue);
        }
        catch (NumberFormatException nfe) {
            throw LOG.nullMarkerNeedsToRepresentALongNumber(proposedTokenValue, fieldName);
        }
    }

    private static Integer toInteger(String proposedTokenValue, String fieldName) {
        try {
            return Integer.parseInt(proposedTokenValue);
        }
        catch (NumberFormatException nfe) {
            throw LOG.nullMarkerNeedsToRepresentAnIntegerNumber(proposedTokenValue, fieldName);
        }
    }

    private static Float toFloat(String proposedTokenValue, String fieldName) {
        try {
            return Float.valueOf(Float.parseFloat(proposedTokenValue));
        }
        catch (NumberFormatException nfe) {
            throw LOG.nullMarkerNeedsToRepresentAFloatNumber(proposedTokenValue, fieldName);
        }
    }

    private static Double toDouble(String proposedTokenValue, String fieldName) {
        try {
            return Double.parseDouble(proposedTokenValue);
        }
        catch (NumberFormatException nfe) {
            throw LOG.nullMarkerNeedsToRepresentADoubleNumber(proposedTokenValue, fieldName);
        }
    }

    private static Boolean toBoolean(String indexNullAs, String fieldName) {
        if (Boolean.TRUE.toString().equals(indexNullAs)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equals(indexNullAs)) {
            return Boolean.FALSE;
        }
        throw LOG.nullMarkerNeedsToRepresentABoolean(indexNullAs, fieldName);
    }

    private static Date toDate(String indexNullAs, String fieldName) {
        try {
            return ElasticsearchDateHelper.stringToDate(indexNullAs);
        }
        catch (IllegalArgumentException e) {
            throw LOG.nullMarkerNeedsToRepresentADate(indexNullAs, fieldName);
        }
    }
}

