/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.Map;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.model.DataType;
import org.hibernate.search.elasticsearch.schema.impl.model.PropertyMapping;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.elasticsearch.util.impl.PathComponentExtractor;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class ElasticsearchMappingBuilder {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final EntityIndexBinding binding;
    private final ElasticsearchMappingBuilder parent;
    private final TypeMetadata typeMetadata;
    private final PathComponentExtractor pathComponentExtractor;
    private final TypeMapping elasticsearchMapping;

    public ElasticsearchMappingBuilder(EntityIndexBinding binding, TypeMapping elasticsearchMapping) {
        this(null, binding, binding.getDocumentBuilder().getTypeMetadata(), elasticsearchMapping, new PathComponentExtractor());
    }

    private ElasticsearchMappingBuilder(ElasticsearchMappingBuilder parent, EntityIndexBinding binding, TypeMetadata typeMetadata, TypeMapping elasticsearchMapping, PathComponentExtractor pathComponentExtractor) {
        this.binding = binding;
        this.parent = parent;
        this.elasticsearchMapping = elasticsearchMapping;
        this.typeMetadata = typeMetadata;
        this.pathComponentExtractor = pathComponentExtractor;
    }

    public ElasticsearchMappingBuilder createEmbedded(EmbeddedTypeMetadata embeddedTypeMetadata) {
        PathComponentExtractor newExtractor = this.pathComponentExtractor.clone();
        newExtractor.append(embeddedTypeMetadata.getEmbeddedFieldPrefix());
        TypeMapping newElasticsearchMapping = this.getOrCreateParents(newExtractor);
        return new ElasticsearchMappingBuilder(this, this.binding, (TypeMetadata)embeddedTypeMetadata, newElasticsearchMapping, newExtractor);
    }

    private TypeMapping getOrCreateParents(PathComponentExtractor extractor) {
        TypeMapping currentElasticsearchMapping = this.elasticsearchMapping;
        String newPathComponent = extractor.next(PathComponentExtractor.ConsumptionLimit.SECOND_BUT_LAST);
        while (newPathComponent != null) {
            PropertyMapping childPropertyMapping = ElasticsearchMappingBuilder.getPropertyRelative(currentElasticsearchMapping, newPathComponent);
            if (childPropertyMapping == null) {
                childPropertyMapping = new PropertyMapping();
                childPropertyMapping.setType(DataType.OBJECT);
                currentElasticsearchMapping.addProperty(newPathComponent, childPropertyMapping);
            }
            if (!DataType.OBJECT.equals((Object)childPropertyMapping.getType())) {
                throw LOG.fieldIsBothCompositeAndConcrete(this.getBeanClass(), extractor.getLastComponentAbsolutePath());
            }
            currentElasticsearchMapping = childPropertyMapping;
            newPathComponent = extractor.next(PathComponentExtractor.ConsumptionLimit.SECOND_BUT_LAST);
        }
        return currentElasticsearchMapping;
    }

    private static PropertyMapping getPropertyRelative(TypeMapping parent, String name) {
        Map<String, PropertyMapping> properties = parent.getProperties();
        if (properties == null) {
            return null;
        }
        return properties.get(name);
    }

    public boolean hasPropertyAbsolute(String absolutePath) {
        PathComponentExtractor newExtractor = this.pathComponentExtractor.clone();
        newExtractor.appendRelativePart(absolutePath);
        TypeMapping parent = this.getOrCreateParents(newExtractor);
        String propertyName = newExtractor.next(PathComponentExtractor.ConsumptionLimit.LAST);
        return ElasticsearchMappingBuilder.getPropertyRelative(parent, propertyName) != null;
    }

    public void setPropertyAbsolute(String absolutePath, PropertyMapping propertyMapping) {
        PathComponentExtractor newExtractor = this.pathComponentExtractor.clone();
        newExtractor.appendRelativePart(absolutePath);
        TypeMapping parent = this.getOrCreateParents(newExtractor);
        String propertyName = newExtractor.next(PathComponentExtractor.ConsumptionLimit.LAST);
        Map<String, PropertyMapping> parentProperties = parent.getProperties();
        if (parentProperties != null && parentProperties.containsKey(propertyName)) {
            PropertyMapping conflictingProperty = parentProperties.get(propertyName);
            DataType conflictingPropertyType = conflictingProperty.getType();
            DataType newPropertyType = propertyMapping.getType();
            if (conflictingPropertyType.isComposite() != newPropertyType.isComposite()) {
                throw LOG.fieldIsBothCompositeAndConcrete(this.getBeanClass(), absolutePath);
            }
        }
        parent.addProperty(propertyName, propertyMapping);
    }

    public TypeMetadata getMetadata() {
        return this.typeMetadata;
    }

    public float getBoost(Float propertyBoost) {
        float boost = propertyBoost == null ? 1.0f : propertyBoost.floatValue();
        boost *= this.typeMetadata.getStaticBoost();
        if (this.parent != null) {
            return this.parent.getBoost(Float.valueOf(boost));
        }
        return boost;
    }

    public String getAnalyzerName(AnalyzerReference analyzerReference, String fieldName) {
        if (!analyzerReference.is(RemoteAnalyzerReference.class)) {
            LOG.analyzerIsNotRemote(this.getBeanClass(), fieldName, analyzerReference);
            return null;
        }
        return ((RemoteAnalyzerReference)analyzerReference.unwrap(RemoteAnalyzerReference.class)).getAnalyzer().getName(fieldName);
    }

    public Class<?> getBeanClass() {
        return this.binding.getDocumentBuilder().getBeanClass();
    }
}

