/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.backend.impl.batch.DefaultBatchBackend;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.impl.LuceneQueryDescriptor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.TimingSource;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.indexes.IndexReaderAccessor;
import org.hibernate.search.indexes.impl.DefaultIndexReaderAccessor;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.jmx.StatisticsInfoMBean;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.impl.IndexedTypeDescriptorForUnindexedType;
import org.hibernate.search.metadata.impl.IndexedTypeDescriptorImpl;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.impl.ConnectedQueryContextBuilder;
import org.hibernate.search.query.engine.impl.LuceneHSQuery;
import org.hibernate.search.query.engine.impl.LuceneQueryTranslator;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.impl.ExtendedSearchIntegratorWithShareableState;
import org.hibernate.search.spi.impl.PolymorphicIndexHierarchy;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.stat.impl.StatisticsImpl;
import org.hibernate.search.stat.spi.StatisticsImplementor;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ImmutableSearchFactory
implements ExtendedSearchIntegratorWithShareableState,
WorkerBuildContext {
    private static final Log log;
    private final Map<Class<?>, EntityIndexBinding> indexBindingForEntities;
    private final Map<Class<?>, DocumentBuilderContainedEntity> documentBuildersContainedEntities;
    private final ConcurrentHashMap<Class, IndexedTypeDescriptor> indexedTypeDescriptors;
    private final Worker worker;
    private final Map<String, FilterDef> filterDefinitions;
    private final FilterCachingStrategy filterCachingStrategy;
    private final Map<String, AnalyzerReference> analyzerReferences;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final int cacheBitResultsSize;
    private final Properties configurationProperties;
    private final PolymorphicIndexHierarchy indexHierarchy;
    private final StatisticsImpl statistics;
    private final boolean transactionManagerExpected;
    private final IndexManagerHolder allIndexesManager;
    private final ErrorHandler errorHandler;
    private final IndexingMode indexingMode;
    private final ServiceManager serviceManager;
    private final boolean queryTranslatorPresent;
    private final boolean enableDirtyChecks;
    private final DefaultIndexReaderAccessor indexReaderAccessor;
    private final InstanceInitializer instanceInitializer;
    private final TimeoutExceptionFactory timeoutExceptionFactory;
    private final TimingSource timingSource;
    private final SearchMapping mapping;
    private final boolean indexMetadataIsComplete;
    private final boolean isDeleteByTermEnforced;
    private final boolean isIdProvidedImplicit;
    private final boolean isMultitenancyEnabled;
    private final String statisticsMBeanName;
    private final IndexManagerFactory indexManagerFactory;
    private final ObjectLookupMethod defaultObjectLookupMethod;
    private final DatabaseRetrievalMethod defaultDatabaseRetrievalMethod;
    private final boolean enlistWorkerInTransaction;
    private final boolean indexUninvertingAllowed;
    private volatile LuceneWorkSerializer workSerializer;

    public ImmutableSearchFactory(SearchFactoryState state) {
        this.analyzerReferences = state.getAnalyzerReferences();
        this.cacheBitResultsSize = state.getCacheBitResultsSize();
        this.configurationProperties = state.getConfigurationProperties();
        this.indexBindingForEntities = state.getIndexBindings();
        this.documentBuildersContainedEntities = state.getDocumentBuildersContainedEntities();
        this.filterCachingStrategy = state.getFilterCachingStrategy();
        this.filterDefinitions = state.getFilterDefinitions();
        this.indexHierarchy = state.getIndexHierarchy();
        this.indexingMode = state.getIndexingMode();
        this.worker = state.getWorker();
        this.serviceManager = state.getServiceManager();
        this.queryTranslatorPresent = this.determineQueryTranslatorPresent();
        this.transactionManagerExpected = state.isTransactionManagerExpected();
        this.allIndexesManager = state.getAllIndexesManager();
        this.errorHandler = state.getErrorHandler();
        this.instanceInitializer = state.getInstanceInitializer();
        this.timeoutExceptionFactory = state.getDefaultTimeoutExceptionFactory();
        this.timingSource = state.getTimingSource();
        this.mapping = state.getProgrammaticMapping();
        if (state.getStatistics() == null) {
            this.statistics = new StatisticsImpl(this);
            boolean statsEnabled = ConfigurationParseHelper.getBooleanValue(this.configurationProperties, "hibernate.search.generate_statistics", false);
            this.statistics.setStatisticsEnabled(statsEnabled);
        } else {
            this.statistics = (StatisticsImpl)state.getStatistics();
        }
        this.indexMetadataIsComplete = state.isIndexMetadataComplete();
        this.isDeleteByTermEnforced = state.isDeleteByTermEnforced();
        this.isIdProvidedImplicit = state.isIdProvidedImplicit();
        this.isMultitenancyEnabled = state.isMultitenancyEnabled();
        this.indexManagerFactory = state.getIndexManagerFactory();
        this.enableDirtyChecks = ConfigurationParseHelper.getBooleanValue(this.configurationProperties, "hibernate.search.enable_dirty_check", true);
        this.statisticsMBeanName = this.isJMXEnabled() ? this.registerMBeans() : null;
        this.indexReaderAccessor = new DefaultIndexReaderAccessor(this);
        this.indexedTypeDescriptors = new ConcurrentHashMap();
        this.defaultObjectLookupMethod = this.determineDefaultObjectLookupMethod();
        this.defaultDatabaseRetrievalMethod = this.determineDefaultDatabaseRetrievalMethod();
        this.enlistWorkerInTransaction = ConfigurationParseHelper.getBooleanValue(this.configurationProperties, "hibernate.search.worker.enlist_in_transaction", false);
        this.indexUninvertingAllowed = ConfigurationParseHelper.getBooleanValue(this.configurationProperties, "hibernate.search.index_uninverting_allowed", true);
    }

    private ObjectLookupMethod determineDefaultObjectLookupMethod() {
        String objectLookupMethod = this.configurationProperties.getProperty("hibernate.search.query.object_lookup_method");
        if (objectLookupMethod == null) {
            return ObjectLookupMethod.SKIP;
        }
        try {
            return Enum.valueOf(ObjectLookupMethod.class, objectLookupMethod.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw log.invalidPropertyValue(objectLookupMethod, "hibernate.search.query.object_lookup_method");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean determineQueryTranslatorPresent() {
        try (ServiceReference<LuceneQueryTranslator> translator = this.getServiceManager().requestReference(LuceneQueryTranslator.class);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    private DatabaseRetrievalMethod determineDefaultDatabaseRetrievalMethod() {
        String databaseRetrievalMethod = this.configurationProperties.getProperty("hibernate.search.query.database_retrieval_method");
        if (databaseRetrievalMethod == null) {
            return DatabaseRetrievalMethod.QUERY;
        }
        try {
            return Enum.valueOf(DatabaseRetrievalMethod.class, databaseRetrievalMethod.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw log.invalidPropertyValue(databaseRetrievalMethod, "hibernate.search.query.object_lookup_method");
        }
    }

    @Override
    public Map<String, FilterDef> getFilterDefinitions() {
        return this.filterDefinitions;
    }

    @Override
    @Deprecated
    public String getIndexingStrategy() {
        return this.indexingMode.toExternalRepresentation();
    }

    @Override
    public IndexingMode getIndexingMode() {
        return this.indexingMode;
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.worker.close();
            }
            catch (Exception e) {
                log.workerException(e);
            }
            this.allIndexesManager.stop();
            this.timingSource.stop();
            this.serviceManager.releaseAllServices();
            for (AnalyzerReference analyzerReference : this.analyzerReferences.values()) {
                analyzerReference.close();
            }
            for (AbstractDocumentBuilder abstractDocumentBuilder : this.documentBuildersContainedEntities.values()) {
                abstractDocumentBuilder.close();
            }
            for (EntityIndexBinding entityIndexBinding : this.indexBindingForEntities.values()) {
                entityIndexBinding.getDocumentBuilder().close();
            }
            if (this.statisticsMBeanName != null) {
                JMXRegistrar.unRegisterMBean(this.statisticsMBeanName);
            }
        }
    }

    @Override
    @Deprecated
    public HSQuery createHSQuery() {
        return this.createLuceneBasedHSQuery();
    }

    @Override
    public HSQuery createHSQuery(Query luceneQuery, Class<?> ... entities) {
        QueryDescriptor descriptor = null;
        if (this.queryTranslatorPresent) {
            try (ServiceReference<LuceneQueryTranslator> translator = this.getServiceManager().requestReference(LuceneQueryTranslator.class);){
                if (translator.get().conversionRequired(entities)) {
                    descriptor = translator.get().convertLuceneQuery(luceneQuery);
                }
            }
        }
        if (descriptor == null) {
            descriptor = new LuceneQueryDescriptor(luceneQuery);
        }
        return descriptor.createHSQuery(this).targetedEntities(Arrays.asList(entities));
    }

    @Override
    public Map<Class<?>, DocumentBuilderContainedEntity> getDocumentBuildersContainedEntities() {
        return this.documentBuildersContainedEntities;
    }

    @Override
    public Map<Class<?>, EntityIndexBinding> getIndexBindings() {
        return this.indexBindingForEntities;
    }

    @Override
    public EntityIndexBinding getIndexBinding(Class<?> entityType) {
        return this.indexBindingForEntities.get(entityType);
    }

    public DocumentBuilderContainedEntity getDocumentBuilderContainedEntity(Class entityType) {
        return this.documentBuildersContainedEntities.get(entityType);
    }

    @Override
    public void addClasses(Class<?> ... classes) {
        throw new AssertionFailure("Cannot add classes to an " + ImmutableSearchFactory.class.getName());
    }

    @Override
    public Worker getWorker() {
        return this.worker;
    }

    @Override
    public void optimize() {
        for (IndexManager im : this.allIndexesManager.getIndexManagers()) {
            im.optimize();
        }
    }

    @Override
    public void optimize(Class entityType) {
        EntityIndexBinding entityIndexBinding = this.getSafeIndexBindingForEntity(entityType);
        for (IndexManager im : entityIndexBinding.getIndexManagers()) {
            im.optimize();
        }
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        AnalyzerReference reference = this.analyzerReferences.get(name);
        if (reference == null || !reference.is(LuceneAnalyzerReference.class)) {
            throw new SearchException("Unknown Analyzer definition: " + name);
        }
        Analyzer analyzer = reference.unwrap(LuceneAnalyzerReference.class).getAnalyzer();
        if (analyzer == null) {
            throw new SearchException("Unknown Analyzer definition: " + name);
        }
        return analyzer;
    }

    @Override
    public AnalyzerReference getAnalyzerReference(String name) {
        AnalyzerReference analyzerReference = this.analyzerReferences.get(name);
        if (analyzerReference == null) {
            throw new SearchException("Unknown Analyzer definition: " + name);
        }
        return analyzerReference;
    }

    @Override
    public Analyzer getAnalyzer(Class<?> clazz) {
        return this.getAnalyzerReference(clazz).unwrap(LuceneAnalyzerReference.class).getAnalyzer();
    }

    @Override
    public AnalyzerReference getAnalyzerReference(Class<?> clazz) {
        EntityIndexBinding entityIndexBinding = this.getSafeIndexBindingForEntity(clazz);
        DocumentBuilderIndexedEntity builder = entityIndexBinding.getDocumentBuilder();
        return builder.getAnalyzerReference();
    }

    @Override
    public QueryContextBuilder buildQueryBuilder() {
        return new ConnectedQueryContextBuilder(this);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.statistics;
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.filterCachingStrategy;
    }

    @Override
    public Map<String, AnalyzerReference> getAnalyzerReferences() {
        return this.analyzerReferences;
    }

    @Override
    public int getCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    public FilterDef getFilterDefinition(String name) {
        return this.filterDefinitions.get(name);
    }

    @Override
    public int getFilterCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public Set<Class<?>> getIndexedTypesPolymorphic(Class<?>[] classes) {
        return this.indexHierarchy.getIndexedClasses(classes);
    }

    @Override
    public BatchBackend makeBatchBackend(MassIndexerProgressMonitor progressMonitor) {
        return new DefaultBatchBackend(this, progressMonitor);
    }

    @Override
    public PolymorphicIndexHierarchy getIndexHierarchy() {
        return this.indexHierarchy;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseRetrievalMethod getDefaultDatabaseRetrievalMethod() {
        return this.defaultDatabaseRetrievalMethod;
    }

    @Override
    public ObjectLookupMethod getDefaultObjectLookupMethod() {
        return this.defaultObjectLookupMethod;
    }

    @Override
    public ExtendedSearchIntegrator getUninitializedSearchIntegrator() {
        return this;
    }

    @Override
    public boolean isJMXEnabled() {
        String enableJMX = this.getConfigurationProperties().getProperty("hibernate.search.jmx_enabled");
        return "true".equalsIgnoreCase(enableJMX);
    }

    private String registerMBeans() {
        String mbeanNameSuffix = this.getConfigurationProperties().getProperty("hibernate.search.jmx_bean_suffix");
        String objectName = JMXRegistrar.buildMBeanName("org.hibernate.search.jmx:type=StatisticsInfoMBean", mbeanNameSuffix);
        if (JMXRegistrar.isNameRegistered(objectName)) {
            JMXRegistrar.unRegisterMBean(objectName);
        }
        JMXRegistrar.StatisticsInfo statisticsInfo = new JMXRegistrar.StatisticsInfo(this.statistics);
        JMXRegistrar.registerMBean(statisticsInfo, StatisticsInfoMBean.class, objectName);
        return objectName;
    }

    @Override
    public boolean isDirtyChecksEnabled() {
        return this.enableDirtyChecks;
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    @Override
    public boolean isTransactionManagerExpected() {
        return this.transactionManagerExpected;
    }

    @Override
    public IndexManagerHolder getAllIndexesManager() {
        return this.getIndexManagerHolder();
    }

    @Override
    public IndexManagerHolder getIndexManagerHolder() {
        return this.allIndexesManager;
    }

    public EntityIndexBinding getSafeIndexBindingForEntity(Class<?> entityType) {
        if (entityType == null) {
            throw log.nullIsInvalidIndexedType();
        }
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(entityType);
        if (entityIndexBinding == null) {
            throw log.notAnIndexedType(entityType.getName());
        }
        return entityIndexBinding;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public IndexReaderAccessor getIndexReaderAccessor() {
        return this.indexReaderAccessor;
    }

    @Override
    public IndexedTypeDescriptor getIndexedTypeDescriptor(Class<?> entityType) {
        IndexedTypeDescriptor typeDescriptor;
        if (this.indexedTypeDescriptors.containsKey(entityType)) {
            typeDescriptor = this.indexedTypeDescriptors.get(entityType);
        } else {
            EntityIndexBinding indexBinder = this.indexBindingForEntities.get(entityType);
            IndexedTypeDescriptor indexedTypeDescriptor = indexBinder == null ? new IndexedTypeDescriptorForUnindexedType(entityType) : new IndexedTypeDescriptorImpl(indexBinder.getDocumentBuilder().getMetadata(), indexBinder.getIndexManagers());
            this.indexedTypeDescriptors.put(entityType, indexedTypeDescriptor);
            typeDescriptor = indexedTypeDescriptor;
        }
        return typeDescriptor;
    }

    @Override
    public Set<Class<?>> getIndexedTypes() {
        return this.indexBindingForEntities.keySet();
    }

    @Override
    public InstanceInitializer getInstanceInitializer() {
        return this.instanceInitializer;
    }

    @Override
    public TimeoutExceptionFactory getDefaultTimeoutExceptionFactory() {
        return this.timeoutExceptionFactory;
    }

    @Override
    public TimingSource getTimingSource() {
        return this.timingSource;
    }

    @Override
    public SearchMapping getProgrammaticMapping() {
        return this.mapping;
    }

    @Override
    public boolean isIndexMetadataComplete() {
        return this.indexMetadataIsComplete;
    }

    @Override
    public boolean isDeleteByTermEnforced() {
        return this.isDeleteByTermEnforced;
    }

    @Override
    public boolean isIdProvidedImplicit() {
        return this.isIdProvidedImplicit;
    }

    @Override
    public boolean isMultitenancyEnabled() {
        return this.isMultitenancyEnabled;
    }

    @Override
    public IndexManagerFactory getIndexManagerFactory() {
        return this.indexManagerFactory;
    }

    @Override
    public boolean enlistWorkerInTransaction() {
        return this.enlistWorkerInTransaction;
    }

    @Override
    public IndexManager getIndexManager(String indexName) {
        return this.getIndexManagerHolder().getIndexManager(indexName);
    }

    @Override
    public boolean isIndexUninvertingAllowed() {
        return this.indexUninvertingAllowed;
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (SearchIntegrator.class.isAssignableFrom(cls) || ExtendedSearchIntegrator.class.isAssignableFrom(cls) || SearchFactoryState.class.isAssignableFrom(cls)) {
            return (T)this;
        }
        throw new SearchException("Can not unwrap an ImmutableSearchFactory into a '" + cls + "'");
    }

    @Override
    public LuceneWorkSerializer getWorkSerializer() {
        if (this.workSerializer == null) {
            this.workSerializer = this.serviceManager.requestService(LuceneWorkSerializer.class);
        }
        return this.workSerializer;
    }

    @Override
    public HSQuery createLuceneBasedHSQuery() {
        return new LuceneHSQuery(this);
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

