/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.TimingSource;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.indexes.IndexReaderAccessor;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.impl.ExtendedSearchIntegratorWithShareableState;
import org.hibernate.search.spi.impl.PolymorphicIndexHierarchy;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.stat.spi.StatisticsImplementor;

public class MutableSearchFactory
implements ExtendedSearchIntegratorWithShareableState,
SearchIntegrator,
WorkerBuildContext {
    private volatile ExtendedSearchIntegratorWithShareableState delegate;
    private final Lock mutating = new ReentrantLock();

    public void setDelegate(ExtendedSearchIntegratorWithShareableState delegate) {
        this.delegate = delegate;
    }

    @Override
    public Map<String, FilterDef> getFilterDefinitions() {
        return this.delegate.getFilterDefinitions();
    }

    @Override
    public Map<Class<?>, EntityIndexBinding> getIndexBindings() {
        return this.delegate.getIndexBindings();
    }

    @Override
    public EntityIndexBinding getIndexBinding(Class<?> entityType) {
        return this.delegate.getIndexBinding(entityType);
    }

    @Override
    public DocumentBuilderContainedEntity getDocumentBuilderContainedEntity(Class<?> entityType) {
        return this.delegate.getDocumentBuilderContainedEntity(entityType);
    }

    @Override
    public Worker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.delegate.getFilterCachingStrategy();
    }

    @Override
    public Map<String, AnalyzerReference> getAnalyzerReferences() {
        return this.delegate.getAnalyzerReferences();
    }

    @Override
    public int getCacheBitResultsSize() {
        return this.delegate.getCacheBitResultsSize();
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.delegate.getConfigurationProperties();
    }

    @Override
    public FilterDef getFilterDefinition(String name) {
        return this.delegate.getFilterDefinition(name);
    }

    @Override
    public ExtendedSearchIntegrator getUninitializedSearchIntegrator() {
        return this;
    }

    @Override
    @Deprecated
    public String getIndexingStrategy() {
        return this.delegate.getIndexingMode().toExternalRepresentation();
    }

    @Override
    public IndexingMode getIndexingMode() {
        return this.delegate.getIndexingMode();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public HSQuery createHSQuery() {
        return this.delegate.createHSQuery();
    }

    @Override
    public HSQuery createHSQuery(Query luceneQuery, Class<?> ... entities) {
        return this.delegate.createHSQuery(luceneQuery, entities);
    }

    @Override
    public int getFilterCacheBitResultsSize() {
        return this.delegate.getFilterCacheBitResultsSize();
    }

    @Override
    public Set<Class<?>> getIndexedTypesPolymorphic(Class<?>[] classes) {
        return this.delegate.getIndexedTypesPolymorphic(classes);
    }

    @Override
    public BatchBackend makeBatchBackend(MassIndexerProgressMonitor progressMonitor) {
        return this.delegate.makeBatchBackend(progressMonitor);
    }

    @Override
    public boolean isJMXEnabled() {
        return this.delegate.isJMXEnabled();
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.delegate.getStatisticsImplementor();
    }

    @Override
    public PolymorphicIndexHierarchy getIndexHierarchy() {
        return this.delegate.getIndexHierarchy();
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.delegate.getServiceManager();
    }

    @Override
    public DatabaseRetrievalMethod getDefaultDatabaseRetrievalMethod() {
        return this.delegate.getDefaultDatabaseRetrievalMethod();
    }

    @Override
    public ObjectLookupMethod getDefaultObjectLookupMethod() {
        return this.delegate.getDefaultObjectLookupMethod();
    }

    @Override
    public void optimize() {
        this.delegate.optimize();
    }

    @Override
    public void optimize(Class entityType) {
        this.delegate.optimize(entityType);
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.delegate.getAnalyzer(name);
    }

    @Override
    public AnalyzerReference getAnalyzerReference(String name) {
        return this.delegate.getAnalyzerReference(name);
    }

    @Override
    public Analyzer getAnalyzer(Class<?> clazz) {
        return this.delegate.getAnalyzer(clazz);
    }

    @Override
    public AnalyzerReference getAnalyzerReference(Class<?> clazz) {
        return this.delegate.getAnalyzerReference(clazz);
    }

    @Override
    public QueryContextBuilder buildQueryBuilder() {
        return this.delegate.buildQueryBuilder();
    }

    @Override
    public Statistics getStatistics() {
        return this.delegate.getStatistics();
    }

    @Override
    public Map<Class<?>, DocumentBuilderContainedEntity> getDocumentBuildersContainedEntities() {
        return this.delegate.getDocumentBuildersContainedEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClasses(Class<?> ... classes) {
        SearchIntegratorBuilder builder = new SearchIntegratorBuilder().currentSearchIntegrator(this);
        for (Class<?> type : classes) {
            builder.addClass(type);
        }
        try {
            this.mutating.lock();
            builder.buildSearchIntegrator();
        }
        finally {
            this.mutating.unlock();
        }
    }

    @Override
    public boolean isDirtyChecksEnabled() {
        return this.delegate.isDirtyChecksEnabled();
    }

    @Override
    public boolean isStopped() {
        return this.delegate.isStopped();
    }

    @Override
    public boolean isTransactionManagerExpected() {
        return this.delegate.isTransactionManagerExpected();
    }

    @Override
    public IndexManagerHolder getAllIndexesManager() {
        return this.getIndexManagerHolder();
    }

    @Override
    public IndexManagerHolder getIndexManagerHolder() {
        return this.delegate.getIndexManagerHolder();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.delegate.getErrorHandler();
    }

    @Override
    public IndexReaderAccessor getIndexReaderAccessor() {
        return this.delegate.getIndexReaderAccessor();
    }

    @Override
    public IndexedTypeDescriptor getIndexedTypeDescriptor(Class<?> entityType) {
        return this.delegate.getIndexedTypeDescriptor(entityType);
    }

    @Override
    public Set<Class<?>> getIndexedTypes() {
        return this.delegate.getIndexedTypes();
    }

    @Override
    public InstanceInitializer getInstanceInitializer() {
        return this.delegate.getInstanceInitializer();
    }

    @Override
    public TimeoutExceptionFactory getDefaultTimeoutExceptionFactory() {
        return this.delegate.getDefaultTimeoutExceptionFactory();
    }

    @Override
    public TimingSource getTimingSource() {
        return this.delegate.getTimingSource();
    }

    @Override
    public SearchMapping getProgrammaticMapping() {
        return this.delegate.getProgrammaticMapping();
    }

    @Override
    public boolean isIndexMetadataComplete() {
        return this.delegate.isIndexMetadataComplete();
    }

    @Override
    public boolean isDeleteByTermEnforced() {
        return this.delegate.isDeleteByTermEnforced();
    }

    @Override
    public boolean isIdProvidedImplicit() {
        return this.delegate.isIdProvidedImplicit();
    }

    @Override
    public boolean isMultitenancyEnabled() {
        return this.delegate.isMultitenancyEnabled();
    }

    @Override
    public IndexManagerFactory getIndexManagerFactory() {
        return this.delegate.getIndexManagerFactory();
    }

    @Override
    public boolean enlistWorkerInTransaction() {
        return this.delegate.enlistWorkerInTransaction();
    }

    @Override
    public IndexManager getIndexManager(String indexName) {
        return this.delegate.getIndexManager(indexName);
    }

    @Override
    public boolean isIndexUninvertingAllowed() {
        return this.delegate.isIndexUninvertingAllowed();
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (SearchIntegrator.class.equals(cls) || ExtendedSearchIntegrator.class.equals(cls) || MutableSearchFactory.class.equals(cls)) {
            return (T)this;
        }
        return this.delegate.unwrap(cls);
    }

    @Override
    public LuceneWorkSerializer getWorkSerializer() {
        return this.delegate.getWorkSerializer();
    }

    @Override
    public HSQuery createLuceneBasedHSQuery() {
        return this.delegate.createLuceneBasedHSQuery();
    }
}

