/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.elasticsearch.analyzer.impl.BuiltinElasticsearchAnalyzerImpl;
import org.hibernate.search.elasticsearch.analyzer.impl.CustomElasticsearchAnalyzerImpl;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ScopedElasticsearchAnalyzer;
import org.hibernate.search.elasticsearch.analyzer.impl.UndefinedElasticsearchAnalyzerImpl;

public class ElasticsearchAnalyzerStrategy
implements AnalyzerStrategy<ElasticsearchAnalyzerReference> {
    public ElasticsearchAnalyzerReference createDefaultAnalyzerReference() {
        return new ElasticsearchAnalyzerReference(new UndefinedElasticsearchAnalyzerImpl("default"));
    }

    public ElasticsearchAnalyzerReference createPassThroughAnalyzerReference() {
        return new ElasticsearchAnalyzerReference(new UndefinedElasticsearchAnalyzerImpl("keyword"));
    }

    public ElasticsearchAnalyzerReference createNamedAnalyzerReference(String name) {
        return new ElasticsearchAnalyzerReference(name);
    }

    public ElasticsearchAnalyzerReference createAnalyzerReference(Class<?> analyzerClass) {
        return new ElasticsearchAnalyzerReference(new BuiltinElasticsearchAnalyzerImpl(analyzerClass));
    }

    public void initializeNamedAnalyzerReferences(Map<String, ElasticsearchAnalyzerReference> references, Map<String, AnalyzerDef> analyzerDefinitions) {
        HashMap<String, ElasticsearchAnalyzer> initializedAnalyzers = new HashMap<String, ElasticsearchAnalyzer>();
        for (Map.Entry<String, ElasticsearchAnalyzerReference> entry : references.entrySet()) {
            this.initializeReference(initializedAnalyzers, entry.getKey(), entry.getValue(), analyzerDefinitions);
        }
    }

    private void initializeReference(Map<String, ElasticsearchAnalyzer> initializedAnalyzers, String name, ElasticsearchAnalyzerReference analyzerReference, Map<String, AnalyzerDef> analyzerDefinitions) {
        if (analyzerReference.isInitialized()) {
            initializedAnalyzers.put(analyzerReference.getAnalyzerName(), analyzerReference.getAnalyzer());
            return;
        }
        ElasticsearchAnalyzer analyzer = initializedAnalyzers.get(name);
        if (analyzer == null) {
            AnalyzerDef analyzerDefinition = analyzerDefinitions.get(name);
            analyzer = analyzerDefinition == null ? new UndefinedElasticsearchAnalyzerImpl(name) : new CustomElasticsearchAnalyzerImpl(analyzerDefinition);
            initializedAnalyzers.put(name, analyzer);
        }
        analyzerReference.initialize(analyzer);
    }

    public ScopedElasticsearchAnalyzer.Builder buildScopedAnalyzer(ElasticsearchAnalyzerReference initialGlobalAnalyzerReference) {
        return new ScopedElasticsearchAnalyzer.Builder(initialGlobalAnalyzerReference, Collections.emptyMap());
    }
}

