/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.analyzer.spi.ScopedAnalyzer;
import org.hibernate.search.annotations.AnalyzerDef;

public class AnalyzerReferenceRegistry<T extends AnalyzerReference> {
    private final AnalyzerStrategy<T> strategy;
    private final T defaultReference;
    private final T passThroughReference;
    private final Map<String, T> referencesByName = new LinkedHashMap<String, T>();
    private final Map<Class<?>, T> referencesByClass = new LinkedHashMap();

    AnalyzerReferenceRegistry(AnalyzerStrategy<T> strategy) {
        this.strategy = strategy;
        this.defaultReference = strategy.createDefaultAnalyzerReference();
        String analyzerName = this.defaultReference.getAnalyzerName();
        if (analyzerName != null) {
            this.referencesByName.put(analyzerName, this.defaultReference);
        }
        this.passThroughReference = strategy.createPassThroughAnalyzerReference();
        analyzerName = this.passThroughReference.getAnalyzerName();
        if (analyzerName != null) {
            this.referencesByName.put(analyzerName, this.passThroughReference);
        }
    }

    public T getDefaultAnalyzerReference() {
        return this.defaultReference;
    }

    public T getPassThroughAnalyzerReference() {
        return this.passThroughReference;
    }

    public Map<String, T> getAnalyzerReferencesByName() {
        return Collections.unmodifiableMap(this.referencesByName);
    }

    public Map<Class<?>, T> getAnalyzerReferencesByClass() {
        return Collections.unmodifiableMap(this.referencesByClass);
    }

    public T getAnalyzerReference(String name) {
        AnalyzerReference reference = (AnalyzerReference)this.referencesByName.get(name);
        if (reference == null) {
            reference = this.strategy.createNamedAnalyzerReference(name);
            this.referencesByName.put(name, reference);
        }
        return (T)reference;
    }

    public T getAnalyzerReference(Class<?> analyzerClazz) {
        AnalyzerReference reference = (AnalyzerReference)this.referencesByClass.get(analyzerClazz);
        if (reference == null) {
            reference = this.strategy.createAnalyzerReference(analyzerClazz);
            this.referencesByClass.put(analyzerClazz, reference);
        }
        return (T)reference;
    }

    public void initialize(Map<String, AnalyzerDef> analyzerDefinitions) {
        this.strategy.initializeNamedAnalyzerReferences(this.referencesByName, analyzerDefinitions);
    }

    public ScopedAnalyzer.Builder buildScopedAnalyzer() {
        return this.strategy.buildScopedAnalyzer(this.getDefaultAnalyzerReference());
    }
}

