/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;

public class QueryBuildingContext {
    private final ExtendedSearchIntegrator factory;
    private final DocumentBuilderIndexedEntity documentBuilder;
    private final ScopedAnalyzerReference queryAnalyzerReference;
    private final Class<?> entityType;

    public QueryBuildingContext(ExtendedSearchIntegrator factory, ScopedAnalyzerReference queryAnalyzerReference, Class<?> entityType) {
        this.factory = factory;
        this.queryAnalyzerReference = queryAnalyzerReference;
        this.entityType = entityType;
        EntityIndexBinding indexBinding = factory.getIndexBinding(entityType);
        if (indexBinding == null) {
            throw new AssertionFailure("Class is not indexed: " + entityType);
        }
        this.documentBuilder = indexBinding.getDocumentBuilder();
    }

    public ExtendedSearchIntegrator getFactory() {
        return this.factory;
    }

    public DocumentBuilderIndexedEntity getDocumentBuilder() {
        return this.documentBuilder;
    }

    public ScopedAnalyzerReference getQueryAnalyzerReference() {
        return this.queryAnalyzerReference;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }
}

