/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.elasticsearch.query.impl.FieldProjection;
import org.hibernate.search.elasticsearch.query.impl.PrimitiveProjection;

class TwoWayFieldBridgeProjection
extends FieldProjection {
    private final String absoluteName;
    private final TwoWayFieldBridge bridge;
    private final Set<String> objectFieldNames;
    private final Map<String, PrimitiveProjection> primitiveProjections;

    public TwoWayFieldBridgeProjection(String absoluteName, TwoWayFieldBridge bridge, Set<String> objectFieldNames, Map<String, PrimitiveProjection> primitiveProjections) {
        this.absoluteName = absoluteName;
        this.bridge = bridge;
        this.objectFieldNames = objectFieldNames;
        this.primitiveProjections = primitiveProjections;
    }

    @Override
    public Object convertHit(JsonObject hit, ConversionContext conversionContext) {
        return this.convertFieldValue(hit, conversionContext);
    }

    private Object convertFieldValue(JsonObject hit, ConversionContext conversionContext) {
        Document tmp = new Document();
        for (String objectFieldName : this.objectFieldNames) {
            JsonElement jsonValue = this.extractFieldValue(hit.get("_source").getAsJsonObject(), objectFieldName);
            if (jsonValue == null || jsonValue.isJsonNull()) continue;
            JsonObject jsonObject = jsonValue.getAsJsonObject();
            this.addDocumentFieldsRecursively(tmp, (JsonElement)jsonObject, objectFieldName);
        }
        for (PrimitiveProjection subProjection : this.primitiveProjections.values()) {
            subProjection.addDocumentField(tmp, hit, conversionContext);
        }
        return conversionContext.twoWayConversionContext(this.bridge).get(this.absoluteName, tmp);
    }

    public void addDocumentFieldsRecursively(Document tmp, JsonElement value, String fieldName) {
        if (value == null || value.isJsonNull()) {
            return;
        }
        PrimitiveProjection configuredProjection = this.primitiveProjections.get(fieldName);
        if (configuredProjection != null) {
            return;
        }
        if (value.isJsonObject()) {
            JsonObject jsonObject = value.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                String nestedFieldName = fieldName + "." + (String)entry.getKey();
                JsonElement nestedFieldValue = (JsonElement)entry.getValue();
                this.addDocumentFieldsRecursively(tmp, nestedFieldValue, nestedFieldName);
            }
        } else if (value.isJsonArray()) {
            JsonArray jsonArray = value.getAsJsonArray();
            for (JsonElement nestedValue : jsonArray) {
                this.addDocumentFieldsRecursively(tmp, nestedValue, fieldName);
            }
        } else {
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                tmp.add((IndexableField)new StringField(fieldName, String.valueOf(primitive.getAsBoolean()), Field.Store.NO));
            } else if (primitive.isNumber()) {
                tmp.add((IndexableField)new DoubleField(fieldName, primitive.getAsDouble(), Field.Store.NO));
            } else if (primitive.isString()) {
                tmp.add((IndexableField)new StringField(fieldName, primitive.getAsString(), Field.Store.NO));
            } else {
                tmp.add((IndexableField)new StringField(fieldName, primitive.getAsString(), Field.Store.NO));
            }
        }
    }
}

