/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.cfg.impl.SearchConfigurationFromHibernateCore;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.HibernateStatelessInitializer;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.spi.ClassNavigator;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.analyzer.Article;
import org.hibernate.search.test.analyzer.BlogEntry;
import org.hibernate.search.test.analyzer.MyComponent;
import org.hibernate.search.test.analyzer.MyEntity;
import org.hibernate.search.test.util.AnalyzerUtils;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AnalyzerTest
extends SearchTestCase {
    public static final Log log = LoggerFactory.make();

    public void testAnalyzerDiscriminator() throws Exception {
        Article germanArticle = new Article();
        germanArticle.setLanguage("de");
        germanArticle.setText("aufeinanderschl\u00fcgen");
        HashSet<Article> references = new HashSet<Article>();
        references.add(germanArticle);
        Article englishArticle = new Article();
        englishArticle.setLanguage("en");
        englishArticle.setText("acknowledgment");
        englishArticle.setReferences(references);
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)englishArticle);
        tx.commit();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(AnalyzerTest.getTargetLuceneVersion(), "references.text", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("aufeinanderschlug");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        AnalyzerTest.assertEquals((int)1, (int)query.getResultSize());
        parser = new QueryParser(AnalyzerTest.getTargetLuceneVersion(), "text", SearchTestCase.standardAnalyzer);
        luceneQuery = parser.parse("acknowledg");
        query = s.createFullTextQuery(luceneQuery, new Class[0]);
        AnalyzerTest.assertEquals((int)1, (int)query.getResultSize());
        tx.commit();
        s.close();
    }

    public void testMultipleAnalyzerDiscriminatorDefinitions() {
        SearchConfigurationFromHibernateCore searchConfig = new SearchConfigurationFromHibernateCore(cfg);
        ReflectionManager reflectionManager = searchConfig.getReflectionManager();
        XClass xclass = reflectionManager.toXClass(BlogEntry.class);
        HashSet optimizationBlackList = new HashSet();
        ConfigContext context = new ConfigContext((SearchConfiguration)searchConfig);
        try {
            new DocumentBuilderContainedEntity(xclass, context, reflectionManager, optimizationBlackList, (ClassNavigator)HibernateStatelessInitializer.INSTANCE);
            AnalyzerTest.fail();
        }
        catch (SearchException e) {
            AnalyzerTest.assertTrue((String)"Wrong error message", (boolean)e.getMessage().startsWith("Multiple AnalyzerDiscriminator defined in the same class hierarchy"));
        }
    }

    public void testScopedAnalyzers() throws Exception {
        MyEntity en = new MyEntity();
        en.setEntity("Entity");
        en.setField("Field");
        en.setProperty("Property");
        en.setComponent(new MyComponent());
        en.getComponent().setComponentProperty("component property");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)en);
        tx.commit();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(AnalyzerTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("entity:alarm");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[]{MyEntity.class});
        AnalyzerTest.assertEquals((int)1, (int)query.getResultSize());
        luceneQuery = parser.parse("property:cat");
        query = s.createFullTextQuery(luceneQuery, new Class[]{MyEntity.class});
        AnalyzerTest.assertEquals((int)1, (int)query.getResultSize());
        luceneQuery = parser.parse("field:energy");
        query = s.createFullTextQuery(luceneQuery, new Class[]{MyEntity.class});
        AnalyzerTest.assertEquals((int)1, (int)query.getResultSize());
        luceneQuery = parser.parse("component.componentProperty:noise");
        query = s.createFullTextQuery(luceneQuery, new Class[]{MyEntity.class});
        AnalyzerTest.assertEquals((int)1, (int)query.getResultSize());
        s.delete(query.uniqueResult());
        tx.commit();
        s.close();
    }

    public void testScopedAnalyzersFromSearchFactory() throws Exception {
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        SearchFactory searchFactory = session.getSearchFactory();
        Analyzer analyzer = searchFactory.getAnalyzer(MyEntity.class);
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"entity", (String)"");
        AnalyzerUtils.assertTokensEqual((Token[])tokens, (String[])new String[]{"alarm", "dog", "performance"});
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"property", (String)"");
        AnalyzerUtils.assertTokensEqual((Token[])tokens, (String[])new String[]{"sound", "cat", "speed"});
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"field", (String)"");
        AnalyzerUtils.assertTokensEqual((Token[])tokens, (String[])new String[]{"music", "elephant", "energy"});
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"component.componentProperty", (String)"");
        AnalyzerUtils.assertTokensEqual((Token[])tokens, (String[])new String[]{"noise", "mouse", "light"});
        try {
            searchFactory.getAnalyzer((Class)null);
        }
        catch (IllegalArgumentException iae) {
            log.debug((Object)"success");
        }
        try {
            searchFactory.getAnalyzer(String.class);
        }
        catch (IllegalArgumentException iae) {
            log.debug((Object)"success");
        }
        session.close();
    }

    public void testNotAnalyzedFieldAndScopedAnalyzer() throws Exception {
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        SearchFactory searchFactory = session.getSearchFactory();
        Analyzer analyzer = searchFactory.getAnalyzer(MyEntity.class);
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"notAnalyzed", (String)"pass through");
        AnalyzerUtils.assertTokensEqual((Token[])tokens, (String[])new String[]{"pass through"});
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{MyEntity.class, Article.class};
    }
}

