/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.inheritance;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.analyzer.inheritance.SubClass;
import org.hibernate.search.test.util.AnalyzerUtils;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AnalyzerInheritanceTest
extends SearchTestCase {
    public static final Log log = LoggerFactory.make();

    public void testBySearch() throws Exception {
        SubClass testClass = new SubClass();
        testClass.setName("Proca\u00efne");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)testClass);
        tx.commit();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(AnalyzerInheritanceTest.getTargetLuceneVersion(), "name", s.getSearchFactory().getAnalyzer(SubClass.class));
        Query luceneQuery = parser.parse("name:Proca\u00efne");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[]{SubClass.class});
        AnalyzerInheritanceTest.assertEquals((int)1, (int)query.getResultSize());
        luceneQuery = parser.parse("name:Procaine");
        query = s.createFullTextQuery(luceneQuery, new Class[]{SubClass.class});
        AnalyzerInheritanceTest.assertEquals((int)1, (int)query.getResultSize());
        luceneQuery = parser.parse("name:foo");
        query = s.createFullTextQuery(luceneQuery, new Class[]{SubClass.class});
        AnalyzerInheritanceTest.assertEquals((int)0, (int)query.getResultSize());
        tx.commit();
        s.close();
    }

    public void testByAnalyzerRetrieval() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Analyzer analyzer = s.getSearchFactory().getAnalyzer(SubClass.class);
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)"Proca\u00efne");
        AnalyzerUtils.assertTokensEqual((Token[])tokens, (String[])new String[]{"Procaine"});
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{SubClass.class};
    }
}

