/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import junit.framework.Assert;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.batchindexing.Book;
import org.hibernate.search.test.batchindexing.Nation;
import org.hibernate.search.test.errorhandling.MockErrorHandler;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class MassIndexerErrorReportingTest
extends SearchTestCase {
    @Test
    @BMRule(targetClass="org.hibernate.search.batchindexing.impl.IdentifierConsumerEntityProducer", targetMethod="loadList", helper="org.hibernate.search.test.util.BytemanHelper", action="throwNPE(\"Byteman created NPE\")", name="testMassIndexerErrorsReported")
    public void testMassIndexerErrorsReported() throws InterruptedException {
        SearchFactoryImplementor searchFactory = this.getSearchFactoryImpl();
        ErrorHandler errorHandler = searchFactory.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        MockErrorHandler mockErrorHandler = (MockErrorHandler)errorHandler;
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        fullTextSession.beginTransaction();
        Nation france = new Nation("France", "FR");
        fullTextSession.save((Object)france);
        Book ceylonBook = new Book();
        ceylonBook.setTitle("Ceylon in Action");
        ceylonBook.setFirstPublishedIn(france);
        fullTextSession.save((Object)ceylonBook);
        fullTextSession.getTransaction().commit();
        fullTextSession.createIndexer(new Class[]{Book.class}).startAndWait();
        this.session.close();
        String errorMessage = mockErrorHandler.getErrorMessage();
        Assert.assertEquals((String)"Unexpected error during MassIndexer operation", (String)errorMessage);
        Throwable exception = mockErrorHandler.getLastException();
        Assert.assertTrue((boolean)(exception instanceof ExecuteException));
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Nation.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }
}

