/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.configuration.Address;
import org.hibernate.search.test.configuration.BlogEntry;
import org.hibernate.search.test.configuration.Country;
import org.hibernate.search.test.configuration.Departments;
import org.hibernate.search.test.configuration.DynamicBoostedDescLibrary;
import org.hibernate.search.test.configuration.Item;
import org.hibernate.search.test.configuration.ProductCatalog;
import org.hibernate.search.test.configuration.ProgrammaticSearchMappingFactory;
import org.hibernate.search.test.configuration.ProvidedIdEntry;
import org.hibernate.search.test.util.ManualTransactionContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ProgrammaticMappingTest
extends SearchTestCase {
    private static final Log log = LoggerFactory.make();

    public void testMapping() throws Exception {
        Address address = new Address();
        address.setStreet1("3340 Peachtree Rd NE");
        address.setStreet2("JBoss");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("" + address.getAddressId());
        System.out.println(luceneQuery.toString());
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        ProgrammaticMappingTest.assertEquals((String)"documentId does not work properly", (int)1, (int)query.getResultSize());
        luceneQuery = parser.parse("street1:peachtree");
        query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"idx_street2", "__HSearch_This"});
        ProgrammaticMappingTest.assertEquals((String)"Not properly indexed", (int)1, (int)query.getResultSize());
        Object[] firstResult = (Object[])query.list().get(0);
        ProgrammaticMappingTest.assertEquals((String)"@Field.store not respected", (Object)"JBoss", (Object)firstResult[0]);
        luceneQuery = parser.parse("AddressClassBridge:Applied\\!");
        ProgrammaticMappingTest.assertEquals((int)1, (int)s.createFullTextQuery(luceneQuery, new Class[0]).getResultSize());
        s.delete(firstResult[1]);
        tx.commit();
        s.close();
    }

    public void testNumeric() throws Exception {
        Item item = new Item();
        item.setPrice(34.54);
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)item);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        NumericRangeQuery q = NumericRangeQuery.newDoubleRange((String)"price", (Double)34.5, (Double)34.6, (boolean)true, (boolean)true);
        FullTextQuery query = s.createFullTextQuery((Query)q, new Class[]{Item.class});
        ProgrammaticMappingTest.assertEquals((String)"Numeric field via programmatic config", (int)1, (int)query.getResultSize());
        s.delete(query.list().get(0));
        tx.commit();
        s.close();
    }

    public void testAnalyzerDef() throws Exception {
        Address address = new Address();
        address.setStreet1("3340 Peachtree Rd NE");
        address.setStreet2("JBoss");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("street1_ngram:pea");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        ProgrammaticMappingTest.assertEquals((String)"Analyzer inoperant", (int)1, (int)query.getResultSize());
        s.delete(query.list().get(0));
        tx.commit();
        s.close();
    }

    public void testBridgeMapping() throws Exception {
        Address address = new Address();
        address.setStreet1("Peachtree Rd NE");
        address.setStreet2("JBoss");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("street1:peac");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        ProgrammaticMappingTest.assertEquals((String)"PrefixQuery should not be on", (int)0, (int)query.getResultSize());
        luceneQuery = parser.parse("street1_abridged:peac");
        query = s.createFullTextQuery(luceneQuery, new Class[0]);
        ProgrammaticMappingTest.assertEquals((String)"Bridge not used", (int)1, (int)query.getResultSize());
        s.delete(query.list().get(0));
        tx.commit();
        s.close();
    }

    public void testBoost() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Address address = new Address();
        address.setStreet1("Peachtree Rd NE");
        address.setStreet2("Peachtnot Rd NE");
        s.persist((Object)address);
        address = new Address();
        address.setStreet1("Peachtnot Rd NE");
        address.setStreet2("Peachtree Rd NE");
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("street1:peachtree OR idx_street2:peachtree");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        ProgrammaticMappingTest.assertEquals((String)"expecting two results", (int)2, (int)query.getResultSize());
        List results = query.list();
        ProgrammaticMappingTest.assertTrue((String)"first result should be strictly higher", (((Float)((Object[])results.get(0))[1]).floatValue() > ((Float)((Object[])results.get(1))[1]).floatValue() * 1.9f ? 1 : 0) != 0);
        ProgrammaticMappingTest.assertEquals((String)"Wrong result ordered", (String)address.getStreet1(), (String)((Address)((Object[])results.get(0))[0]).getStreet1());
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    public void testAnalyzerDiscriminator() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        BlogEntry deEntry = new BlogEntry();
        deEntry.setTitle("aufeinanderschl\u00fcgen");
        deEntry.setDescription("aufeinanderschl\u00fcgen");
        deEntry.setLanguage("de");
        s.persist((Object)deEntry);
        BlogEntry enEntry = new BlogEntry();
        enEntry.setTitle("acknowledgment");
        enEntry.setDescription("acknowledgment");
        enEntry.setLanguage("en");
        s.persist((Object)enEntry);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        ProgrammaticMappingTest.assertEquals((int)1, (int)this.nbrOfMatchingResults("description", "aufeinanderschlug", s));
        ProgrammaticMappingTest.assertEquals((int)1, (int)this.nbrOfMatchingResults("description", "acknowledg", s));
        ProgrammaticMappingTest.assertEquals((int)0, (int)this.nbrOfMatchingResults("title", "aufeinanderschlug", s));
        ProgrammaticMappingTest.assertEquals((int)1, (int)this.nbrOfMatchingResults("title", "acknowledgment", s));
        for (Object result : s.createQuery("from " + BlogEntry.class.getName()).list()) {
            s.delete(result);
        }
        tx.commit();
        s.close();
    }

    public void testDateBridgeMapping() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Address address = new Address();
        address.setStreet1("Peachtree Rd NE");
        address.setStreet2("Peachtnot Rd NE");
        Calendar c = GregorianCalendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.set(2009, 10, 15);
        Date date = new Date(c.getTimeInMillis());
        address.setDateCreated(date);
        s.persist((Object)address);
        address = new Address();
        address.setStreet1("Peachtnot Rd NE");
        address.setStreet2("Peachtree Rd NE");
        address.setDateCreated(date);
        s.persist((Object)address);
        BlogEntry enEntry = new BlogEntry();
        enEntry.setTitle("acknowledgment");
        enEntry.setDescription("acknowledgment");
        enEntry.setLanguage("en");
        enEntry.setDateCreated(date);
        s.persist((Object)enEntry);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("date-created:20091115 OR blog-entry-created:20091115");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        ProgrammaticMappingTest.assertEquals((String)"expecting 3 results", (int)3, (int)query.getResultSize());
        List results = query.list();
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    public void testCalendarBridgeMapping() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Address address = new Address();
        address.setStreet1("Peachtree Rd NE");
        address.setStreet2("Peachtnot Rd NE");
        Calendar c = GregorianCalendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.set(2009, 10, 15);
        address.setLastUpdated(c);
        s.persist((Object)address);
        address = new Address();
        address.setStreet1("Peachtnot Rd NE");
        address.setStreet2("Peachtree Rd NE");
        address.setLastUpdated(c);
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("last-updated:20091115");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        ProgrammaticMappingTest.assertEquals((String)"expecting 2 results", (int)2, (int)query.getResultSize());
        List results = query.list();
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    public void testProvidedIdMapping() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        SearchFactoryImplementor sf = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
        ProvidedIdEntry person1 = new ProvidedIdEntry();
        person1.setName("Big Goat");
        person1.setBlurb("Eats grass");
        ProvidedIdEntry person2 = new ProvidedIdEntry();
        person2.setName("Mini Goat");
        person2.setBlurb("Eats cheese");
        ProvidedIdEntry person3 = new ProvidedIdEntry();
        person3.setName("Regular goat");
        person3.setBlurb("Is anorexic");
        ManualTransactionContext tc = new ManualTransactionContext();
        Work work = new Work((Object)person1, (Serializable)Integer.valueOf(1), WorkType.INDEX);
        sf.getWorker().performWork(work, (TransactionContext)tc);
        work = new Work((Object)person2, (Serializable)Integer.valueOf(2), WorkType.INDEX);
        sf.getWorker().performWork(work, (TransactionContext)tc);
        Work work2 = new Work((Object)person3, (Serializable)Integer.valueOf(3), WorkType.INDEX);
        sf.getWorker().performWork(work2, (TransactionContext)tc);
        tc.end();
        Transaction transaction = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "providedidentry.name", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("Goat");
        IndexReader indexReader = fullTextSession.getSearchFactory().getIndexReaderAccessor().open(new Class[]{ProvidedIdEntry.class});
        IndexSearcher searcher = new IndexSearcher(indexReader);
        TopDocs hits = searcher.search(luceneQuery, 1000);
        searcher.close();
        fullTextSession.getSearchFactory().getIndexReaderAccessor().close(indexReader);
        transaction.commit();
        this.session.close();
        ProgrammaticMappingTest.assertEquals((int)3, (int)hits.totalHits);
    }

    public void testFullTextFilterDefAtMappingLevel() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Address address = new Address();
        address.setStreet1("Peachtree Rd NE");
        address.setStreet2("Peachtnot Rd NE");
        address.setOwner("test");
        Calendar c = GregorianCalendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.set(2009, 10, 15);
        address.setLastUpdated(c);
        s.persist((Object)address);
        address = new Address();
        address.setStreet1("Peachtnot Rd NE");
        address.setStreet2("Peachtree Rd NE");
        address.setLastUpdated(c);
        address.setOwner("test2");
        s.persist((Object)address);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("street1:Peachtnot");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        query.enableFullTextFilter("security").setParameter("ownerName", (Object)"test");
        ProgrammaticMappingTest.assertEquals((String)"expecting 1 results", (int)1, (int)query.getResultSize());
        List results = query.list();
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    public void testIndexEmbedded() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        ProductCatalog productCatalog = new ProductCatalog();
        productCatalog.setName("Cars");
        Item item = new Item();
        item.setDescription("Ferrari");
        item.setProductCatalog(productCatalog);
        productCatalog.addItem(item);
        s.persist((Object)item);
        s.persist((Object)productCatalog);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("items.description:Ferrari");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        ProgrammaticMappingTest.assertEquals((String)"expecting 1 results", (int)1, (int)query.getResultSize());
        List results = query.list();
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    public void testContainedIn() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        ProductCatalog productCatalog = new ProductCatalog();
        productCatalog.setName("Cars");
        Item item = new Item();
        item.setDescription("test");
        item.setProductCatalog(productCatalog);
        productCatalog.addItem(item);
        s.persist((Object)item);
        s.persist((Object)productCatalog);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("items.description:test");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        ProgrammaticMappingTest.assertEquals((String)"expecting 1 results", (int)1, (int)query.getResultSize());
        tx.commit();
        tx = s.beginTransaction();
        Item loaded = (Item)s.get(Item.class, (Serializable)item.getId());
        loaded.setDescription("Ferrari");
        s.update((Object)loaded);
        tx.commit();
        tx = s.beginTransaction();
        parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        luceneQuery = parser.parse("items.description:test");
        query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        ProgrammaticMappingTest.assertEquals((String)"expecting 0 results", (int)0, (int)query.getResultSize());
        parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        luceneQuery = parser.parse("items.description:Ferrari");
        query = s.createFullTextQuery(luceneQuery, new Class[0]).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        ProgrammaticMappingTest.assertEquals((String)"expecting 1 results", (int)1, (int)query.getResultSize());
        tx.commit();
        tx = s.beginTransaction();
        List results = query.list();
        for (Object[] result : results) {
            s.delete(result[0]);
        }
        tx.commit();
        s.close();
    }

    public void testClassBridgeMapping() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)this.getDepts1());
        s.persist((Object)this.getDepts2());
        s.persist((Object)this.getDepts3());
        s.persist((Object)this.getDepts4());
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "equipment", (Analyzer)new SimpleAnalyzer(ProgrammaticMappingTest.getTargetLuceneVersion()));
        Query query = parser.parse("equiptype:Cisco");
        FullTextQuery hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        List result = hibQuery.list();
        ProgrammaticMappingTest.assertNotNull((Object)result);
        ProgrammaticMappingTest.assertEquals((String)"incorrect number of results returned", (int)2, (int)result.size());
        for (Departments d : result) {
            ProgrammaticMappingTest.assertEquals((String)"incorrect manufacturer", (String)"C", (String)d.getManufacturer());
        }
        query = parser.parse("branchnetwork:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        ProgrammaticMappingTest.assertNotNull((Object)result);
        ProgrammaticMappingTest.assertTrue((String)"problem with field cross-ups", (result.size() == 0 ? 1 : 0) != 0);
        parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "branchHead", (Analyzer)new SimpleAnalyzer(ProgrammaticMappingTest.getTargetLuceneVersion()));
        query = parser.parse("branchHead:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        ProgrammaticMappingTest.assertNotNull((Object)result);
        ProgrammaticMappingTest.assertTrue((String)"incorrect entity returned, wrong branch head", (result.size() == 1 ? 1 : 0) != 0);
        ProgrammaticMappingTest.assertEquals((String)"incorrect entity returned", (String)"Kent Lewin", (String)((Departments)result.get(0)).getBranchHead());
        parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), "branchnetwork", (Analyzer)new SimpleAnalyzer(ProgrammaticMappingTest.getTargetLuceneVersion()));
        query = parser.parse("branchnetwork:st. george 1D");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        ProgrammaticMappingTest.assertNotNull((Object)result);
        ProgrammaticMappingTest.assertEquals((String)"incorrect entity returned, wrong network", (String)"1D", (String)((Departments)result.get(0)).getNetwork());
        ProgrammaticMappingTest.assertEquals((String)"incorrect entity returned, wrong branch", (String)"St. George", (String)((Departments)result.get(0)).getBranch());
        ProgrammaticMappingTest.assertEquals((String)"incorrect number of results returned", (int)1, (int)result.size());
        for (Object element : s.createQuery("from " + Departments.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testDynamicBoosts() throws Exception {
        Session session = this.openSession();
        session.beginTransaction();
        DynamicBoostedDescLibrary lib1 = new DynamicBoostedDescLibrary();
        lib1.setName("one");
        session.persist((Object)lib1);
        DynamicBoostedDescLibrary lib2 = new DynamicBoostedDescLibrary();
        lib2.setName("two");
        session.persist((Object)lib2);
        session.getTransaction().commit();
        session.close();
        float lib1Score = this.getScore((Query)new TermQuery(new Term("name", "one")));
        float lib2Score = this.getScore((Query)new TermQuery(new Term("name", "two")));
        ProgrammaticMappingTest.assertEquals((String)"The scores should be equal", (Object)Float.valueOf(lib1Score), (Object)Float.valueOf(lib2Score));
        session = this.openSession();
        session.beginTransaction();
        session.refresh((Object)lib2);
        lib2.setDynScore(2.0f);
        session.getTransaction().commit();
        session.close();
        lib1Score = this.getScore((Query)new TermQuery(new Term("name", "one")));
        lib2Score = this.getScore((Query)new TermQuery(new Term("name", "two")));
        ProgrammaticMappingTest.assertTrue((String)"lib2score should be greater than lib1score", (lib1Score < lib2Score ? 1 : 0) != 0);
        lib1Score = this.getScore((Query)new TermQuery(new Term("name", "foobar")));
        ProgrammaticMappingTest.assertEquals((String)"lib1score should be 0 since term is not yet indexed.", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(lib1Score));
        session = this.openSession();
        session.beginTransaction();
        session.refresh((Object)lib1);
        lib1.setName("foobar");
        session.getTransaction().commit();
        session.close();
        lib1Score = this.getScore((Query)new TermQuery(new Term("name", "foobar")));
        lib2Score = this.getScore((Query)new TermQuery(new Term("name", "two")));
        ProgrammaticMappingTest.assertTrue((String)"lib1score should be greater than lib2score", (lib1Score > lib2Score ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getScore(Query query) {
        float score;
        Session session = this.openSession();
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            List resultList = fullTextSession.createFullTextQuery(query, new Class[]{DynamicBoostedDescLibrary.class}).setProjection(new String[]{"__HSearch_Score", "__HSearch_Explanation"}).setMaxResults(1).list();
            if (resultList.size() == 0) {
                score = 0.0f;
            } else {
                Object[] queryResult = (Object[])resultList.get(0);
                score = ((Float)queryResult[0]).floatValue();
                String explanation = queryResult[1].toString();
                log.debugf("score: %f explanation: %s", (Object)Float.valueOf(score), (Object)explanation);
            }
        }
        finally {
            session.close();
        }
        return score;
    }

    private int nbrOfMatchingResults(String field, String token, FullTextSession s) throws ParseException {
        QueryParser parser = new QueryParser(ProgrammaticMappingTest.getTargetLuceneVersion(), field, SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse(token);
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        return query.getResultSize();
    }

    private Departments getDepts1() {
        Departments depts = new Departments();
        depts.setBranch("Salt Lake City");
        depts.setBranchHead("Kent Lewin");
        depts.setMaxEmployees(100);
        depts.setNetwork("1A");
        depts.setManufacturer("C");
        return depts;
    }

    private Departments getDepts2() {
        Departments depts = new Departments();
        depts.setBranch("Layton");
        depts.setBranchHead("Terry Poperszky");
        depts.setMaxEmployees(20);
        depts.setNetwork("2B");
        depts.setManufacturer("3");
        return depts;
    }

    private Departments getDepts3() {
        Departments depts = new Departments();
        depts.setBranch("West Valley");
        depts.setBranchHead("Pat Kelley");
        depts.setMaxEmployees(15);
        depts.setNetwork("3C");
        depts.setManufacturer("D");
        return depts;
    }

    private Departments getDepts4() {
        Departments depts = new Departments();
        depts.setBranch("St. George");
        depts.setBranchHead("Spencer Stajskal");
        depts.setMaxEmployees(10);
        depts.setNetwork("1D");
        depts.setManufacturer("C");
        return depts;
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.getProperties().put("hibernate.search.model_mapping", ProgrammaticSearchMappingFactory.class.getName());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Address.class, Country.class, BlogEntry.class, ProvidedIdEntry.class, ProductCatalog.class, Item.class, Departments.class, DynamicBoostedDescLibrary.class};
    }
}

