/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.engine.Country;
import org.hibernate.search.test.engine.Location;
import org.hibernate.search.test.engine.PinPoint;

public class NumericFieldTest
extends SearchTestCase {
    FullTextSession fullTextSession;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.prepareData();
    }

    @Override
    public void tearDown() throws Exception {
        this.cleanData();
        NumericFieldTest.assertTrue((boolean)this.indexIsEmpty());
        super.tearDown();
    }

    public void testIndexAndSearchNumericField() {
        Transaction tx = this.fullTextSession.beginTransaction();
        NumericFieldTest.assertEquals((String)"Query id ", (int)3, (int)this.numericQueryFor("overridenFieldName", 1, 3).size());
        NumericFieldTest.assertEquals((String)"Query by double range", (int)3, (int)this.numericQueryFor("latitude", -10.0, 10.0).size());
        NumericFieldTest.assertEquals((String)"Query by integer range", (int)4, (int)this.numericQueryFor("ranking", 1, 2).size());
        NumericFieldTest.assertEquals((String)"Query by long range", (int)3, (int)this.numericQueryFor("myCounter", 1L, 3L).size());
        NumericFieldTest.assertEquals((String)"Query by multifields", (int)2, (int)this.numericQueryFor("strMultiple", 0.7, 0.9).size());
        NumericFieldTest.assertEquals((String)"Query by id excluding upper", (int)2, (int)this.numericQueryFor("overridenFieldName", 1, 3, true, false).size());
        NumericFieldTest.assertEquals((String)"Query by id excluding upper and lower", (int)1, (int)this.numericQueryFor("overridenFieldName", 1, 3, false, false).size());
        NumericFieldTest.assertEquals((String)"Range Query for indexed embedded", (int)2, (int)this.numericQueryFor("country.idh", 0.9, 1.0).size());
        NumericFieldTest.assertEquals((String)"Range Query across entities", (int)1, (int)this.numericQueryFor("pinPoints.stars", 4, 5).size());
        NumericFieldTest.assertEquals((String)"Query id exact", (int)1, (int)this.doExactQuery("overridenFieldName", 1).getId());
        NumericFieldTest.assertEquals((String)"Query double exact", (int)2, (int)this.doExactQuery("latitude", -10.0).getId());
        NumericFieldTest.assertEquals((String)"Query integer exact", (int)3, (int)this.doExactQuery("longitude", -20.0).getId());
        NumericFieldTest.assertEquals((String)"Query long exact", (int)4, (int)this.doExactQuery("myCounter", 4L).getId());
        NumericFieldTest.assertEquals((String)"Query multifield exact", (int)5, (int)this.doExactQuery("strMultiple", 0.1).getId());
        tx.commit();
        this.fullTextSession.clear();
        tx = this.fullTextSession.beginTransaction();
        List allLocations = this.fullTextSession.createCriteria(Location.class).list();
        for (Object location : allLocations) {
            this.fullTextSession.delete(location);
        }
        tx.commit();
        this.fullTextSession.clear();
        tx = this.fullTextSession.beginTransaction();
        NumericFieldTest.assertEquals((String)"Check for deletion on Query", (int)0, (int)this.numericQueryFor("overridenFieldName", 1, 6).size());
        Query query = NumericFieldUtils.createNumericRangeQuery((String)"overridenFieldName", (Object)1, (Object)6, (boolean)true, (boolean)true);
        FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Location.class}).setProjection(new String[]{"__HSearch_Document"});
        NumericFieldTest.assertEquals((String)"Check for deletion on index projection", (int)0, (int)fullTextQuery.list().size());
        tx.commit();
    }

    private boolean indexIsEmpty() {
        int numDocsLocation = this.countSizeForType(Location.class);
        int numDocsPinPoint = this.countSizeForType(PinPoint.class);
        return numDocsLocation == 0 && numDocsPinPoint == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countSizeForType(Class<?> type) {
        SearchFactory searchFactory = this.fullTextSession.getSearchFactory();
        int numDocs = -1;
        IndexReader locationIndexReader = searchFactory.getIndexReaderAccessor().open(new Class[]{type});
        try {
            numDocs = locationIndexReader.numDocs();
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(locationIndexReader);
        }
        return numDocs;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{PinPoint.class, Location.class};
    }

    private Location doExactQuery(String fieldName, Object value) {
        Query matchQuery = NumericFieldUtils.createExactMatchQuery((String)fieldName, (Object)value);
        return (Location)this.fullTextSession.createFullTextQuery(matchQuery, new Class[]{Location.class}).list().get(0);
    }

    private List numericQueryFor(String fieldName, Object from, Object to) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)from, (Object)to, (boolean)true, (boolean)true);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{Location.class}).list();
    }

    private List numericQueryFor(String fieldName, Object from, Object to, boolean includeLower, boolean includeUpper) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)from, (Object)to, (boolean)includeLower, (boolean)includeUpper);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{Location.class}).list();
    }

    private void prepareData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        Location loc1 = new Location(1, 1L, -20.0, -40.0, 1, "Random text", 1.5, this.countryFor("England", 0.947));
        loc1.addPinPoints(new PinPoint(1, 4, loc1), new PinPoint(2, 5, loc1));
        Location loc2 = new Location(2, 2L, -10.0, -30.0, 1, "Some text", 0.786, this.countryFor("Italy", 0.951));
        loc2.addPinPoints(new PinPoint(3, 1, loc2), new PinPoint(4, 2, loc2));
        Location loc3 = new Location(3, 3L, 0.0, -20.0, 1, "A text", 0.86, this.countryFor("Brazil", 0.813));
        Location loc4 = new Location(4, 4L, 10.0, 0.0, 2, "Any text", 0.99, this.countryFor("France", 0.872));
        Location loc5 = new Location(5, 5L, 20.0, 20.0, 3, "Random text", 0.1, this.countryFor("India", 0.612));
        this.fullTextSession.save((Object)loc1);
        this.fullTextSession.save((Object)loc2);
        this.fullTextSession.save((Object)loc3);
        this.fullTextSession.save((Object)loc4);
        this.fullTextSession.save((Object)loc5);
        tx.commit();
        this.fullTextSession.clear();
    }

    private Country countryFor(String name, double idh) {
        return new Country(name, idh);
    }

    private void cleanData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        List locations = this.fullTextSession.createCriteria(Location.class).list();
        for (Location location : locations) {
            this.fullTextSession.delete((Object)location);
        }
        tx.commit();
        this.fullTextSession.close();
    }
}

