/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.errorhandling;

import java.io.IOException;
import junit.framework.Assert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.errorhandling.MockErrorHandler;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class ConcurrentMergeErrorHandledTest
extends SearchTestCase {
    @Test
    @BMRule(targetClass="org.apache.lucene.index.ConcurrentMergeScheduler", targetMethod="merge", action="throw new IOException(\"Byteman said: your disk is full!\")", name="testLuceneMergerErrorHandling")
    public void testLuceneMergerErrorHandling() {
        SearchFactoryImplementor searchFactory = this.getSearchFactoryImpl();
        ErrorHandler errorHandler = searchFactory.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        MockErrorHandler mockErrorHandler = (MockErrorHandler)errorHandler;
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        session.persist((Object)new Document("Byteman Programmers Guider", "Version 1.5.2 Draft", "contains general guidelines to use Byteman"));
        transaction.commit();
        session.close();
        String errorMessage = mockErrorHandler.getErrorMessage();
        Assert.assertEquals((String)"IOException on the IndexWriter", (String)errorMessage);
        Throwable exception = mockErrorHandler.getLastException();
        Assert.assertTrue((boolean)(exception instanceof IOException));
        Assert.assertEquals((String)"Byteman said: your disk is full!", (String)exception.getMessage());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class};
    }

    @Override
    protected SearchFactoryImplementor getSearchFactoryImpl() {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.close();
        SearchFactory searchFactory = s.getSearchFactory();
        return (SearchFactoryImplementor)searchFactory;
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }
}

