/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.inheritance;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.inheritance.Animal;
import org.hibernate.search.test.inheritance.Being;
import org.hibernate.search.test.inheritance.Bird;
import org.hibernate.search.test.inheritance.Eagle;
import org.hibernate.search.test.inheritance.Fish;
import org.hibernate.search.test.inheritance.Mammal;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class InheritanceTest
extends SearchTestCase {
    private static final Log log = LoggerFactory.make();

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testSearchUnindexClass() throws Exception {
        FullTextQuery hibQuery;
        this.createTestData();
        QueryParser parser = new QueryParser(InheritanceTest.getTargetLuceneVersion(), "name", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("Elephant");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        try {
            hibQuery = s.createFullTextQuery(query, new Class[]{String.class});
            hibQuery.list();
            tx.commit();
            InheritanceTest.fail();
        }
        catch (IllegalArgumentException iae) {
            log.debug((Object)"success");
            tx.rollback();
        }
        tx = s.beginTransaction();
        hibQuery = s.createFullTextQuery(query, new Class[]{Mammal.class});
        this.assertItsTheElephant(hibQuery.list());
        tx.commit();
        s.close();
    }

    public void testInheritance() throws Exception {
        this.createTestData();
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(InheritanceTest.getTargetLuceneVersion(), "name", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("Elephant");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Mammal.class});
        this.assertItsTheElephant(hibQuery.list());
        query = parser.parse("Elephant");
        hibQuery = s.createFullTextQuery(query, new Class[0]);
        this.assertItsTheElephant(hibQuery.list());
        query = parser.parse("hasSweatGlands:false");
        hibQuery = s.createFullTextQuery(query, new Class[]{Animal.class, Mammal.class});
        this.assertItsTheElephant(hibQuery.list());
        query = parser.parse("Elephant OR White Pointer");
        hibQuery = s.createFullTextQuery(query, new Class[]{Being.class});
        List result = hibQuery.list();
        InheritanceTest.assertNotNull((Object)result);
        InheritanceTest.assertEquals((String)"Query filtering on superclass return mapped subclasses", (int)2, (int)result.size());
        query = new TermRangeQuery("weight", "04000", "05000", true, true);
        hibQuery = s.createFullTextQuery(query, new Class[]{Animal.class});
        this.assertItsTheElephant(hibQuery.list());
        query = parser.parse("Elephant");
        hibQuery = s.createFullTextQuery(query, new Class[]{Being.class});
        this.assertItsTheElephant(hibQuery.list());
        tx.commit();
        s.close();
    }

    public void testPolymorphicQueries() throws Exception {
        this.createTestData();
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(InheritanceTest.getTargetLuceneVersion(), "name", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("Elephant");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Mammal.class});
        this.assertItsTheElephant(hibQuery.list());
        hibQuery = s.createFullTextQuery(query, new Class[]{Animal.class});
        this.assertItsTheElephant(hibQuery.list());
        hibQuery = s.createFullTextQuery(query, new Class[]{Being.class});
        this.assertItsTheElephant(hibQuery.list());
        hibQuery = s.createFullTextQuery(query, new Class[]{Object.class});
        this.assertItsTheElephant(hibQuery.list());
        hibQuery = s.createFullTextQuery(query, new Class[]{Serializable.class});
        this.assertItsTheElephant(hibQuery.list());
        hibQuery = s.createFullTextQuery(query, new Class[]{Mammal.class, Animal.class, Being.class, Object.class, Serializable.class});
        this.assertItsTheElephant(hibQuery.list());
        tx.commit();
        s.close();
    }

    public void testSubclassInclusion() throws Exception {
        this.createTestData();
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        TermQuery query = new TermQuery(new Term("numberOfEggs", "2"));
        FullTextQuery hibQuery = s.createFullTextQuery((Query)query, new Class[]{Eagle.class});
        List result = hibQuery.list();
        InheritanceTest.assertNotNull((Object)result);
        InheritanceTest.assertEquals((String)"Wrong number of hits. There should be two birds.", (int)1, (int)result.size());
        query = new TermQuery(new Term("numberOfEggs", "2"));
        hibQuery = s.createFullTextQuery((Query)query, new Class[]{Bird.class});
        result = hibQuery.list();
        InheritanceTest.assertNotNull((Object)result);
        InheritanceTest.assertEquals((String)"Wrong number of hits. There should be two birds.", (int)2, (int)result.size());
        query = new TermQuery(new Term("numberOfEggs", "2"));
        hibQuery = s.createFullTextQuery((Query)query, new Class[]{Mammal.class});
        result = hibQuery.list();
        InheritanceTest.assertNotNull((Object)result);
        InheritanceTest.assertEquals((String)"Wrong number of hits. There should be two birds.", (int)0, (int)result.size());
        try {
            query = new TermQuery(new Term("numberOfEggs", "2"));
            hibQuery = s.createFullTextQuery((Query)query, new Class[]{String.class});
            hibQuery.list();
            InheritanceTest.fail();
        }
        catch (IllegalArgumentException iae) {
            log.debug((Object)"success");
        }
        tx.commit();
        s.close();
    }

    public void testPurgeIndex() throws Exception {
        this.createTestData();
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        this.assertNumberOfAnimals(s, 5);
        tx.commit();
        tx = s.beginTransaction();
        s.purgeAll(Serializable.class);
        tx.commit();
        tx = s.beginTransaction();
        this.assertNumberOfAnimals(s, 3);
        tx.commit();
        tx = s.beginTransaction();
        s.purgeAll(Bird.class);
        tx.commit();
        tx = s.beginTransaction();
        this.assertNumberOfAnimals(s, 1);
        tx.commit();
        tx = s.beginTransaction();
        s.purgeAll(Object.class);
        tx.commit();
        tx = s.beginTransaction();
        this.assertNumberOfAnimals(s, 0);
        tx.commit();
        s.close();
    }

    public void testPurgeUnIndexClass() throws Exception {
        this.createTestData();
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        this.assertNumberOfAnimals(s, 5);
        tx.commit();
        tx = s.beginTransaction();
        try {
            s.purgeAll(String.class);
            tx.commit();
            InheritanceTest.fail();
        }
        catch (IllegalArgumentException iae) {
            log.debug((Object)"Success");
        }
        s.close();
    }

    private void assertNumberOfAnimals(FullTextSession s, int count) throws Exception {
        QueryParser parser = new QueryParser(InheritanceTest.getTargetLuceneVersion(), "name", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("Elephant OR White Pointer OR Chimpanzee OR Dove or Eagle");
        List result = s.createFullTextQuery(query, new Class[]{Animal.class}).list();
        InheritanceTest.assertNotNull((Object)result);
        InheritanceTest.assertEquals((String)"Wrong number of hits. There should be one elephant and one shark.", (int)count, (int)result.size());
    }

    private void createTestData() {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Fish shark = new Fish();
        shark.setName("White Pointer");
        shark.setNumberOfDorsalFins(2);
        shark.setWeight(1500);
        s.save((Object)shark);
        Mammal elephant = new Mammal();
        elephant.setName("Elephant");
        elephant.setHasSweatGlands(false);
        elephant.setWeight(4500);
        s.save((Object)elephant);
        Mammal chimp = new Mammal();
        chimp.setName("Chimpanzee");
        chimp.setHasSweatGlands(true);
        chimp.setWeight(50);
        s.save((Object)chimp);
        Bird dove = new Bird();
        dove.setName("Dove");
        dove.setNumberOfEggs(2);
        s.save((Object)dove);
        Eagle eagle = new Eagle();
        eagle.setName("Bald Eagle");
        eagle.setNumberOfEggs(2);
        eagle.setWingYype(Eagle.WingType.BROAD);
        s.save((Object)eagle);
        tx.commit();
        s.clear();
    }

    private void assertItsTheElephant(List result) {
        InheritanceTest.assertNotNull((Object)result);
        InheritanceTest.assertEquals((String)"Wrong number of results", (int)1, (int)result.size());
        InheritanceTest.assertTrue((String)"Wrong result type", (boolean)(result.get(0) instanceof Mammal));
        Mammal mammal = (Mammal)result.get(0);
        InheritanceTest.assertEquals((String)"Wrong animal name", (String)"Elephant", (String)mammal.getName());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Animal.class, Mammal.class, Fish.class, Bird.class, Eagle.class};
    }
}

