/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.util.Iterator;
import java.util.List;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.FetchMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.query.AlternateBook;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.query.Clock;
import org.hibernate.search.test.query.Employee;
import org.hibernate.search.util.impl.HibernateHelper;
import org.hibernate.stat.Statistics;

public class LuceneQueryTest
extends SearchTestCase {
    public void testList() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Clock clock = new Clock(1, "Seiko");
        s.save((Object)clock);
        clock = new Clock(2, "Festina");
        s.save((Object)clock);
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        s.save((Object)book);
        book = new Book(2, "La gloire de mon p\u00e8re", "Les deboires de mon p\u00e8re en v\u00e9lo");
        s.save((Object)book);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "title", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("summary:noword");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        List result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((int)0, (int)result.size());
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"Query with explicit class filter", (int)2, (int)result.size());
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class});
        result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"Query with one class filter", (int)1, (int)result.size());
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = s.createFullTextQuery(query, new Class[0]);
        result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"Query with no class filter", (int)2, (int)result.size());
        for (Object element : result) {
            LuceneQueryTest.assertTrue((boolean)HibernateHelper.isInitialized(element));
            s.delete(element);
        }
        s.flush();
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = s.createFullTextQuery(query, new Class[0]);
        result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"Query with delete objects", (int)0, (int)result.size());
        for (Object element : s.createQuery("from java.lang.Object").list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testResultSize() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Clock clock = new Clock(1, "Seiko");
        s.save((Object)clock);
        clock = new Clock(2, "Festina");
        s.save((Object)clock);
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        s.save((Object)book);
        book = new Book(2, "La gloire de mon p\u00e8re", "Les deboires de mon p\u00e8re en v\u00e9lo");
        s.save((Object)book);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "title", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("summary:Festina Or brand:Seiko");
        Statistics stats = s.getSessionFactory().getStatistics();
        stats.clear();
        boolean enabled = stats.isStatisticsEnabled();
        if (!enabled) {
            stats.setStatisticsEnabled(true);
        }
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        LuceneQueryTest.assertEquals((String)"Exection of getResultSize without actual results", (int)2, (int)hibQuery.getResultSize());
        LuceneQueryTest.assertEquals((String)"No entity should be loaded", (long)0L, (long)stats.getEntityLoadCount());
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = s.createFullTextQuery(query, new Class[0]);
        List result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"2 entities should be loaded", (long)2L, (long)stats.getEntityLoadCount());
        if (!enabled) {
            stats.setStatisticsEnabled(false);
        }
        for (Object element : s.createQuery("from java.lang.Object").list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testFirstMax() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Clock clock = new Clock(1, "Seiko");
        s.save((Object)clock);
        clock = new Clock(2, "Festina");
        s.save((Object)clock);
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        s.save((Object)book);
        book = new Book(2, "La gloire de mon p\u00e8re", "Les deboires de mon p\u00e8re en v\u00e9lo");
        s.save((Object)book);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "title", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("summary:Festina Or brand:Seiko");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        hibQuery.setFirstResult(1);
        List result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"first result no max result", (int)1, (int)result.size());
        hibQuery.setFirstResult(0);
        hibQuery.setMaxResults(1);
        result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"max result set", (int)1, (int)result.size());
        hibQuery.setFirstResult(0);
        hibQuery.setMaxResults(3);
        result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"max result out of limit", (int)2, (int)result.size());
        hibQuery.setFirstResult(2);
        hibQuery.setMaxResults(3);
        result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"first result out of limit", (int)0, (int)result.size());
        for (Object element : s.createQuery("from java.lang.Object").list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testIterator() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Clock clock = new Clock(1, "Seiko");
        s.save((Object)clock);
        clock = new Clock(2, "Festina");
        s.save((Object)clock);
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        s.save((Object)book);
        book = new Book(2, "La gloire de mon p\u00e8re", "Les deboires de mon p\u00e8re en v\u00e9lo");
        s.save((Object)book);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "title", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("summary:noword");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        Iterator result = hibQuery.iterate();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertFalse((boolean)result.hasNext());
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        result = hibQuery.iterate();
        LuceneQueryTest.assertNotNull((Object)result);
        int index = 0;
        while (result.hasNext()) {
            ++index;
            s.delete(result.next());
        }
        LuceneQueryTest.assertEquals((int)2, (int)index);
        s.flush();
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        result = hibQuery.iterate();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertFalse((boolean)result.hasNext());
        for (Object element : s.createQuery("from java.lang.Object").list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testScrollableResultSet() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Clock clock = new Clock(1, "Seiko");
        s.save((Object)clock);
        clock = new Clock(2, "Festina");
        s.save((Object)clock);
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        s.save((Object)book);
        book = new Book(2, "La gloire de mon p\u00e8re", "Les deboires de mon p\u00e8re en v\u00e9lo");
        s.save((Object)book);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "title", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("summary:noword");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        ScrollableResults result = hibQuery.scroll();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((int)-1, (int)result.getRowNumber());
        LuceneQueryTest.assertEquals((boolean)false, (boolean)result.next());
        result.close();
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        result = hibQuery.scroll();
        LuceneQueryTest.assertEquals((int)-1, (int)result.getRowNumber());
        result.beforeFirst();
        LuceneQueryTest.assertEquals((boolean)true, (boolean)result.next());
        LuceneQueryTest.assertTrue((boolean)result.isFirst());
        LuceneQueryTest.assertTrue((boolean)result.scroll(1));
        LuceneQueryTest.assertTrue((boolean)result.isLast());
        LuceneQueryTest.assertFalse((boolean)result.scroll(1));
        result.beforeFirst();
        while (result.next()) {
            s.delete(result.get()[0]);
        }
        for (Object element : s.createQuery("from java.lang.Object").list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testDefaultFetchSize() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "dept", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        ScrollableResults projections = hibQuery.scroll();
        projections.beforeFirst();
        Object[] projection = projections.get();
        LuceneQueryTest.assertNull((Object)projection);
        projections.next();
        LuceneQueryTest.assertTrue((boolean)projections.isFirst());
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testFetchSizeLargerThanHits() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "dept", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        hibQuery.setFetchSize(6);
        ScrollableResults results = hibQuery.scroll();
        results.beforeFirst();
        results.next();
        Object[] result = results.get();
        LuceneQueryTest.assertEquals((String)"incorrect entityInfo returned", (Object)1000, (Object)result[0]);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testFetchSizeDefaultFirstAndMax() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "dept", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setSort(new Sort(new SortField("id", 3)));
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        hibQuery.setFetchSize(3);
        ScrollableResults results = hibQuery.scroll();
        results.beforeFirst();
        results.next();
        Object[] result = results.get();
        LuceneQueryTest.assertEquals((String)"incorrect entityInfo returned", (Object)1000, (Object)result[0]);
        results.scroll(2);
        result = results.get();
        LuceneQueryTest.assertEquals((String)"incorrect entityInfo returned", (Object)1003, (Object)result[0]);
        results.next();
        result = results.get();
        LuceneQueryTest.assertEquals((String)"incorrect entityInfo returned", (Object)1004, (Object)result[0]);
        results.scroll(-2);
        result = results.get();
        LuceneQueryTest.assertEquals((String)"incorrect entityInfo returned", (Object)1002, (Object)result[0]);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testFetchSizeNonDefaultFirstAndMax() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "dept", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        hibQuery.setFetchSize(3);
        hibQuery.setFirstResult(1);
        hibQuery.setMaxResults(3);
        hibQuery.setSort(new Sort(new SortField("id", 3)));
        ScrollableResults results = hibQuery.scroll();
        results.beforeFirst();
        results.next();
        Object[] result = results.get();
        LuceneQueryTest.assertEquals((String)"incorrect entityInfo returned", (Object)1002, (Object)result[0]);
        results.scroll(2);
        result = results.get();
        LuceneQueryTest.assertEquals((String)"incorrect entityInfo returned", (Object)1004, (Object)result[0]);
        results.next();
        result = results.get();
        LuceneQueryTest.assertNull((Object)result);
        results.scroll(-8);
        result = results.get();
        LuceneQueryTest.assertNull((Object)result);
        results.scroll(10);
        result = results.get();
        LuceneQueryTest.assertNull((Object)result);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testFetchSizeNonDefaultFirstAndMaxNoHits() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "dept", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("dept:XXX");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        hibQuery.setFetchSize(3);
        hibQuery.setFirstResult(1);
        hibQuery.setMaxResults(3);
        ScrollableResults results = hibQuery.scroll();
        results.beforeFirst();
        Object[] result = results.get();
        LuceneQueryTest.assertNull((String)"non-null entity infos returned", (Object)result);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testMaxResultZero() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "dept", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("dept:foo");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setFirstResult(0);
        hibQuery.setMaxResults(0);
        List result = hibQuery.list();
        LuceneQueryTest.assertTrue((String)"We should get the empty result list", (boolean)result.isEmpty());
        hibQuery.setFirstResult(1);
        hibQuery.setMaxResults(0);
        result = hibQuery.list();
        LuceneQueryTest.assertTrue((String)"We should get the empty result list", (boolean)result.isEmpty());
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testCurrent() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "dept", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        ScrollableResults results = hibQuery.scroll();
        results.beforeFirst();
        results.next();
        LuceneQueryTest.assertTrue((String)"beforeFirst() pointer incorrect", (boolean)results.isFirst());
        results.afterLast();
        results.previous();
        LuceneQueryTest.assertTrue((String)"afterLast() pointer incorrect", (boolean)results.isLast());
        results.scroll(-8);
        results.next();
        LuceneQueryTest.assertTrue((String)"large negative scroll() pointer incorrect", (boolean)results.isFirst());
        results.scroll(10);
        results.previous();
        LuceneQueryTest.assertTrue((String)"large positive scroll() pointer incorrect", (boolean)results.isLast());
        hibQuery.setFirstResult(3);
        hibQuery.setMaxResults(1);
        results = hibQuery.scroll();
        results.first();
        Object[] result = results.get();
        LuceneQueryTest.assertEquals((Object)1004, (Object)result[0]);
        results.last();
        result = results.get();
        LuceneQueryTest.assertEquals((Object)1004, (Object)result[0]);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testMultipleEntityPerIndex() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Clock clock = new Clock(1, "Seiko");
        s.save((Object)clock);
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        s.save((Object)book);
        AlternateBook alternateBook = new AlternateBook(1, "La chute de la petite reine a travers les yeux de Festina");
        s.save((Object)alternateBook);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "title", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("summary:Festina");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        List result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"Query with explicit class filter", (int)1, (int)result.size());
        query = parser.parse("summary:Festina");
        hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        Iterator it = hibQuery.iterate();
        LuceneQueryTest.assertTrue((boolean)it.hasNext());
        LuceneQueryTest.assertNotNull(it.next());
        LuceneQueryTest.assertFalse((boolean)it.hasNext());
        query = parser.parse("summary:Festina");
        hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        ScrollableResults sr = hibQuery.scroll();
        LuceneQueryTest.assertTrue((boolean)sr.first());
        LuceneQueryTest.assertNotNull((Object)sr.get());
        LuceneQueryTest.assertFalse((boolean)sr.next());
        sr.close();
        query = parser.parse("summary:Festina OR brand:seiko");
        hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        hibQuery.setMaxResults(2);
        result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"Query with explicit class filter and limit", (int)2, (int)result.size());
        query = parser.parse("summary:Festina");
        hibQuery = s.createFullTextQuery(query, new Class[0]);
        result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"Query with no class filter", (int)2, (int)result.size());
        for (Object element : result) {
            LuceneQueryTest.assertTrue((boolean)HibernateHelper.isInitialized(element));
            s.delete(element);
        }
        for (Object element : s.createQuery("from java.lang.Object").list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testCriteria() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        s.save((Object)book);
        Author emmanuel = new Author();
        emmanuel.setName("Emmanuel");
        s.save((Object)emmanuel);
        book.getAuthors().add(emmanuel);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "title", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("summary:Festina");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        List result = hibQuery.list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"Query with no explicit criteria", (int)1, (int)result.size());
        book = (Book)result.get(0);
        LuceneQueryTest.assertFalse((String)"Association should not be inintialized", (boolean)HibernateHelper.isInitialized(book.getAuthors()));
        result = s.createFullTextQuery(query, new Class[0]).setCriteriaQuery(s.createCriteria(Book.class).setFetchMode("authors", FetchMode.JOIN)).list();
        LuceneQueryTest.assertNotNull((Object)result);
        LuceneQueryTest.assertEquals((String)"Query with explicit criteria", (int)1, (int)result.size());
        book = (Book)result.get(0);
        LuceneQueryTest.assertTrue((String)"Association should be inintialized", (boolean)HibernateHelper.isInitialized(book.getAuthors()));
        LuceneQueryTest.assertEquals((int)1, (int)book.getAuthors().size());
        Author author = book.getAuthors().iterator().next();
        book.getAuthors().remove(author);
        for (Object element : s.createQuery("from java.lang.Object").list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testScrollEmptyHits() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "dept", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("dept:XXX");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        ScrollableResults projections = hibQuery.scroll();
        projections.beforeFirst();
        projections.next();
        Object[] projection = projections.get();
        LuceneQueryTest.assertNull((Object)projection);
        hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class}).setFirstResult(10).setMaxResults(20);
        projections = hibQuery.scroll();
        projections.beforeFirst();
        projections.next();
        projection = projections.get();
        LuceneQueryTest.assertNull((Object)projection);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testListEmptyHits() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "dept", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("dept:XXX");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        List result = hibQuery.list();
        LuceneQueryTest.assertEquals((int)0, (int)result.size());
        hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class}).setFirstResult(10).setMaxResults(20);
        result = hibQuery.list();
        LuceneQueryTest.assertEquals((int)0, (int)result.size());
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testIterateEmptyHits() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(LuceneQueryTest.getTargetLuceneVersion(), "dept", SearchTestCase.standardAnalyzer);
        Query query = parser.parse("dept:XXX");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        Iterator iter = hibQuery.iterate();
        LuceneQueryTest.assertFalse((boolean)iter.hasNext());
        hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class}).setFirstResult(10).setMaxResults(20);
        iter = hibQuery.iterate();
        LuceneQueryTest.assertFalse((boolean)iter.hasNext());
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    private void prepEmployeeIndex(FullTextSession s) {
        Transaction tx = s.beginTransaction();
        s.save((Object)new Employee(1000, "Griffin", "ITech"));
        s.save((Object)new Employee(1001, "Jackson", "Accounting"));
        s.save((Object)new Employee(1002, "Jimenez", "ITech"));
        s.save((Object)new Employee(1003, "Stejskal", "ITech"));
        s.save((Object)new Employee(1004, "Whetbrook", "ITech"));
        tx.commit();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, AlternateBook.class, Clock.class, Author.class, Employee.class};
    }
}

