/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.initandlookup;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.fest.assertions.Condition;
import org.fest.assertions.LongAssert;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.query.initandlookup.Kernel;
import org.hibernate.stat.Statistics;
import org.hibernate.testing.cache.CachingRegionFactory;

public class SecondLCAndPCLookupTest
extends SearchTestCase {
    public void testQueryWoLookup() throws Exception {
        Session session = this.openSession();
        Statistics statistics = session.getSessionFactory().getStatistics();
        statistics.clear();
        statistics.setStatisticsEnabled(true);
        this.setData(session, statistics);
        session.clear();
        Transaction transaction = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Kernel.class).get();
        Query luceneQuery = queryBuilder.keyword().onField("product").matching((Object)"Polgeiser").createQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Kernel.class});
        List list = fullTextQuery.list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((long)statistics.getSecondLevelCacheHitCount()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.getQueryExecutionCount()).isEqualTo(1L);
        transaction.commit();
        this.clearData(session);
        session.close();
    }

    public void testQueryWith2LCLookup() throws Exception {
        Session session = this.openSession();
        Statistics statistics = session.getSessionFactory().getStatistics();
        statistics.clear();
        statistics.setStatisticsEnabled(true);
        this.setData(session, statistics);
        session.clear();
        Transaction transaction = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Kernel.class).get();
        Query luceneQuery = queryBuilder.keyword().onField("product").matching((Object)"Polgeiser").createQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Kernel.class});
        fullTextQuery.initializeObjectsWith(ObjectLookupMethod.SECOND_LEVEL_CACHE, DatabaseRetrievalMethod.QUERY);
        List list = fullTextQuery.list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((long)statistics.getSecondLevelCacheHitCount()).isEqualTo(2L);
        Assertions.assertThat((long)statistics.getQueryExecutionCount()).isEqualTo(0L);
        transaction.commit();
        this.clearData(session);
        session.close();
    }

    public void testQueryWithPCLookup() throws Exception {
        Session session = this.openSession();
        Statistics statistics = session.getSessionFactory().getStatistics();
        statistics.clear();
        statistics.setStatisticsEnabled(true);
        this.setData(session, statistics);
        session.clear();
        Transaction transaction = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        session.createQuery("from " + Kernel.class.getName()).list();
        statistics.clear();
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Kernel.class).get();
        Query luceneQuery = queryBuilder.keyword().onField("product").matching((Object)"Polgeiser").createQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Kernel.class});
        fullTextQuery.initializeObjectsWith(ObjectLookupMethod.PERSISTENCE_CONTEXT, DatabaseRetrievalMethod.QUERY);
        List list = fullTextQuery.list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((long)statistics.getSecondLevelCacheHitCount()).isEqualTo(0L);
        ((LongAssert)Assertions.assertThat((long)statistics.getQueryExecutionCount()).describedAs("entities should be looked up and are already loaded")).isEqualTo(0L);
        ((LongAssert)Assertions.assertThat((long)statistics.getEntityLoadCount()).describedAs("entities should be looked up and are already loaded")).isEqualTo(0L);
        transaction.commit();
        this.clearData(session);
        session.close();
    }

    public void testQueryWithPCAndCacheLookup() throws Exception {
        Session session = this.openSession();
        Statistics statistics = session.getSessionFactory().getStatistics();
        statistics.clear();
        statistics.setStatisticsEnabled(true);
        this.setData(session, statistics);
        session.clear();
        Transaction transaction = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        List firstLoad = session.createQuery("from Kernel k where k.codeName = 'coconut'").list();
        Assertions.assertThat((int)firstLoad.size()).isEqualTo(1);
        statistics.clear();
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Kernel.class).get();
        Query luceneQuery = queryBuilder.keyword().onField("product").matching((Object)"Polgeiser").createQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Kernel.class});
        fullTextQuery.initializeObjectsWith(ObjectLookupMethod.SECOND_LEVEL_CACHE, DatabaseRetrievalMethod.QUERY);
        List list = fullTextQuery.list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((long)statistics.getSecondLevelCacheHitCount()).isEqualTo(1L);
        ((LongAssert)Assertions.assertThat((long)statistics.getQueryExecutionCount()).describedAs("entities should be looked up and are already loaded")).isEqualTo(0L);
        ((LongAssert)Assertions.assertThat((long)statistics.getEntityLoadCount()).describedAs("entities should be looked up and are already loaded")).isEqualTo(0L);
        transaction.commit();
        this.clearData(session);
        session.close();
    }

    public void testQueryUsingFindByIdInitialization() throws Exception {
        Session session = this.openSession();
        Statistics statistics = session.getSessionFactory().getStatistics();
        statistics.clear();
        statistics.setStatisticsEnabled(true);
        this.setData(session, statistics);
        Transaction tx = session.beginTransaction();
        Kernel k = new Kernel();
        k.setCodeName("notpresent");
        k.setProduct("Polgeiser");
        session.persist((Object)k);
        session.flush();
        Search.getFullTextSession((Session)session).flushToIndexes();
        tx.rollback();
        session.clear();
        session.getSessionFactory().getCache().evictEntityRegion(Kernel.class);
        statistics.clear();
        Transaction transaction = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Kernel.class).get();
        Query luceneQuery = queryBuilder.keyword().onField("product").matching((Object)"Polgeiser").createQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Kernel.class});
        fullTextQuery.initializeObjectsWith(ObjectLookupMethod.SKIP, DatabaseRetrievalMethod.FIND_BY_ID);
        List list = fullTextQuery.list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        for (Object o : list) {
            Assertions.assertThat(o).satisfies((Condition)new Condition<Object>(){

                public boolean matches(Object value) {
                    return Hibernate.isInitialized((Object)value);
                }
            });
        }
        for (Object o : list) {
            o.toString();
        }
        Assertions.assertThat((long)statistics.getSecondLevelCacheHitCount()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.getQueryExecutionCount()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.getEntityLoadCount()).isEqualTo(2L);
        transaction.commit();
        this.clearData(session);
        session.close();
    }

    private void clearData(Session session) {
        Transaction transaction = session.beginTransaction();
        session.createQuery("delete from " + Kernel.class.getName()).executeUpdate();
        transaction.commit();
    }

    private void setData(Session session, Statistics statistics) {
        Transaction transaction = session.beginTransaction();
        Kernel k = new Kernel();
        k.setCodeName("coconut");
        k.setProduct("Polgeiser");
        session.persist((Object)k);
        Kernel k2 = new Kernel();
        k2.setCodeName("ballpark");
        k2.setProduct("Polgeiser");
        session.persist((Object)k2);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        session.get(Kernel.class, (Serializable)k.getId());
        session.get(Kernel.class, (Serializable)k2.getId());
        transaction.commit();
        Assertions.assertThat((long)statistics.getSecondLevelCachePutCount()).isEqualTo(2L);
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.cache.use_second_level_cache", "true");
        cfg.setProperty("hibernate.cache.region.factory_class", CachingRegionFactory.class.getCanonicalName());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Kernel.class};
    }
}

