/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.io.Serializable;
import java.util.Properties;
import org.apache.lucene.document.Document;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;

public class ProductsAvailabilityShardingStrategy
implements IndexShardingStrategy {
    private IndexManager availableProductsIndex;
    private IndexManager toOrderProductsIndex;
    private IndexManager[] both;

    public void initialize(Properties properties, IndexManager[] providers) {
        this.availableProductsIndex = providers[0];
        this.toOrderProductsIndex = providers[1];
        this.both = providers;
    }

    public IndexManager[] getIndexManagersForAllShards() {
        return this.both;
    }

    public IndexManager getIndexManagerForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
        String isAvailable = document.get("available");
        if ("true".equals(isAvailable)) {
            return this.availableProductsIndex;
        }
        return this.toOrderProductsIndex;
    }

    public IndexManager[] getIndexManagersForDeletion(Class<?> entity, Serializable id, String idInString) {
        return this.both;
    }

    public IndexManager[] getIndexManagersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        return this.both;
    }
}

