/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.worker.duplication;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.impl.WorkQueue;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.worker.duplication.EmailAddress;
import org.hibernate.search.test.worker.duplication.Person;
import org.hibernate.search.test.worker.duplication.SpecialPerson;

public class WorkDuplicationTest
extends SearchTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoWorkDuplication() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        SpecialPerson person = new SpecialPerson();
        person.setName("Joe Smith");
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.setAddress("foo@foobar.com");
        emailAddress.setDefaultAddress(true);
        person.addEmailAddress(emailAddress);
        s.persist((Object)person);
        tx.commit();
        tx = s.beginTransaction();
        String searchQuery = "Joe";
        QueryParser parser = new QueryParser(WorkDuplicationTest.getTargetLuceneVersion(), "Content", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse(searchQuery);
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        List results = query.list();
        WorkDuplicationTest.assertTrue((String)"We should have a hit", (results.size() == 1 ? 1 : 0) != 0);
        tx.commit();
        tx = s.beginTransaction();
        int id = person.getId();
        person = (SpecialPerson)s.get(SpecialPerson.class, (Serializable)Integer.valueOf(id));
        s.delete((Object)person);
        tx.commit();
        tx = s.beginTransaction();
        SearchFactory searchFactory = s.getSearchFactory();
        IndexReader indexReader = searchFactory.getIndexReaderAccessor().open(new Class[]{SpecialPerson.class});
        try {
            IndexSearcher searcher = new IndexSearcher(indexReader);
            TopDocs topDocs = searcher.search(luceneQuery, null, 1);
            WorkDuplicationTest.assertTrue((String)"We should have no hit", (topDocs.totalHits == 0 ? 1 : 0) != 0);
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(indexReader);
        }
        tx.commit();
        s.close();
    }

    public void testAddWorkGetReplacedByDeleteWork() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
        SpecialPerson person = new SpecialPerson();
        person.setName("Joe Smith");
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.setAddress("foo@foobar.com");
        emailAddress.setDefaultAddress(true);
        person.addEmailAddress(emailAddress);
        WorkQueue plannerEngine = new WorkQueue(searchFactory);
        plannerEngine.add(new Work((Object)person, (Serializable)Integer.valueOf(1), WorkType.ADD));
        plannerEngine.prepareWorkPlan();
        List sealedQueue = plannerEngine.getSealedQueue();
        WorkDuplicationTest.assertEquals((String)"There should only be one job in the queue", (int)1, (int)sealedQueue.size());
        WorkDuplicationTest.assertTrue((String)"Wrong job type", (boolean)(sealedQueue.get(0) instanceof AddLuceneWork));
        plannerEngine.add(new Work((Object)person, (Serializable)Integer.valueOf(1), WorkType.DELETE));
        plannerEngine.prepareWorkPlan();
        sealedQueue = plannerEngine.getSealedQueue();
        WorkDuplicationTest.assertEquals((String)"Jobs should have countered each other", (int)0, (int)sealedQueue.size());
        fullTextSession.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Person.class, EmailAddress.class, SpecialPerson.class};
    }
}

