/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.test.batchindexing.AncientBook;
import org.hibernate.search.test.batchindexing.Book;
import org.hibernate.search.test.batchindexing.Dvd;
import org.hibernate.search.test.batchindexing.Nation;
import org.hibernate.search.test.batchindexing.SecretBook;
import org.hibernate.search.test.batchindexing.TitleAble;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.test.util.textbuilder.SentenceInventor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexingGeneratedCorpusTest {
    private static final Log log = LoggerFactory.make();
    private final int BOOK_NUM = 140;
    private final int ANCIENTBOOK_NUM = 120;
    private final int SECRETBOOK_NUM = 20;
    private final int DVD_NUM = 200;
    private SentenceInventor sentenceInventor = new SentenceInventor(7L, 4000);
    private FullTextSessionBuilder builder;
    private int totalEntitiesInDB = 0;

    @Before
    public void setUp() throws Exception {
        this.builder = new FullTextSessionBuilder();
        this.builder.addAnnotatedClass(Book.class).addAnnotatedClass(Dvd.class).addAnnotatedClass(AncientBook.class).addAnnotatedClass(Nation.class).addAnnotatedClass(SecretBook.class).setProperty("hibernate.show_sql", "false").build();
        this.createMany(Book.class, 140);
        this.createMany(Dvd.class, 200);
        this.createMany(AncientBook.class, 120);
        this.createMany(SecretBook.class, 20);
        this.storeAllBooksInNation();
    }

    @After
    public void tearDown() {
        this.builder.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMany(Class<? extends TitleAble> entityType, int amount) throws InstantiationException, IllegalAccessException {
        FullTextSession fullTextSession = this.builder.openFullTextSession();
        try {
            Transaction tx = fullTextSession.beginTransaction();
            fullTextSession.persist((Object)new Nation("Italy", "IT"));
            tx.commit();
            tx = fullTextSession.beginTransaction();
            for (int i = 0; i < amount; ++i) {
                TitleAble instance = entityType.newInstance();
                instance.setTitle(this.sentenceInventor.nextSentence());
                Nation country = (Nation)fullTextSession.load(Nation.class, (Serializable)Integer.valueOf(1));
                instance.setFirstPublishedIn(country);
                fullTextSession.persist((Object)instance);
                ++this.totalEntitiesInDB;
                if (i % 250 != 249) continue;
                tx.commit();
                fullTextSession.clear();
                System.out.println("Test preparation: " + this.totalEntitiesInDB + " entities persisted");
                tx = fullTextSession.beginTransaction();
            }
            tx.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAllBooksInNation() {
        FullTextSession fullTextSession = this.builder.openFullTextSession();
        try {
            Transaction tx = fullTextSession.beginTransaction();
            List allBooks = fullTextSession.createCriteria(Book.class).list();
            Nation italy = (Nation)fullTextSession.load(Nation.class, (Serializable)Integer.valueOf(1));
            italy.getLibrariesHave().addAll(allBooks);
            tx.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    @Test
    public void testBatchIndexing() throws InterruptedException {
        this.verifyResultNumbers();
        this.purgeAll();
        this.verifyIsEmpty();
        this.reindexAll();
        this.verifyResultNumbers();
        this.reindexAll();
        this.verifyResultNumbers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexAll() throws InterruptedException {
        FullTextSession fullTextSession = this.builder.openFullTextSession();
        SilentProgressMonitor progressMonitor = new SilentProgressMonitor();
        junit.framework.Assert.assertFalse((boolean)progressMonitor.finished);
        try {
            fullTextSession.createIndexer(new Class[]{Object.class}).threadsForSubsequentFetching(8).threadsToLoadObjects(4).batchSizeToLoadObjects(30).progressMonitor((MassIndexerProgressMonitor)progressMonitor).startAndWait();
        }
        finally {
            fullTextSession.close();
        }
        junit.framework.Assert.assertTrue((boolean)progressMonitor.finished);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeAll() {
        FullTextSession fullTextSession = this.builder.openFullTextSession();
        try {
            Transaction tx = fullTextSession.beginTransaction();
            fullTextSession.purgeAll(Object.class);
            tx.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    private void verifyResultNumbers() {
        Assert.assertEquals((long)200L, (long)this.countByFT(Dvd.class));
        Assert.assertEquals((long)260L, (long)this.countByFT(Book.class));
        Assert.assertEquals((long)280L, (long)this.countByDatabaseCriteria(Book.class));
        Assert.assertEquals((long)20L, (long)this.countByDatabaseCriteria(SecretBook.class));
        Assert.assertEquals((long)120L, (long)this.countByFT(AncientBook.class));
        Assert.assertEquals((long)460L, (long)this.countByFT(AncientBook.class, Book.class, Dvd.class));
        Assert.assertEquals((long)320L, (long)this.countByFT(AncientBook.class, Dvd.class));
    }

    private void verifyIsEmpty() {
        Assert.assertEquals((long)0L, (long)this.countByFT(Dvd.class));
        Assert.assertEquals((long)0L, (long)this.countByFT(Book.class));
        Assert.assertEquals((long)0L, (long)this.countByFT(AncientBook.class));
        Assert.assertEquals((long)0L, (long)this.countByFT(AncientBook.class, Book.class, Dvd.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countByFT(Class<? extends TitleAble> ... types) {
        MatchAllDocsQuery findAll = new MatchAllDocsQuery();
        int bySize = 0;
        int byResultSize = 0;
        FullTextSession fullTextSession = this.builder.openFullTextSession();
        try {
            Transaction tx = fullTextSession.beginTransaction();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)findAll, (Class[])types);
            bySize = fullTextQuery.list().size();
            byResultSize = fullTextQuery.getResultSize();
            tx.commit();
        }
        finally {
            fullTextSession.close();
        }
        Assert.assertEquals((long)bySize, (long)byResultSize);
        return bySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countByDatabaseCriteria(Class<? extends TitleAble> type) {
        FullTextSession session = this.builder.openFullTextSession();
        try {
            Number countAsNumber = (Number)session.createCriteria(type).setProjection(Projections.rowCount()).uniqueResult();
            long l = countAsNumber.longValue();
            return l;
        }
        finally {
            session.close();
        }
    }

    private static class SilentProgressMonitor
    implements MassIndexerProgressMonitor {
        final AtomicLong objectsCounter = new AtomicLong();
        volatile boolean finished = false;

        private SilentProgressMonitor() {
        }

        public void documentsAdded(long increment) {
        }

        public void documentsBuilt(int number) {
        }

        public void entitiesLoaded(int size) {
        }

        public void addToTotalCount(long count) {
            this.objectsCounter.addAndGet(count);
        }

        public void indexingCompleted() {
            this.finished = true;
            log.debug((Object)("Finished indexing " + this.objectsCounter.get() + " entities"));
        }
    }
}

