/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.CriteriaObjectsInitializer;
import org.hibernate.search.query.hibernate.impl.Loader;
import org.hibernate.search.query.hibernate.impl.LookupObjectsInitializer;
import org.hibernate.search.query.hibernate.impl.MultiClassesQueryLoader;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;
import org.hibernate.search.query.hibernate.impl.PersistenceContextObjectsInitializer;
import org.hibernate.search.query.hibernate.impl.QueryLoader;
import org.hibernate.search.query.hibernate.impl.SecondLevelCacheObjectsInitializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ObjectLoaderBuilder {
    private Criteria criteria;
    private List<Class<?>> targetedEntities;
    private SessionImplementor session;
    private SearchFactoryImplementor searchFactoryImplementor;
    private Set<Class<?>> indexedTargetedEntities;
    private TimeoutManager timeoutManager;
    private ObjectLookupMethod lookupMethod;
    private DatabaseRetrievalMethod retrievalMethod;
    private static final Log log = LoggerFactory.make();

    public ObjectLoaderBuilder criteria(Criteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public ObjectLoaderBuilder targetedEntities(List<Class<?>> targetedEntities) {
        this.targetedEntities = targetedEntities;
        return this;
    }

    public ObjectLoaderBuilder lookupMethod(ObjectLookupMethod lookupMethod) {
        this.lookupMethod = lookupMethod;
        return this;
    }

    public ObjectLoaderBuilder retrievalMethod(DatabaseRetrievalMethod retrievalMethod) {
        this.retrievalMethod = retrievalMethod;
        return this;
    }

    public Loader buildLoader() {
        if (this.criteria != null) {
            return this.getCriteriaLoader();
        }
        if (this.targetedEntities.size() == 1) {
            return this.getSingleEntityLoader();
        }
        return this.getMultipleEntitiesLoader();
    }

    private Loader getMultipleEntitiesLoader() {
        MultiClassesQueryLoader multiClassesLoader = new MultiClassesQueryLoader();
        multiClassesLoader.init((Session)this.session, this.searchFactoryImplementor, this.getObjectInitializer(), this.timeoutManager);
        multiClassesLoader.setEntityTypes(this.indexedTargetedEntities);
        return multiClassesLoader;
    }

    private Loader getSingleEntityLoader() {
        QueryLoader queryLoader = new QueryLoader();
        queryLoader.init((Session)this.session, this.searchFactoryImplementor, this.getObjectInitializer(), this.timeoutManager);
        queryLoader.setEntityType(this.targetedEntities.iterator().next());
        return queryLoader;
    }

    private Loader getCriteriaLoader() {
        Class entityType;
        if (this.targetedEntities.size() > 1) {
            throw new SearchException("Cannot mix criteria and multiple entity types");
        }
        Class clazz = entityType = this.targetedEntities.size() == 0 ? null : this.targetedEntities.iterator().next();
        if (this.criteria instanceof CriteriaImpl) {
            String targetEntity = ((CriteriaImpl)this.criteria).getEntityOrClassName();
            if (entityType != null && !entityType.getName().equals(targetEntity)) {
                throw new SearchException("Criteria query entity should match query entity");
            }
            try {
                entityType = ReflectHelper.classForName((String)targetEntity);
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to load entity class from criteria: " + targetEntity, (Throwable)e);
            }
        }
        QueryLoader queryLoader = new QueryLoader();
        queryLoader.init((Session)this.session, this.searchFactoryImplementor, this.getObjectInitializer(), this.timeoutManager);
        queryLoader.setEntityType(entityType);
        queryLoader.setCriteria(this.criteria);
        return queryLoader;
    }

    public ObjectLoaderBuilder session(SessionImplementor session) {
        this.session = session;
        return this;
    }

    public ObjectLoaderBuilder searchFactory(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        return this;
    }

    public ObjectLoaderBuilder indexedTargetedEntities(Set<Class<?>> indexedTargetedEntities) {
        this.indexedTargetedEntities = indexedTargetedEntities;
        return this;
    }

    public ObjectLoaderBuilder timeoutManager(TimeoutManager timeoutManager) {
        this.timeoutManager = timeoutManager;
        return this;
    }

    private ObjectsInitializer getObjectInitializer() {
        log.tracef("ObjectsInitializer: Use lookup method %s and database retrieval method %s", (Object)this.lookupMethod, (Object)this.retrievalMethod);
        if (this.criteria != null && this.retrievalMethod != DatabaseRetrievalMethod.QUERY) {
            throw new SearchException("Cannot mix custom criteria query and " + DatabaseRetrievalMethod.class.getSimpleName() + "." + this.retrievalMethod);
        }
        if (this.retrievalMethod == DatabaseRetrievalMethod.FIND_BY_ID) {
            return LookupObjectsInitializer.INSTANCE;
        }
        if (this.retrievalMethod != DatabaseRetrievalMethod.QUERY) {
            throw new AssertionFailure("Unknown " + DatabaseRetrievalMethod.class.getSimpleName() + "." + this.retrievalMethod);
        }
        CriteriaObjectsInitializer initializer = CriteriaObjectsInitializer.INSTANCE;
        if (this.lookupMethod == ObjectLookupMethod.SKIP) {
            return initializer;
        }
        if (this.lookupMethod == ObjectLookupMethod.PERSISTENCE_CONTEXT) {
            return new PersistenceContextObjectsInitializer(initializer);
        }
        if (this.lookupMethod == ObjectLookupMethod.SECOND_LEVEL_CACHE) {
            return new PersistenceContextObjectsInitializer(new SecondLevelCacheObjectsInitializer(initializer));
        }
        throw new AssertionFailure("Unknown " + ObjectLookupMethod.class.getSimpleName() + "." + this.lookupMethod);
    }
}

