/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.test.directoryProvider.CustomLockFactoryProvider;
import org.hibernate.search.test.directoryProvider.SnowStorm;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Assert;
import org.junit.Test;

public class CustomLockProviderTest {
    @Test
    public void testUseOfCustomLockingFactory() {
        Assert.assertNull((Object)CustomLockFactoryProvider.optionValue);
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        builder.addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.locking_option", "somethingHere").setProperty("hibernate.search.default.locking_strategy", "org.hibernate.search.test.directoryProvider.CustomLockFactoryProvider").build();
        builder.close();
        Assert.assertEquals((Object)"somethingHere", (Object)CustomLockFactoryProvider.optionValue);
    }

    @Test
    public void testFailOnInexistentLockingFactory() {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        try {
            builder.addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.locking_option", "somethingHere").setProperty("hibernate.search.default.locking_strategy", "org.hibernate.NotExistingFactory").build();
            builder.close();
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertEquals((Object)"Unable to find locking_strategy implementation class: org.hibernate.NotExistingFactory", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testUseOfNativeLockingFactory() {
        this.testUseOfSelectedLockingFactory(null, NativeFSLockFactory.class, false);
        this.testUseOfSelectedLockingFactory("native", NativeFSLockFactory.class, false);
    }

    @Test
    public void testUseOfSingleLockingFactory() {
        this.testUseOfSelectedLockingFactory("single", SingleInstanceLockFactory.class, false);
        this.testUseOfSelectedLockingFactory("single", SingleInstanceLockFactory.class, true);
        this.testUseOfSelectedLockingFactory(null, SingleInstanceLockFactory.class, true);
    }

    @Test
    public void testUseOfSimpleLockingFactory() {
        this.testUseOfSelectedLockingFactory("simple", SimpleFSLockFactory.class, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUseOfSelectedLockingFactory(String optionName, Class expectedType, boolean useRamDirectory) {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        FullTextSessionBuilder fullTextSessionBuilder = builder.addAnnotatedClass(SnowStorm.class);
        if (optionName != null) {
            fullTextSessionBuilder.setProperty("hibernate.search.default.locking_strategy", optionName);
        }
        fullTextSessionBuilder.useRAMDirectoryProvider(useRamDirectory);
        FullTextSessionBuilder ftsb = fullTextSessionBuilder.build();
        try {
            SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)ftsb.getSearchFactory();
            EntityIndexBinder indexBindingForEntity = searchFactory.getIndexBindingForEntity(SnowStorm.class);
            DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBindingForEntity.getIndexManagers()[0];
            DirectoryProvider directoryProvider = indexManager.getDirectoryProvider();
            Directory directory = directoryProvider.getDirectory();
            LockFactory lockFactory = directory.getLockFactory();
            Assert.assertEquals((Object)expectedType, lockFactory.getClass());
        }
        finally {
            builder.close();
        }
        Assert.assertEquals((Object)"somethingHere", (Object)CustomLockFactoryProvider.optionValue);
    }
}

