/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.store.impl.FSDirectoryProvider;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.directoryProvider.SnowStorm;

public class FSDirectorySelectionTest
extends SearchTestCase {
    public void testMMapDirectoryType() {
        SessionFactory factory = this.createSessionFactoryUsingDirectoryType("mmap");
        this.assertCorrectDirectoryType(factory, MMapDirectory.class.getName());
    }

    public void testNIODirectoryType() {
        SessionFactory factory = this.createSessionFactoryUsingDirectoryType("nio");
        this.assertCorrectDirectoryType(factory, NIOFSDirectory.class.getName());
    }

    public void testSimpleDirectoryType() {
        SessionFactory factory = this.createSessionFactoryUsingDirectoryType("simple");
        this.assertCorrectDirectoryType(factory, SimpleFSDirectory.class.getName());
    }

    public void testInvalidDirectoryType() {
        try {
            this.createSessionFactoryUsingDirectoryType("foobar");
            FSDirectorySelectionTest.fail((String)"Factory creation should fail with invalid 'hibernate.search.default.filesystem_access_type' parameter ");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    private void assertCorrectDirectoryType(SessionFactory factory, String className) {
        Session session = factory.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        SearchFactoryIntegrator searchFactoryIntegrator = (SearchFactoryIntegrator)fullTextSession.getSearchFactory();
        EntityIndexBinder snowIndexBinder = searchFactoryIntegrator.getIndexBindingForEntity(SnowStorm.class);
        IndexManager[] indexManagers = snowIndexBinder.getIndexManagers();
        FSDirectorySelectionTest.assertTrue((String)"Wrong number of directory providers", (indexManagers.length == 1 ? 1 : 0) != 0);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
        Directory directory = indexManager.getDirectoryProvider().getDirectory();
        FSDirectorySelectionTest.assertEquals((String)"Wrong directory provider type", (String)className, (String)directory.getClass().getName());
        session.close();
    }

    private SessionFactory createSessionFactoryUsingDirectoryType(String directoryType) {
        Configuration config = new Configuration();
        config.addAnnotatedClass(SnowStorm.class);
        config.setProperty("hibernate.search.default.indexBase", this.getBaseIndexDir().getAbsolutePath());
        config.setProperty("hibernate.search.default.directory_provider", FSDirectoryProvider.class.getName());
        config.setProperty("hibernate.search.default.filesystem_access_type", directoryType);
        return config.buildSessionFactory();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[0];
    }
}

