/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Transient;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.test.engine.BusLine;

@Entity
public class BusStop {
    private Long id;
    private String roadName;
    private Set<BusLine> busses = new HashSet<BusLine>();
    private String serviceComments = "nothing";
    private Date startingDate = new Date();
    private transient int numMethodCalls = 0;

    @Id
    @GeneratedValue
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Field
    public String getRoadName() {
        return this.roadName;
    }

    public void setRoadName(String roadName) {
        this.roadName = roadName;
    }

    @ManyToMany(mappedBy="stops", cascade={CascadeType.ALL})
    @ContainedIn
    public Set<BusLine> getBusses() {
        return this.busses;
    }

    public void setBusses(Set<BusLine> busses) {
        this.busses = busses;
    }

    public String getServiceComments() {
        return this.serviceComments;
    }

    public void setServiceComments(String serviceComments) {
        this.serviceComments = serviceComments;
    }

    @Field
    public Date getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.roadName == null ? 0 : this.roadName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BusStop other = (BusStop)obj;
        return !(this.roadName == null ? other.roadName != null : !this.roadName.equals(other.roadName));
    }

    @Fields(value={@Field(name="strMultiple"), @Field})
    @Transient
    public String getTextTestField() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRoadName()).append(" ").append(this.getServiceComments()).append(" - ").append(this.getStartingDate());
        this.setNumMethodCalls(this.getNumMethodCalls() + 1);
        return sb.toString();
    }

    @Transient
    public int getNumMethodCalls() {
        return this.numMethodCalls;
    }

    public void setNumMethodCalls(int numMethodCalls) {
        this.numMethodCalls = numMethodCalls;
    }
}

