/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id.providedId;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.QueryTimeoutException;
import org.hibernate.search.query.engine.impl.DocumentExtractorImpl;
import org.hibernate.search.query.engine.impl.IndexSearcherWithPayload;
import org.hibernate.search.query.engine.impl.QueryHits;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.id.providedId.ProvidedIdPerson;
import org.hibernate.search.test.id.providedId.ProvidedIdPersonSub;
import org.hibernate.search.test.util.HibernateManualConfiguration;
import org.hibernate.search.test.util.ManualConfiguration;
import org.hibernate.search.test.util.ManualTransactionContext;
import org.junit.Assert;
import org.junit.Test;

public class ProvidedIdTest {
    @Test
    public void testProvidedId() throws Exception {
        ManualConfiguration configuration = new HibernateManualConfiguration().addClass(ProvidedIdPerson.class).addClass(ProvidedIdPersonSub.class).addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.search.analyzer", StopAnalyzer.class.getName()).addProperty("hibernate.search.default.indexwriter.merge_factor", "100").addProperty("hibernate.search.default.indexwriter.max_buffered_docs", "1000");
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        ProvidedIdPerson person1 = new ProvidedIdPerson();
        person1.setName("Big Goat");
        person1.setBlurb("Eats grass");
        ProvidedIdPerson person2 = new ProvidedIdPerson();
        person2.setName("Mini Goat");
        person2.setBlurb("Eats cheese");
        ProvidedIdPersonSub person3 = new ProvidedIdPersonSub();
        person3.setName("Regular goat");
        person3.setBlurb("Is anorexic");
        ManualTransactionContext tc = new ManualTransactionContext();
        Work work = new Work((Object)person1, (Serializable)Integer.valueOf(1), WorkType.INDEX);
        sf.getWorker().performWork(work, (TransactionContext)tc);
        work = new Work((Object)person2, (Serializable)Integer.valueOf(2), WorkType.INDEX);
        sf.getWorker().performWork(work, (TransactionContext)tc);
        Work work2 = new Work((Object)person3, (Serializable)Integer.valueOf(3), WorkType.INDEX);
        sf.getWorker().performWork(work2, (TransactionContext)tc);
        tc.end();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("Goat");
        IndexReader indexReader = sf.getIndexReaderAccessor().open(new Class[]{ProvidedIdPerson.class});
        IndexSearcher searcher = new IndexSearcher(indexReader);
        TopDocs hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)3L, (long)hits.totalHits);
        IndexSearcherWithPayload lowLevelSearcher = new IndexSearcherWithPayload(searcher, false, false);
        QueryHits queryHits = new QueryHits(lowLevelSearcher, luceneQuery, null, null, new TimeoutManagerImpl(luceneQuery, QueryTimeoutException.DEFAULT_TIMEOUT_EXCEPTION_FACTORY, sf.getTimingSource()), null, false, null, null);
        HashSet<String> identifiers = new HashSet<String>();
        identifiers.add("providedId");
        HashSet<Class> targetedClasses = new HashSet<Class>();
        targetedClasses.add(ProvidedIdPerson.class);
        targetedClasses.add(ProvidedIdPersonSub.class);
        DocumentExtractorImpl extractor = new DocumentExtractorImpl(queryHits, sf, new String[]{"name"}, identifiers, false, lowLevelSearcher, (Object)luceneQuery, 0, 0, targetedClasses);
        HashSet<String> titles = new HashSet<String>(3);
        for (int id = 0; id < hits.totalHits; ++id) {
            Long documentId = (Long)extractor.extract(id).getId();
            String projectedTitle = (String)extractor.extract(id).getProjection()[0];
            Assert.assertNotNull((Object)projectedTitle);
            titles.add(projectedTitle);
        }
        Assert.assertTrue((boolean)titles.contains("Regular goat"));
        Assert.assertTrue((boolean)titles.contains("Mini Goat"));
        Assert.assertTrue((boolean)titles.contains("Big Goat"));
        searcher.close();
        sf.getIndexReaderAccessor().close(indexReader);
    }
}

