/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.optimizations;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.store.optimization.OptimizerStrategy;

public class LeakingOptimizer
implements OptimizerStrategy {
    private static final AtomicLong totalOperations = new AtomicLong();

    public boolean performOptimization(IndexWriter writer) {
        return false;
    }

    public void addOperationWithinTransactionCount(long increment) {
        totalOperations.addAndGet(increment);
    }

    public void optimize(Workspace workspace) {
    }

    public void initialize(IndexManager indexManager, Properties indexProperties) {
    }

    public static long getTotalOperations() {
        return totalOperations.get();
    }

    public static void reset() {
        totalOperations.set(0L);
    }
}

