/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.interceptor;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.interceptor.Article;
import org.hibernate.search.test.interceptor.Blog;
import org.hibernate.search.test.interceptor.BlogStatus;
import org.hibernate.search.test.interceptor.TotalArticle;

public class IndexingActionInterceptorTest
extends SearchTestCase {
    public void testSoftDelete() throws Exception {
        Blog blog = new Blog();
        blog.setTitle("Hibernate Search now has soft deletes!");
        blog.setStatus(BlogStatus.DRAFT);
        Article article = new Article();
        article.setTitle("Hibernate Search: detailed description of soft deletes");
        article.setStatus(BlogStatus.DRAFT);
        TotalArticle totalArticle = new TotalArticle();
        totalArticle.setTitle("Hibernate Search: the total truth about soft deletes");
        totalArticle.setStatus(BlogStatus.DRAFT);
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)blog);
        s.persist((Object)article);
        s.persist((Object)totalArticle);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryBuilder b = s.getSearchFactory().buildQueryBuilder().forEntity(Blog.class).get();
        Query blogQuery = b.keyword().onField("title").matching((Object)"now").createQuery();
        Query articleQuery = b.keyword().onField("title").matching((Object)"detailed").createQuery();
        Query totalArticleQuery = b.keyword().onField("title").matching((Object)"truth").createQuery();
        ((ListAssert)Assertions.assertThat((List)s.createFullTextQuery(blogQuery, new Class[]{Blog.class}).list()).as("Blog is explicit intercepted")).hasSize(0);
        ((ListAssert)Assertions.assertThat((List)s.createFullTextQuery(articleQuery, new Class[]{Blog.class}).list()).as("Article is inherently intercepted")).hasSize(0);
        ((ListAssert)Assertions.assertThat((List)s.createFullTextQuery(totalArticleQuery, new Class[]{Blog.class}).list()).as("TotalArticle is explicit not intercepted")).hasSize(1);
        blog = (Blog)s.get(Blog.class, (Serializable)blog.getId());
        blog.setStatus(BlogStatus.PUBLISHED);
        article = (Article)s.get(Article.class, (Serializable)article.getId());
        article.setStatus(BlogStatus.PUBLISHED);
        totalArticle = (TotalArticle)s.get(TotalArticle.class, (Serializable)totalArticle.getId());
        totalArticle.setStatus(BlogStatus.PUBLISHED);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        Assertions.assertThat((List)s.createFullTextQuery(blogQuery, new Class[]{Blog.class}).list()).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)s.createFullTextQuery(articleQuery, new Class[]{Blog.class}).list()).as("Article is inherently intercepted")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)s.createFullTextQuery(totalArticleQuery, new Class[]{Blog.class}).list()).as("TotalArticle is explicit not intercepted")).hasSize(1);
        blog = (Blog)s.get(Blog.class, (Serializable)blog.getId());
        blog.setStatus(BlogStatus.REMOVED);
        article = (Article)s.get(Article.class, (Serializable)article.getId());
        article.setStatus(BlogStatus.REMOVED);
        totalArticle = (TotalArticle)s.get(TotalArticle.class, (Serializable)totalArticle.getId());
        totalArticle.setStatus(BlogStatus.REMOVED);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        Assertions.assertThat((List)s.createFullTextQuery(blogQuery, new Class[]{Blog.class}).list()).hasSize(0);
        ((ListAssert)Assertions.assertThat((List)s.createFullTextQuery(articleQuery, new Class[]{Blog.class}).list()).as("Article is inherently intercepted")).hasSize(0);
        ((ListAssert)Assertions.assertThat((List)s.createFullTextQuery(totalArticleQuery, new Class[]{Blog.class}).list()).as("TotalArticle is explicit not intercepted")).hasSize(1);
        blog = (Blog)s.get(Blog.class, (Serializable)blog.getId());
        s.delete((Object)blog);
        blog = (Blog)s.get(Article.class, (Serializable)article.getId());
        s.delete((Object)blog);
        blog = (Blog)s.get(TotalArticle.class, (Serializable)totalArticle.getId());
        s.delete((Object)blog);
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Blog.class, Article.class, TotalArticle.class};
    }
}

