/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.util.List;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Music;

public class QueryLoaderTest
extends SearchTestCase {
    public void testWithEagerCollectionLoad() throws Exception {
        Session sess = this.openSession();
        Transaction tx = sess.beginTransaction();
        Music music = new Music();
        music.setTitle("Moo Goes The Cow");
        Author author = new Author();
        author.setName("Moo Cow");
        music.addAuthor(author);
        sess.persist((Object)author);
        author = new Author();
        author.setName("Another Moo Cow");
        music.addAuthor(author);
        sess.persist((Object)author);
        author = new Author();
        author.setName("A Third Moo Cow");
        music.addAuthor(author);
        sess.persist((Object)author);
        author = new Author();
        author.setName("Random Moo Cow");
        music.addAuthor(author);
        sess.persist((Object)author);
        sess.save((Object)music);
        Music music2 = new Music();
        music2.setTitle("The Cow Goes Moo");
        author = new Author();
        author.setName("Moo Cow The First");
        music2.addAuthor(author);
        sess.persist((Object)author);
        author = new Author();
        author.setName("Moo Cow The Second");
        music2.addAuthor(author);
        sess.persist((Object)author);
        author = new Author();
        author.setName("Moo Cow The Third");
        music2.addAuthor(author);
        sess.persist((Object)author);
        author = new Author();
        author.setName("Moo Cow The Fourth");
        music2.addAuthor(author);
        sess.persist((Object)author);
        sess.save((Object)music2);
        tx.commit();
        sess.clear();
        FullTextSession s = Search.getFullTextSession((Session)sess);
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.keywordAnalyzer);
        Query query = parser.parse("title:moo");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Music.class});
        List result = hibQuery.list();
        QueryLoaderTest.assertEquals((String)"Should have returned 2 Books", (int)2, (int)result.size());
        music = (Music)result.get(0);
        QueryLoaderTest.assertEquals((String)"Book 1 should have four authors", (int)4, (int)music.getAuthors().size());
        music2 = (Music)result.get(1);
        QueryLoaderTest.assertEquals((String)"Book 2 should have four authors", (int)4, (int)music2.getAuthors().size());
        music.getAuthors().clear();
        music2.getAuthors().clear();
        for (Object o : s.createCriteria(Object.class).list()) {
            s.delete(o);
        }
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Author.class, Music.class};
    }
}

