/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.analysis.LowerCaseFilterFactory;
import org.apache.solr.analysis.NGramFilterFactory;
import org.apache.solr.analysis.SnowballPorterFilterFactory;
import org.apache.solr.analysis.StandardFilterFactory;
import org.apache.solr.analysis.StandardTokenizerFactory;
import org.apache.solr.analysis.StopFilterFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.RangeMatchingContext;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.query.dsl.Month;
import org.hibernate.testing.TestForIssue;

public class DSLTest
extends SearchTestCase {
    private final Calendar calendar = Calendar.getInstance();
    private FullTextSession fullTextSession;
    private Date january;
    private Date february;
    private Date march;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.indexTestData();
    }

    @Override
    public void tearDown() throws Exception {
        this.cleanUpTestData();
        super.tearDown();
    }

    public void testUseOfFieldBridge() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("monthValue").matching((Object)2).createQuery();
        DSLTest.assertEquals((int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = ((TermMatchingContext)monthQb.keyword().onField("monthValue").ignoreFieldBridge()).matching((Object)"2").createQuery();
        DSLTest.assertEquals((int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    public void testTermQueryOnAnalyzer() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("mythology").matching((Object)"cold").createQuery();
        DSLTest.assertEquals((int)0, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.keyword().onField("mythology").matching((Object)"colder darker").createQuery();
        DSLTest.assertEquals((int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.keyword().onField("mythology_stem").matching((Object)"snowboard").createQuery();
        DSLTest.assertEquals((int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.keyword().onField("mythology_ngram").matching((Object)"snobored").createQuery();
        DSLTest.assertEquals((int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = ((TermMatchingContext)monthQb.keyword().onField("mythology").ignoreAnalyzer()).matching((Object)"Month").createQuery();
        DSLTest.assertEquals((int)0, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    public void testFuzzyAndWildcardQuery() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().fuzzy().withThreshold(0.8f).withPrefixLength(1).onField("mythology").matching((Object)"calder").createQuery();
        DSLTest.assertEquals((int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.keyword().fuzzy().withThreshold(0.8f).withPrefixLength(1).onFields(new String[]{"mythology", "history"}).matching((Object)"showboarding").createQuery();
        DSLTest.assertEquals((int)2, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.keyword().wildcard().onField("mythology").matching((Object)"mon*").createQuery();
        DSLTest.assertEquals((int)3, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    public void testQueryCustomization() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.bool().should(monthQb.keyword().onField("mythology").matching((Object)"whitening").createQuery()).should(monthQb.keyword().onField("history").matching((Object)"whitening").createQuery()).createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((int)2, (int)results.size());
        DSLTest.assertEquals((String)"January", (String)((Month)results.get(0)).getName());
        query = monthQb.bool().should(monthQb.keyword().onField("mythology").matching((Object)"whitening").createQuery()).should(((TermMatchingContext)monthQb.keyword().onField("history").boostedTo(30.0f)).matching((Object)"whitening").createQuery()).createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((int)2, (int)results.size());
        DSLTest.assertEquals((String)"February", (String)((Month)results.get(0)).getName());
        transaction.commit();
    }

    public void testMultipleFields() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("mythology").andField("history").matching((Object)"whitening").createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((int)2, (int)results.size());
        DSLTest.assertEquals((String)"January", (String)((Month)results.get(0)).getName());
        query = ((TermMatchingContext)monthQb.keyword().onFields(new String[]{"mythology", "history"}).boostedTo(30.0f)).matching((Object)"whitening").createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((int)2, (int)results.size());
        DSLTest.assertEquals((String)"January", (String)((Month)results.get(0)).getName());
        query = ((TermMatchingContext)monthQb.keyword().onField("mythology").andField("history").boostedTo(30.0f)).matching((Object)"whitening").createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((int)2, (int)results.size());
        DSLTest.assertEquals((String)"February", (String)((Month)results.get(0)).getName());
        transaction.commit();
    }

    public void testBoolean() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.bool().must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((int)1, (int)results.size());
        DSLTest.assertEquals((String)"January", (String)((Month)results.get(0)).getName());
        query = monthQb.bool().should(monthQb.all().createQuery()).must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).not().createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((int)2, (int)results.size());
        DSLTest.assertEquals((String)"February", (String)((Month)results.get(0)).getName());
        DSLTest.assertEquals((String)"March", (String)((Month)results.get(1)).getName());
        query = monthQb.bool().must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).not().createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((int)2, (int)results.size());
        DSLTest.assertEquals((String)"February", (String)((Month)results.get(0)).getName());
        DSLTest.assertEquals((String)"March", (String)((Month)results.get(1)).getName());
        query = monthQb.all().except(new Query[]{monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()}).createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((int)2, (int)results.size());
        DSLTest.assertEquals((String)"February", (String)((Month)results.get(0)).getName());
        DSLTest.assertEquals((String)"March", (String)((Month)results.get(1)).getName());
        transaction.commit();
    }

    public void testRangeQueryFromTo() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1900, 2, 12, 0, 0, 0);
        Date from = this.calendar.getTime();
        this.calendar.set(1910, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).from((Object)from).to((Object)to).excludeLimit().createQuery();
        DSLTest.assertEquals((int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = ((RangeMatchingContext)((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").ignoreFieldBridge()).andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).from((Object)DateTools.dateToString((Date)from, (DateTools.Resolution)DateTools.Resolution.MINUTE)).to((Object)DateTools.dateToString((Date)to, (DateTools.Resolution)DateTools.Resolution.MINUTE)).excludeLimit().createQuery();
        DSLTest.assertEquals((int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    public void testRangeQueryBelow() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1810, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).below((Object)to).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        DSLTest.assertEquals((int)1, (int)hibQuery.getResultSize());
        DSLTest.assertEquals((String)"March", (String)((Month)hibQuery.list().get(0)).getName());
        query = ((RangeMatchingContext)((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").ignoreFieldBridge()).andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).below((Object)DateTools.dateToString((Date)to, (DateTools.Resolution)DateTools.Resolution.MINUTE)).createQuery();
        hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        DSLTest.assertEquals((int)1, (int)hibQuery.getResultSize());
        DSLTest.assertEquals((String)"March", (String)((Month)hibQuery.list().get(0)).getName());
        query = monthQb.range().onField("raindropInMm").below((Object)0.24).createQuery();
        DSLTest.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((String)"test range numeric ", (int)1, (int)results.size());
        DSLTest.assertEquals((String)"test range numeric ", (String)"January", (String)((Month)results.get(0)).getName());
        transaction.commit();
    }

    public void testRangeQueryAbove() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1910, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)to).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        DSLTest.assertEquals((int)1, (int)hibQuery.getResultSize());
        DSLTest.assertEquals((String)"February", (String)((Month)hibQuery.list().get(0)).getName());
        query = ((RangeMatchingContext)((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").ignoreFieldBridge()).andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)DateTools.dateToString((Date)to, (DateTools.Resolution)DateTools.Resolution.MINUTE)).createQuery();
        hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        DSLTest.assertEquals((int)1, (int)hibQuery.getResultSize());
        DSLTest.assertEquals((String)"February", (String)((Month)hibQuery.list().get(0)).getName());
        query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)this.february).createQuery();
        hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        DSLTest.assertEquals((int)1, (int)hibQuery.getResultSize());
        DSLTest.assertEquals((String)"February", (String)((Month)hibQuery.list().get(0)).getName());
        query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)this.february).excludeLimit().createQuery();
        hibQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        DSLTest.assertEquals((int)0, (int)hibQuery.getResultSize());
        transaction.commit();
    }

    public void testPhraseQuery() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.phrase().onField("mythology").sentence("colder and whitening").createQuery();
        DSLTest.assertEquals((String)"test exact phrase", (int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.phrase().onField("mythology").sentence("Month whitening").createQuery();
        DSLTest.assertEquals((String)"test slop", (int)0, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.phrase().withSlop(3).onField("mythology").sentence("Month whitening").createQuery();
        DSLTest.assertEquals((String)"test slop", (int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        query = monthQb.phrase().onField("mythology").sentence("whitening").createQuery();
        DSLTest.assertEquals((String)"test one term optimization", (int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    @TestForIssue(jiraKey="HSEARCH-1074")
    public void testPhraseQueryWithNoTermsAfterAnalyzerApplication() throws Exception {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.phrase().onField("mythology").sentence("and").createQuery();
        DSLTest.assertEquals((String)"there should be no results, since all terms are stop words", (int)0, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    public void testNumericRangeQueries() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.range().onField("raindropInMm").from((Object)0.23).to((Object)0.24).createQuery();
        DSLTest.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).list();
        DSLTest.assertEquals((String)"test range numeric ", (int)1, (int)results.size());
        DSLTest.assertEquals((String)"test range numeric ", (String)"January", (String)((Month)results.get(0)).getName());
        transaction.commit();
    }

    public void testNumericFieldsTermQuery() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("raindropInMm").matching((Object)0.231).createQuery();
        DSLTest.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        DSLTest.assertEquals((String)"test term numeric ", (int)1, (int)this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class}).getResultSize());
        transaction.commit();
    }

    public void testFieldBridge() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder monthQb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Month.class).get();
        Query query = monthQb.keyword().onField("monthRomanNumber").matching((Object)2).createQuery();
        FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Month.class});
        List results = fullTextQuery.list();
        DSLTest.assertEquals((int)1, (int)results.size());
        Month february = (Month)results.get(0);
        DSLTest.assertEquals((int)2, (int)february.getMonthValue());
        transaction.commit();
    }

    private void indexTestData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(1900, 2, 12, 0, 0, 0);
        this.january = calendar.getTime();
        this.fullTextSession.persist((Object)new Month("January", 1, "Month of colder and whitening", "Historically colder than any other month in the northern hemisphere", this.january, 0.231));
        calendar.set(2000, 2, 12, 0, 0, 0);
        this.february = calendar.getTime();
        this.fullTextSession.persist((Object)new Month("February", 2, "Month of snowboarding", "Historically, the month where we make babies while watching the whitening landscape", this.february, 0.435));
        calendar.set(1800, 2, 12, 0, 0, 0);
        this.march = calendar.getTime();
        this.fullTextSession.persist((Object)new Month("March", 3, "Month of fake spring", "Historically, the month in which we actually find time to go snowboarding.", this.march, 0.435));
        tx.commit();
        this.fullTextSession.clear();
    }

    private void cleanUpTestData() {
        if (!this.fullTextSession.isOpen()) {
            return;
        }
        Transaction tx = this.fullTextSession.getTransaction();
        if (tx.isActive()) {
            tx.commit();
        }
        tx = this.fullTextSession.beginTransaction();
        List results = this.fullTextSession.createQuery("from " + Month.class.getName()).list();
        DSLTest.assertEquals((int)3, (int)results.size());
        for (Month entity : results) {
            this.fullTextSession.delete((Object)entity);
        }
        tx.commit();
        this.fullTextSession.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Month.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.getProperties().put("hibernate.search.model_mapping", MappingFactory.class.getName());
    }

    public static class MappingFactory {
        @Factory
        public SearchMapping build() {
            SearchMapping mapping = new SearchMapping();
            mapping.analyzerDef("stemmer", StandardTokenizerFactory.class).filter(StandardFilterFactory.class).filter(LowerCaseFilterFactory.class).filter(StopFilterFactory.class).filter(SnowballPorterFilterFactory.class).param("language", "English").analyzerDef("ngram", StandardTokenizerFactory.class).filter(StandardFilterFactory.class).filter(LowerCaseFilterFactory.class).filter(StopFilterFactory.class).filter(NGramFilterFactory.class).param("minGramSize", "3").param("maxGramSize", "3");
            return mapping;
        }
    }
}

