/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.worker;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.worker.Employee;
import org.hibernate.search.test.worker.Employer;

public class WorkerTestCase
extends SearchTestCase {
    private final AtomicBoolean allFine = new AtomicBoolean(true);

    public void testConcurrency() throws Exception {
        int nThreads = 15;
        ExecutorService es = Executors.newFixedThreadPool(nThreads);
        Work work = new Work(this.getSessions());
        ReverseWork reverseWork = new ReverseWork(this.getSessions());
        long start = System.nanoTime();
        int iteration = 100;
        for (int i = 0; i < iteration; ++i) {
            es.execute(work);
            es.execute(reverseWork);
        }
        es.shutdown();
        es.awaitTermination(100L, TimeUnit.MINUTES);
        this.getSessions().close();
        Assert.assertTrue((String)"Something was wrong in the concurrent threads, please check logs for stacktraces", (boolean)this.allFine.get());
        System.out.println(iteration + " iterations (8 tx per iteration) in " + nThreads + " threads: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        File sub = this.getBaseIndexDir();
        cfg.setProperty("hibernate.search.default.indexBase", sub.getAbsolutePath());
        cfg.setProperty("hibernate.search.Clock.directory_provider", "filesystem");
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        cfg.setProperty("hibernate.show_sql", "false");
        cfg.setProperty("hibernate.format_sql", "false");
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Employee.class, Employer.class};
    }

    protected boolean isWorkerSync() {
        return true;
    }

    protected class ReverseWork
    implements Runnable {
        private SessionFactory sf;

        public ReverseWork(SessionFactory sf) {
            this.sf = sf;
        }

        @Override
        public void run() {
            try {
                Session s = this.sf.openSession();
                Transaction tx = s.beginTransaction();
                Employer er = new Employer();
                er.setName("RH");
                s.persist((Object)er);
                Employee ee = new Employee();
                ee.setName("Emmanuel");
                s.persist((Object)ee);
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                er.setName("RH2");
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                ee.setName("Emmanuel2");
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                s.delete((Object)er);
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                s.delete((Object)ee);
                tx.commit();
                s.close();
            }
            catch (Throwable t) {
                WorkerTestCase.this.allFine.set(false);
                t.printStackTrace();
            }
        }
    }

    protected class Work
    implements Runnable {
        private SessionFactory sf;

        public Work(SessionFactory sf) {
            this.sf = sf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Session s = null;
            Transaction tx = null;
            try {
                boolean results;
                Query query;
                s = this.sf.openSession();
                tx = s.beginTransaction();
                Employer er = new Employer();
                er.setName("RH");
                s.persist((Object)er);
                Employee ee = new Employee();
                ee.setName("Emmanuel");
                s.persist((Object)ee);
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                ee.setName("Emmanuel2");
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                er.setName("RH2");
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
                try {
                    query = parser.parse("name:emmanuel2");
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                boolean bl = results = Search.getFullTextSession((Session)s).createFullTextQuery(query, new Class[0]).list().size() > 0;
                if (WorkerTestCase.this.isWorkerSync()) {
                    Assert.assertTrue((boolean)results);
                }
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                s.delete((Object)er);
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                s.delete((Object)ee);
                tx.commit();
                s.close();
            }
            catch (Throwable t) {
                WorkerTestCase.this.allFine.set(false);
                t.printStackTrace();
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    if (s != null && s.isOpen()) {
                        s.close();
                    }
                }
                catch (Throwable t) {
                    WorkerTestCase.this.allFine.set(false);
                    t.printStackTrace();
                }
            }
        }
    }
}

