/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Collection;
import java.util.Map;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.search.engine.impl.HibernateStatelessInitializer;
import org.hibernate.search.spi.InstanceInitializer;

public class HibernateSessionLoadingInitializer
extends HibernateStatelessInitializer
implements InstanceInitializer {
    private final SessionImplementor hibernateSession;

    public HibernateSessionLoadingInitializer(SessionImplementor hibernateSession) {
        this.hibernateSession = hibernateSession;
    }

    @Override
    public Object unproxy(Object instance) {
        HibernateProxy proxy;
        LazyInitializer lazyInitializer;
        Object initialized;
        if (instance instanceof HibernateProxy && (initialized = (lazyInitializer = (proxy = (HibernateProxy)instance).getHibernateLazyInitializer()).getImplementation(this.hibernateSession)) == null) {
            return this.hibernateSession.getPersistenceContext().unproxyAndReassociate((Object)proxy);
        }
        return instance;
    }

    @Override
    public <T> Collection<T> initializeCollection(Collection<T> value) {
        if (value instanceof PersistentCollection) {
            this.preparePersistentCollection((PersistentCollection)value);
        }
        return value;
    }

    @Override
    public <K, V> Map<K, V> initializeMap(Map<K, V> value) {
        if (value instanceof PersistentCollection) {
            this.preparePersistentCollection((PersistentCollection)value);
        }
        return value;
    }

    private void preparePersistentCollection(PersistentCollection value) {
        if (value.setCurrentSession(this.hibernateSession)) {
            String role = value.getRole();
            CollectionPersister collectionPersister = this.hibernateSession.getFactory().getCollectionPersister(role);
            this.hibernateSession.getPersistenceContext().addInitializedDetachedCollection(collectionPersister, value);
        }
    }
}

