/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.id.Person;
import org.hibernate.search.test.id.PersonPK;

public class EmbeddedIdTest
extends SearchTestCase {
    public void testFieldBridge() throws Exception {
        PersonPK emmanuelPk = new PersonPK();
        emmanuelPk.setFirstName("Emmanuel");
        emmanuelPk.setLastName("Bernard");
        Person emmanuel = new Person();
        emmanuel.setFavoriteColor("Blue");
        emmanuel.setId(emmanuelPk);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.save((Object)emmanuel);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        List results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)new TermQuery(new Term("id.lastName", "Bernard")), new Class[0]).list();
        EmbeddedIdTest.assertEquals((int)1, (int)results.size());
        emmanuel = (Person)results.get(0);
        emmanuel.setFavoriteColor("Red");
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)new TermQuery(new Term("id.lastName", "Bernard")), new Class[0]).list();
        EmbeddedIdTest.assertEquals((int)1, (int)results.size());
        emmanuel = (Person)results.get(0);
        EmbeddedIdTest.assertEquals((String)"Red", (String)emmanuel.getFavoriteColor());
        s.delete(results.get(0));
        tx.commit();
        s.close();
    }

    public void testSafeFromTupleId() throws Exception {
        PersonPK emmanuelPk = new PersonPK();
        emmanuelPk.setFirstName("Emmanuel");
        emmanuelPk.setLastName("Bernard");
        Person emmanuel = new Person();
        emmanuel.setFavoriteColor("Blue");
        emmanuel.setId(emmanuelPk);
        PersonPK johnPk = new PersonPK();
        johnPk.setFirstName("John");
        johnPk.setLastName("Doe");
        Person john = new Person();
        john.setFavoriteColor("Blue");
        john.setId(johnPk);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.save((Object)emmanuel);
        s.save((Object)john);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        List results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)new TermQuery(new Term("favoriteColor", "blue")), new Class[0]).list();
        EmbeddedIdTest.assertEquals((int)2, (int)results.size());
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Person.class};
    }
}

