/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.service;

import org.hibernate.search.SearchException;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.service.MyServiceProvider;
import org.hibernate.search.test.service.NoServiceDirectoryProvider;
import org.hibernate.search.test.service.ProvidedService;
import org.hibernate.search.test.service.ProvidedServiceDirectoryProvider;
import org.hibernate.search.test.service.ProvidedServiceProvider;
import org.hibernate.search.test.service.ServiceDirectoryProvider;
import org.hibernate.search.test.service.Telephone;
import org.hibernate.search.test.util.HibernateManualConfiguration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ServiceProviderTest {
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void testManagedService() throws Exception {
        MyServiceProvider.resetActive();
        Assert.assertFalse((boolean)MyServiceProvider.isActive());
        HibernateManualConfiguration configuration = new HibernateManualConfiguration();
        configuration.addProperty("hibernate.search.default.directory_provider", ServiceDirectoryProvider.class.getName()).addClass(Telephone.class);
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        Assert.assertTrue((boolean)MyServiceProvider.isActive());
        sf.close();
        Assert.assertFalse((boolean)MyServiceProvider.isActive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCircularDependenciesNotAllowed() throws Exception {
        MyServiceProvider.resetActive();
        Assert.assertFalse((boolean)MyServiceProvider.isActive());
        HibernateManualConfiguration configuration = new HibernateManualConfiguration();
        configuration.addProperty("hibernate.search.default.directory_provider", ServiceDirectoryProvider.class.getName()).addClass(Telephone.class);
        this.exceptions.expect(SearchException.class);
        MyServiceProvider.setSimulateCircularDependency(true);
        SearchFactoryImplementor sf = null;
        try {
            sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        }
        finally {
            MyServiceProvider.setSimulateCircularDependency(false);
            if (sf != null) {
                sf.close();
            }
        }
    }

    @Test
    public void testProvidedService() throws Exception {
        ProvidedServiceProvider.resetActive();
        Assert.assertFalse((boolean)ProvidedServiceProvider.isActive());
        HibernateManualConfiguration configuration = new HibernateManualConfiguration();
        configuration.addProperty("hibernate.search.default.directory_provider", ProvidedServiceDirectoryProvider.class.getName()).addClass(Telephone.class).getProvidedServices().put(ProvidedServiceProvider.class, new ProvidedService(true));
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        Assert.assertFalse((boolean)ProvidedServiceProvider.isActive());
        sf.close();
        Assert.assertFalse((boolean)ProvidedServiceProvider.isActive());
    }

    @Test
    public void testServiceNotFound() throws Exception {
        HibernateManualConfiguration configuration = new HibernateManualConfiguration();
        configuration.addProperty("hibernate.search.default.directory_provider", NoServiceDirectoryProvider.class.getName()).addClass(Telephone.class);
        boolean exception = false;
        try {
            SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        }
        catch (SearchException e) {
            exception = true;
        }
        Assert.assertTrue((String)"Service not found should raise a SearchException", (boolean)exception);
    }
}

