/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import junit.framework.Assert;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.jgroups.common.MultipleSessionsSearchTestCase;
import org.hibernate.search.test.jgroups.master.TShirt;

public class JGroupsCommonTest
extends MultipleSessionsSearchTestCase {
    public static final String TESTING_JGROUPS_CONFIGURATION_FILE = "testing-flush-loopback.xml";
    public static final long NETWORK_WAIT_MILLISECONDS = 100L;
    public static final int MAX_WAITS = 100;
    public static final String CHANNEL_NAME = UUID.randomUUID().toString();

    public void testJGroupsBackend() throws Exception {
        List result;
        FullTextQuery query;
        Query luceneQuery;
        int i;
        Session slaveSession = this.getSlaveSession();
        Transaction tx = slaveSession.beginTransaction();
        TShirt ts = new TShirt();
        ts.setLogo("Boston");
        ts.setSize("XXL");
        ts.setLength(23.4);
        TShirt ts2 = new TShirt();
        ts2.setLogo("Mapple leaves");
        ts2.setSize("L");
        ts2.setLength(23.42);
        slaveSession.persist((Object)ts);
        slaveSession.persist((Object)ts2);
        tx.commit();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        FullTextSession masterSession = Search.getFullTextSession((Session)this.openSession());
        boolean failed = true;
        for (i = 0; i < 100; ++i) {
            Thread.sleep(100L);
            masterSession.getTransaction().begin();
            luceneQuery = parser.parse("logo:Boston or logo:Mapple leaves");
            query = masterSession.createFullTextQuery(luceneQuery, new Class[0]);
            result = query.list();
            masterSession.getTransaction().commit();
            if (result.size() != 2) continue;
            failed = false;
            break;
        }
        if (failed) {
            Assert.fail((String)"Lots of time waited and still the two documents are not indexed yet!");
        }
        slaveSession = this.getSlaveSession();
        tx = slaveSession.beginTransaction();
        ts = (TShirt)slaveSession.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId()));
        ts.setLogo("Peter pan");
        tx.commit();
        failed = true;
        for (i = 0; i < 100; ++i) {
            Thread.sleep(100L);
            luceneQuery = parser.parse("logo:Peter pan");
            masterSession.getTransaction().begin();
            query = masterSession.createFullTextQuery(luceneQuery, new Class[0]);
            result = query.list();
            masterSession.getTransaction().commit();
            if (result.size() != 1) continue;
            failed = false;
            break;
        }
        if (failed) {
            Assert.fail((String)"Waited for long and still Peter Pan didn't fly in!");
        }
        slaveSession = this.getSlaveSession();
        tx = slaveSession.beginTransaction();
        slaveSession.delete(slaveSession.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId())));
        slaveSession.delete(slaveSession.get(TShirt.class, (Serializable)Integer.valueOf(ts2.getId())));
        tx.commit();
        failed = true;
        for (i = 0; i < 100; ++i) {
            Thread.sleep(100L);
            luceneQuery = parser.parse("logo:Boston or logo:Mapple leaves");
            masterSession.getTransaction().begin();
            query = masterSession.createFullTextQuery(luceneQuery, new Class[0]);
            result = query.list();
            masterSession.getTransaction().commit();
            if (result.size() != 0) continue;
            failed = false;
            break;
        }
        if (failed) {
            Assert.fail((String)"Waited for long and elements where still not deleted!");
        }
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", "jgroupsMaster");
        this.applyJGroupsChannelConfiguration(cfg);
    }

    @Override
    protected void commonConfigure(Configuration cfg) {
        super.commonConfigure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", "jgroupsSlave");
        this.applyJGroupsChannelConfiguration(cfg);
    }

    protected void applyJGroupsChannelConfiguration(Configuration cfg) {
        cfg.setProperty("hibernate.search.default.hibernate.search.services.jgroups.clusterName", CHANNEL_NAME);
        cfg.setProperty("hibernate.search.default.hibernate.search.services.jgroups.configurationFile", TESTING_JGROUPS_CONFIGURATION_FILE);
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }

    @Override
    protected Class<?>[] getCommonAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }
}

