/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jmx;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.jmx.Counter;
import org.osjava.sj.memory.MemoryContext;

public class IndexControlMBeanTest
extends SearchTestCase {
    MBeanServer mbeanServer;
    ObjectName statisticsBeanObjectName;
    ObjectName indexBeanObjectName;

    public void testIndexCtrlMBeanRegistered() throws Exception {
        IndexControlMBeanTest.assertTrue((String)"With the right property set the Search MBean should be registered", (boolean)this.mbeanServer.isRegistered(this.indexBeanObjectName));
    }

    public void testAttributesAndOperations() throws Exception {
        MBeanInfo info = this.mbeanServer.getMBeanInfo(this.indexBeanObjectName);
        MBeanAttributeInfo[] attributes = info.getAttributes();
        IndexControlMBeanTest.assertEquals((String)"Wrong number of attributes", (int)3, (int)attributes.length);
        HashSet<String> attributeNames = new HashSet<String>();
        attributeNames.add("NumberOfObjectLoadingThreads");
        attributeNames.add("NumberOfFetchingThreads");
        attributeNames.add("BatchSize");
        for (MBeanAttributeInfo attribute : attributes) {
            IndexControlMBeanTest.assertTrue((boolean)attributeNames.contains(attribute.getName()));
        }
        MBeanOperationInfo[] operations = info.getOperations();
        IndexControlMBeanTest.assertEquals((String)"Wrong number of operations", (int)3, (int)operations.length);
        HashSet<String> operationNames = new HashSet<String>();
        operationNames.add("index");
        operationNames.add("purge");
        operationNames.add("optimize");
        for (MBeanOperationInfo operation : operations) {
            IndexControlMBeanTest.assertTrue((boolean)operationNames.contains(operation.getName()));
        }
    }

    public void testIndexAndPurge() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Counter counter = new Counter();
        s.save((Object)counter);
        tx.commit();
        s.close();
        this.assertNumberOfIndexedEntities(Counter.class.getName(), 0);
        this.mbeanServer.invoke(this.indexBeanObjectName, "index", new String[]{Counter.class.getName()}, new String[]{String.class.getName()});
        this.assertNumberOfIndexedEntities(Counter.class.getName(), 1);
        this.mbeanServer.invoke(this.indexBeanObjectName, "purge", new String[]{Counter.class.getName()}, new String[]{String.class.getName()});
        this.assertNumberOfIndexedEntities(Counter.class.getName(), 0);
    }

    @Override
    public void setUp() throws Exception {
        this.setCfg(null);
        super.setUp();
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.statisticsBeanObjectName = new ObjectName("org.hibernate.search.jmx:type=StatisticsInfoMBean");
        this.indexBeanObjectName = new ObjectName("org.hibernate.search.jmx:type=IndexControlMBean");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.mbeanServer.isRegistered(this.statisticsBeanObjectName)) {
            this.mbeanServer.unregisterMBean(this.statisticsBeanObjectName);
        }
        if (this.mbeanServer.isRegistered(this.indexBeanObjectName)) {
            this.mbeanServer.unregisterMBean(this.indexBeanObjectName);
        }
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        File targetDir = TestConstants.getTargetDir(IndexControlMBeanTest.class);
        File simpleJndiDir = new File(targetDir, "simpleJndi");
        simpleJndiDir.mkdir();
        cfg.setProperty("hibernate.session_factory_name", "java:comp/SessionFactory");
        cfg.setProperty("hibernate.jndi.class", "org.osjava.sj.SimpleContextFactory");
        cfg.setProperty("hibernate.jndi.org.osjava.sj.factory", "org.hibernate.search.test.jmx.IndexControlMBeanTest$CustomContextFactory");
        cfg.setProperty("hibernate.jndi.org.osjava.sj.root", simpleJndiDir.getAbsolutePath());
        cfg.setProperty("hibernate.jndi.org.osjava.sj.jndi.shared", "true");
        cfg.setProperty("hibernate.search.indexing_strategy", "manual");
        cfg.setProperty("hibernate.search.jmx_enabled", "true");
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Counter.class};
    }

    private void assertNumberOfIndexedEntities(String entity, int count) throws InstanceNotFoundException, MBeanException, ReflectionException {
        IndexControlMBeanTest.assertEquals((String)"wrong number of indexed entities", (Object)count, (Object)this.mbeanServer.invoke(this.statisticsBeanObjectName, "getNumberOfIndexedEntities", new String[]{entity}, new String[]{String.class.getName()}));
    }

    public static class CloseNoOpMemoryContext
    extends MemoryContext {
        public CloseNoOpMemoryContext(Hashtable env) {
            super(env);
        }

        public void close() {
        }
    }

    public static class CustomContextFactory
    implements InitialContextFactory {
        public Context getInitialContext(Hashtable environment) throws NamingException {
            return new CloseNoOpMemoryContext(environment);
        }
    }
}

