/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.query.Music;

public class MultiClassesQueryLoaderTest
extends SearchTestCase {
    public void testObjectNotFound() throws Exception {
        Session sess = this.openSession();
        Transaction tx = sess.beginTransaction();
        Author author = new Author();
        author.setName("Moo Cow");
        sess.persist((Object)author);
        tx.commit();
        sess.clear();
        sess.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                Statement statement = connection.createStatement();
                statement.executeUpdate("DELETE FROM Author");
                statement.close();
            }
        });
        FullTextSession s = Search.getFullTextSession((Session)sess);
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.keywordAnalyzer);
        Query query = parser.parse("name:moo");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Author.class, Music.class});
        List result = hibQuery.list();
        MultiClassesQueryLoaderTest.assertEquals((String)"Should have returned no author", (int)0, (int)result.size());
        tx.commit();
        s.close();
    }

    public void testObjectTypeFiltering() throws Exception {
        Session sess = this.openSession();
        Transaction tx = sess.beginTransaction();
        Author author = new Author();
        author.setName("Moo Cow");
        Music music = new Music();
        music.addAuthor(author);
        music.setTitle("The moo moo mooing under the stars");
        Book book = new Book();
        book.setBody("This is the story of the Moo Cow, who sang the moo moo moo at night");
        book.setId(1);
        sess.persist((Object)book);
        sess.persist((Object)author);
        sess.persist((Object)music);
        tx.commit();
        sess.clear();
        FullTextSession s = Search.getFullTextSession((Session)sess);
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.keywordAnalyzer);
        Query query = parser.parse("name:moo OR title:moo OR body:moo");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Music.class});
        List result = hibQuery.list();
        MultiClassesQueryLoaderTest.assertEquals((String)"Should match the music only", (int)1, (int)result.size());
        hibQuery = s.createFullTextQuery(query, new Class[]{Author.class, Music.class});
        result = hibQuery.list();
        MultiClassesQueryLoaderTest.assertEquals((String)"Should match the author and music only", (int)2, (int)result.size());
        hibQuery = s.createFullTextQuery(query, new Class[]{Author.class, Music.class, Book.class});
        result = hibQuery.list();
        MultiClassesQueryLoaderTest.assertEquals((String)"Should match the author, music and book", (int)3, (int)result.size());
        hibQuery = s.createFullTextQuery(query, new Class[0]);
        result = hibQuery.list();
        MultiClassesQueryLoaderTest.assertEquals((String)"Should match all types", (int)3, (int)result.size());
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Author.class, Music.class, Book.class};
    }
}

