/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.store.Directory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jdbc.Work;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.TestResourceManager;
import org.hibernate.search.util.impl.ContextHelper;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class DefaultTestResourceManager
implements TestResourceManager {
    private static final Log log = LoggerFactory.make();
    private final Class<?>[] annotatedClasses;
    private final File baseIndexDir;
    private Configuration cfg;
    private SessionFactory sessionFactory;
    private Session session;
    private SearchFactoryImplementor searchFactory;
    private boolean needsConfigurationRebuild;

    public DefaultTestResourceManager(Class<?>[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
        this.cfg = new Configuration();
        this.baseIndexDir = this.createBaseIndexDir();
        this.needsConfigurationRebuild = true;
    }

    @Override
    public void openSessionFactory() {
        if (this.sessionFactory == null) {
            if (this.cfg == null) {
                throw new IllegalStateException("configuration was not built");
            }
        } else {
            throw new IllegalStateException("there should be no SessionFactory initialized at this point");
        }
        this.setSessionFactory(this.cfg.buildSessionFactory());
    }

    @Override
    public void closeSessionFactory() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("there is no SessionFactory to close");
        }
        this.sessionFactory.close();
        this.sessionFactory = null;
    }

    @Override
    public Configuration getCfg() {
        return this.cfg;
    }

    @Override
    public Session openSession() throws HibernateException {
        this.session = this.getSessionFactory().openSession();
        return this.session;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public SessionFactory getSessionFactory() {
        if (this.cfg == null) {
            throw new IllegalStateException("Configuration should be already defined at this point");
        }
        if (this.sessionFactory == null) {
            throw new IllegalStateException("SessionFactory should be already defined at this point");
        }
        return this.sessionFactory;
    }

    @Override
    public Directory getDirectory(Class<?> clazz) {
        SearchFactoryImplementor searchFactoryBySFI = ContextHelper.getSearchFactoryBySFI((SessionFactoryImplementor)((SessionFactoryImplementor)this.sessionFactory));
        IndexManager[] indexManagers = searchFactoryBySFI.getIndexBinding(clazz).getIndexManagers();
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
        return indexManager.getDirectoryProvider().getDirectory();
    }

    @Override
    public void ensureIndexesAreEmpty() {
        if ("jms".equals(this.getCfg().getProperty("hibernate.search.worker.backend"))) {
            log.debug((Object)"JMS based test. Skipping index emptying");
            return;
        }
        FileHelper.delete((File)this.getBaseIndexDir());
    }

    @Override
    public SearchFactory getSearchFactory() {
        if (this.searchFactory == null) {
            Session session = this.openSession();
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            this.searchFactory = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
            fullTextSession.close();
        }
        return this.searchFactory;
    }

    @Override
    public SearchFactoryImplementor getSearchFactoryImpl() {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.close();
        SearchFactory searchFactory = s.getSearchFactory();
        return (SearchFactoryImplementor)searchFactory;
    }

    @Override
    public File getBaseIndexDir() {
        return this.baseIndexDir;
    }

    @Override
    public void forceConfigurationRebuild() {
        this.needsConfigurationRebuild = true;
        this.cfg = new Configuration();
    }

    @Override
    public boolean needsConfigurationRebuild() {
        return this.needsConfigurationRebuild;
    }

    public void defaultTearDown() throws Exception {
        this.handleUnclosedResources();
        this.closeSessionFactory();
        this.ensureIndexesAreEmpty();
    }

    public void applyDefaultConfiguration(Configuration cfg) {
        cfg.setProperty("hibernate.search.lucene_version", TestConstants.getTargetLuceneVersion().name());
        cfg.setProperty("hibernate.search.default.directory_provider", "ram");
        cfg.setProperty("hibernate.search.default.indexBase", this.getBaseIndexDir().getAbsolutePath());
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        cfg.setProperty("hibernate.search.default.indexwriter.merge_factor", "100");
        cfg.setProperty("hibernate.search.default.indexwriter.max_buffered_docs", "1000");
        cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
    }

    public void handleUnclosedResources() {
        if (this.session != null && this.session.isOpen()) {
            if (this.session.isConnected()) {
                this.session.doWork((Work)new RollbackWork());
            }
            this.session.close();
            this.session = null;
            log.debug((Object)"Closing open session. Make sure to close sessions explicitly in your tests!");
        } else {
            this.session = null;
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void buildConfiguration() {
        try {
            for (Class<?> aClass : this.annotatedClasses) {
                this.getCfg().addAnnotatedClass(aClass);
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw e;
        }
        catch (SearchException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.needsConfigurationRebuild = false;
    }

    private File createBaseIndexDir() {
        String shortTestName = this.getClass().getSimpleName() + "-" + UUID.randomUUID().toString().substring(0, 8);
        return new File(TestConstants.getIndexDirectory(this.getClass()), shortTestName);
    }

    private static class RollbackWork
    implements Work {
        private RollbackWork() {
        }

        public void execute(Connection connection) throws SQLException {
            connection.rollback();
        }
    }
}

