/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.search.FullTextSession;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.impl.NRTIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.configuration.BlogEntry;
import org.hibernate.search.test.perf.Boat;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.test.util.RamIndexManager;
import org.junit.Assert;
import org.junit.Test;

public class IndexManagerOverrideTest {
    @Test
    public void verifyIndexExclusivity() {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        FullTextSession ftSession = builder.setProperty("hibernate.search.Book.indexmanager", "near-real-time").setProperty("hibernate.search.org.hibernate.search.test.perf.Boat.indexmanager", "org.hibernate.search.test.util.RamIndexManager").addAnnotatedClass(BlogEntry.class).addAnnotatedClass(Boat.class).addAnnotatedClass(Book.class).addAnnotatedClass(Author.class).openFullTextSession();
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)ftSession.getSearchFactory();
        ftSession.close();
        IndexManagerHolder allIndexesManager = searchFactory.getIndexManagerHolder();
        this.checkIndexManagerType(allIndexesManager, "org.hibernate.search.test.configuration.BlogEntry", DirectoryBasedIndexManager.class);
        this.checkIndexManagerType(allIndexesManager, "Book", NRTIndexManager.class);
        this.checkIndexManagerType(allIndexesManager, "org.hibernate.search.test.perf.Boat", RamIndexManager.class);
        builder.close();
    }

    private void checkIndexManagerType(IndexManagerHolder allIndexesManager, String name, Class expectedType) {
        IndexManager indexManager = allIndexesManager.getIndexManager(name);
        Assert.assertEquals((Object)expectedType, indexManager.getClass());
    }
}

