/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.query.AlternateBook;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.query.Clock;
import org.hibernate.search.test.query.Employee;

public class PurgeTest
extends SearchTestCase {
    public void testPurge() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Clock clock = new Clock(1, "Seiko");
        s.save((Object)clock);
        clock = new Clock(2, "Festina");
        s.save((Object)clock);
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        s.save((Object)book);
        book = new Book(2, "La gloire de mon p\u00e8re", "Les deboires de mon p\u00e8re en v\u00e9lo");
        s.save((Object)book);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "brand", TestConstants.stopAnalyzer);
        Query query = parser.parse("brand:Seiko");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        List results = hibQuery.list();
        PurgeTest.assertEquals((String)"incorrect test record", (int)1, (int)results.size());
        PurgeTest.assertEquals((String)"incorrect test record", (int)1, (int)((Clock)results.get(0)).getId());
        s.purge(Clock.class, (Serializable)((Clock)results.get(0)).getId());
        tx.commit();
        tx = s.beginTransaction();
        query = parser.parse("brand:Festina or brand:Seiko");
        hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        results = hibQuery.list();
        PurgeTest.assertEquals((String)"incorrect test record count", (int)1, (int)results.size());
        PurgeTest.assertEquals((String)"incorrect test record", (int)2, (int)((Clock)results.get(0)).getId());
        for (Object element : s.createQuery("from java.lang.Object").list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testPurgeAll() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Clock clock = new Clock(1, "Seiko");
        s.save((Object)clock);
        clock = new Clock(2, "Festina");
        s.save((Object)clock);
        clock = new Clock(3, "Longine");
        s.save((Object)clock);
        clock = new Clock(4, "Rolex");
        s.save((Object)clock);
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        s.save((Object)book);
        book = new Book(2, "La gloire de mon p\u00e8re", "Les deboires de mon p\u00e8re en v\u00e9lo");
        s.save((Object)book);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "brand", TestConstants.stopAnalyzer);
        s.purgeAll(Clock.class);
        tx.commit();
        tx = s.beginTransaction();
        Query query = parser.parse("brand:Festina or brand:Seiko or brand:Longine or brand:Rolex");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        List results = hibQuery.list();
        PurgeTest.assertEquals((String)"class not completely purged", (int)0, (int)results.size());
        query = parser.parse("summary:Festina or summary:gloire");
        hibQuery = s.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        results = hibQuery.list();
        PurgeTest.assertEquals((String)"incorrect class purged", (int)2, (int)results.size());
        for (Object element : s.createQuery("from java.lang.Object").list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, AlternateBook.class, Clock.class, Author.class, Employee.class};
    }
}

