/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.IOException;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.backend.configuration.impl.IndexWriterSetting;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SerializationTestHelper;
import org.hibernate.search.test.configuration.ConfigurationReadTestCase;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;

public class LuceneIndexingParametersTest
extends ConfigurationReadTestCase {
    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.indexwriter.ram_buffer_size", "1");
        cfg.setProperty("hibernate.search.default.indexwriter.use_compound_file", "false");
        cfg.setProperty("hibernate.search.default.indexwriter.max_merge_docs", "9");
        cfg.setProperty("hibernate.search.Book.indexwriter.max_merge_docs", "12");
        cfg.setProperty("hibernate.search.Book.indexwriter.use_compound_file", "false");
        cfg.setProperty("hibernate.search.Book.indexwriter.merge_factor", "13");
        cfg.setProperty("hibernate.search.Book.indexwriter.max_buffered_docs", "14");
        cfg.setProperty("hibernate.search.Book.indexwriter.ram_buffer_size", "4");
        cfg.setProperty("hibernate.search.Book.indexwriter.merge_max_optimize_size", "256");
        cfg.setProperty("hibernate.search.Documents.indexwriter.ram_buffer_size", "default");
        cfg.setProperty("hibernate.search.Documents.indexwriter.merge_factor", "6");
        cfg.setProperty("hibernate.search.Documents.indexwriter.max_buffered_docs", "7");
        cfg.setProperty("hibernate.search.Documents.indexwriter.max_merge_docs", "9");
        cfg.setProperty("hibernate.search.Documents.indexwriter.max_field_length", "9");
    }

    public void testDefaultIndexProviderParameters() {
        this.assertValueIsSet(Author.class, IndexWriterSetting.USE_COMPOUND_FILE, 0);
        this.assertValueIsSet(Author.class, IndexWriterSetting.RAM_BUFFER_SIZE, 1);
        this.assertValueIsSet(Author.class, IndexWriterSetting.MAX_MERGE_DOCS, 9);
        this.assertValueIsSet(Author.class, IndexWriterSetting.MAX_BUFFERED_DOCS, 1000);
        this.assertValueIsSet(Author.class, IndexWriterSetting.MERGE_FACTOR, 100);
    }

    public void testSpecificTypeParametersOverride() {
        this.assertValueIsSet(Book.class, IndexWriterSetting.MAX_MERGE_DOCS, 12);
        this.assertValueIsSet(Book.class, IndexWriterSetting.MAX_BUFFERED_DOCS, 14);
        this.assertValueIsSet(Book.class, IndexWriterSetting.MERGE_FACTOR, 13);
        this.assertValueIsSet(Book.class, IndexWriterSetting.USE_COMPOUND_FILE, 0);
        this.assertValueIsSet(Book.class, IndexWriterSetting.RAM_BUFFER_SIZE, 4);
        this.assertValueIsSet(Book.class, IndexWriterSetting.MERGE_MAX_OPTIMIZE_SIZE, 256);
    }

    public void testDefaultKeywordOverwritesInherited() {
        this.assertValueIsDefault(Document.class, IndexWriterSetting.RAM_BUFFER_SIZE);
    }

    public void testSerializability() throws IOException, ClassNotFoundException {
        LuceneIndexingParameters param = new LuceneIndexingParameters(new Properties());
        LuceneIndexingParameters paramCopy = SerializationTestHelper.duplicateBySerialization(param);
        LuceneIndexingParametersTest.assertEquals((Object)param.getIndexParameters(), (Object)paramCopy.getIndexParameters());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Author.class, Document.class};
    }
}

